/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.common.component.ComponentConfig;
import org.modeshape.repository.sequencer.SequencerPathExpression;

@Immutable
public class SequencerConfig
extends ComponentConfig {
    private final Set<SequencerPathExpression> pathExpressions;

    public SequencerConfig(String name, String description, String classname, String[] classpath, String ... pathExpressions) {
        this(name, description, System.currentTimeMillis(), (Map<String, Object>)null, classname, classpath, pathExpressions);
    }

    public SequencerConfig(String name, String description, Map<String, Object> properties, String classname, String[] classpath, String ... pathExpressions) {
        this(name, description, System.currentTimeMillis(), properties, classname, classpath, pathExpressions);
    }

    public SequencerConfig(String name, String description, long timestamp, Map<String, Object> properties, String classname, String[] classpath, String ... pathExpressions) {
        super(name, description, timestamp, properties, classname, classpath);
        this.pathExpressions = SequencerConfig.buildPathExpressionSet(pathExpressions);
    }

    static Set<SequencerPathExpression> buildPathExpressionSet(String ... pathExpressions) {
        Set<SequencerPathExpression> result = null;
        if (pathExpressions != null) {
            result = new LinkedHashSet();
            for (String pathExpression : pathExpressions) {
                if (pathExpression == null || (pathExpression = pathExpression.trim()).length() == 0) continue;
                result.add(SequencerPathExpression.compile(pathExpression));
            }
            result = Collections.unmodifiableSet(result);
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    public Collection<SequencerPathExpression> getPathExpressions() {
        return Collections.unmodifiableSet(this.pathExpressions);
    }

    public boolean hasChanged(SequencerConfig that) {
        if (super.hasChanged(that)) {
            return true;
        }
        return !((Object)this.getPathExpressions()).equals(that.getPathExpressions());
    }
}

