/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.sequencer.Sequencer;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencerContext;
import org.modeshape.repository.sequencer.SequencerException;
import org.modeshape.repository.sequencer.SequencerOutputMap;
import org.modeshape.repository.util.RepositoryNodePath;

public class StreamSequencerAdapter
implements Sequencer {
    private static final Logger LOGGER = Logger.getLogger(StreamSequencerAdapter.class);
    private SequencerConfig configuration;
    private final StreamSequencer streamSequencer;

    public StreamSequencerAdapter(StreamSequencer streamSequencer) {
        this.streamSequencer = streamSequencer;
    }

    @Override
    public SequencerConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(SequencerConfig configuration) {
        this.configuration = configuration;
        if (configuration.getProperties() != null) {
            Class<?> streamSequencerClass = this.streamSequencer.getClass();
            Reflection reflection = new Reflection(streamSequencerClass);
            try {
                reflection.invokeSetterMethodOnTarget("classpath", this.streamSequencer, configuration.getComponentClasspathArray());
            }
            catch (Exception e) {
                try {
                    reflection.invokeSetterMethodOnTarget("classpath", this.streamSequencer, configuration.getComponentClasspath());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            for (Map.Entry<String, Object> entry : configuration.getProperties().entrySet()) {
                String propertyName = entry.getKey();
                try {
                    reflection.invokeSetterMethodOnTarget(propertyName, this.streamSequencer, entry.getValue());
                    LOGGER.trace("Set '{0}' property from sequencer configuration on '{1}' stream sequencer implementation to {2}", propertyName, streamSequencerClass.getName(), entry.getValue());
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception ignore) {
                    LOGGER.debug("Unable to set '{0}' property from sequencer configuration on '{1}' stream sequencer implementation", propertyName, streamSequencerClass.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Node input, String sequencedPropertyName, NetChangeObserver.NetChange changes, Set<RepositoryNodePath> outputPaths, SequencerContext context, Problems problems) throws SequencerException {
        Property sequencedProperty = input.getProperty(sequencedPropertyName);
        if (sequencedProperty == null || sequencedProperty.isEmpty()) {
            String msg = RepositoryI18n.unableToFindPropertyForSequencing.text(sequencedPropertyName, input.getLocation());
            throw new SequencerException(msg);
        }
        ValueFactories factories = context.getExecutionContext().getValueFactories();
        SequencerOutputMap output = new SequencerOutputMap(factories);
        InputStream stream = null;
        Throwable firstError = null;
        Binary binary = (Binary)factories.getBinaryFactory().create(sequencedProperty.getFirstValue());
        binary.acquire();
        try {
            stream = binary.getStream();
            StreamSequencerContext StreamSequencerContext2 = this.createStreamSequencerContext(input, sequencedProperty, context, problems);
            this.streamSequencer.sequence(stream, output, StreamSequencerContext2);
        }
        catch (Throwable t) {
            firstError = t;
        }
        finally {
            try {
                if (stream != null) {
                    try {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (Throwable t) {
                            if (firstError == null) {
                                firstError = t;
                            }
                            stream = null;
                        }
                    }
                    catch (Throwable throwable) {
                        stream = null;
                        throw throwable;
                    }
                }
                if (firstError != null) {
                    throw new SequencerException(firstError);
                }
            }
            finally {
                binary.release();
            }
        }
        HashSet<Path> builtPaths = new HashSet<Path>();
        Iterator<RepositoryNodePath> i$ = outputPaths.iterator();
        while (true) {
            if (!i$.hasNext()) {
                context.getDestination().submit();
                return;
            }
            RepositoryNodePath outputPath = i$.next();
            String repositoryWorkspaceName = outputPath.getWorkspaceName();
            String nodePath = outputPath.getNodePath();
            context.graph().useWorkspace(repositoryWorkspaceName);
            this.buildPathTo(nodePath, context, builtPaths);
            this.saveOutput(nodePath, output, context, builtPaths);
        }
    }

    private void buildPathTo(String nodePath, SequencerContext context, Set<Path> builtPaths) {
        PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
        Path targetPath = (Path)pathFactory.create(nodePath);
        this.buildPathTo(targetPath, context, builtPaths);
    }

    private void buildPathTo(Path targetPath, SequencerContext context, Set<Path> builtPaths) {
        PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getExecutionContext().getPropertyFactory();
        if (targetPath.isRoot()) {
            return;
        }
        Path workingPath = pathFactory.createRootPath();
        Path.Segment[] segments = targetPath.getSegmentsArray();
        Property primaryType = propFactory.create(JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.UNSTRUCTURED);
        int max = segments.length;
        for (int i = 0; i < max; ++i) {
            if (builtPaths.contains(workingPath = pathFactory.create(workingPath, segments[i]))) continue;
            try {
                context.graph().getNodeAt(workingPath);
                continue;
            }
            catch (PathNotFoundException pnfe) {
                context.getDestination().create(workingPath, primaryType, new Property[0]);
                builtPaths.add(workingPath);
            }
        }
    }

    protected void saveOutput(String nodePath, SequencerOutputMap output, SequencerContext context, Set<Path> builtPaths) {
        if (output.isEmpty()) {
            return;
        }
        PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
        PropertyFactory propertyFactory = context.getExecutionContext().getPropertyFactory();
        Path outputNodePath = (Path)pathFactory.create(nodePath);
        for (SequencerOutputMap.Entry entry : output) {
            Path targetNodePath = entry.getPath();
            Path absolutePath = targetNodePath.isAbsolute() ? targetNodePath : outputNodePath.resolve(targetNodePath);
            LinkedList<Property> properties = new LinkedList<Property>();
            for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                if (property.getValue() instanceof Object[]) {
                    properties.add(propertyFactory.create(property.getName(), (Object[])property.getValue()));
                    continue;
                }
                if (property.getValue() == null) continue;
                properties.add(propertyFactory.create(property.getName(), property.getValue()));
            }
            if (absolutePath.getParent() != null) {
                this.buildPathTo(absolutePath.getParent(), context, builtPaths);
            }
            context.getDestination().create(absolutePath, properties);
            builtPaths.add(absolutePath);
        }
    }

    protected String[] extractMixinTypes(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return null;
    }

    protected StreamSequencerContext createStreamSequencerContext(Node input, Property sequencedProperty, SequencerContext context, Problems problems) {
        assert (input != null);
        assert (sequencedProperty != null);
        assert (context != null);
        assert (problems != null);
        ValueFactories factories = context.getExecutionContext().getValueFactories();
        Path path = (Path)factories.getPathFactory().create(input.getLocation().getPath());
        Set<Property> props = Collections.unmodifiableSet(input.getPropertiesByName().values());
        Name fileName = path.getLastSegment().getName();
        if (JcrLexicon.CONTENT.equals(fileName) && !path.isRoot()) {
            fileName = path.getParent().getLastSegment().getName();
        }
        String mimeType = this.getMimeType(context, sequencedProperty, fileName.getLocalName());
        return new StreamSequencerContext(context.getExecutionContext(), path, props, mimeType, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(SequencerContext context, Property sequencedProperty, String name) {
        SequencerException err = null;
        String mimeType = null;
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(sequencedProperty.toString().getBytes());
            String string = mimeType = context.getExecutionContext().getMimeTypeDetector().mimeTypeOf(name, stream);
            return string;
        }
        catch (Exception error) {
            err = new SequencerException(error);
        }
        finally {
            block13: {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException error) {
                        if (err != null) break block13;
                        err = new SequencerException(error);
                    }
                }
            }
        }
        throw err;
    }
}

