/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.repository.RepositoryI18n;

@Immutable
public class RepositoryNodePath {
    protected static final Pattern PATTERN = Pattern.compile("([^:/]):(/.*)");
    private final String repositorySourceName;
    private final String workspaceName;
    private final String nodePath;
    private final int hc;

    public static RepositoryNodePath parse(String path, String repositorySourceName, String defaultRepositoryWorkspaceName) {
        Matcher matcher = PATTERN.matcher(path);
        if (matcher.matches()) {
            try {
                return new RepositoryNodePath(repositorySourceName, matcher.group(1), matcher.group(2));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(RepositoryI18n.invalidRepositoryNodePath.text(path, t.getMessage()));
            }
        }
        return new RepositoryNodePath(repositorySourceName, defaultRepositoryWorkspaceName, path);
    }

    public RepositoryNodePath(String repositorySourceName, String workspaceName, String nodePath) {
        this.repositorySourceName = repositorySourceName;
        this.workspaceName = workspaceName;
        this.nodePath = nodePath;
        this.hc = HashCode.compute(this.repositorySourceName, this.workspaceName, this.nodePath);
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public String getRepositorySourceName() {
        return this.repositorySourceName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RepositoryNodePath) {
            RepositoryNodePath that = (RepositoryNodePath)obj;
            if (!this.repositorySourceName.equals(that.repositorySourceName)) {
                return false;
            }
            if (!this.workspaceName.equals(that.workspaceName)) {
                return false;
            }
            return this.nodePath.equals(that.nodePath);
        }
        return false;
    }

    public String toString() {
        return this.repositorySourceName + ":" + this.workspaceName + ":" + this.nodePath;
    }
}

