/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jdbc.delegate.LocalRepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;

public class RepositoryDelegateFactoryTest {
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final String USER_NAME = "jsmith";
    private static final String PASSWORD = "secret";
    private static final String WORKSPACE = "MyWorkspace";
    private static final String JNDINAME = "java:MyRepository";
    private static final String INVALID_URL = "jdbc:metamatrix:jndi://";
    private static final String VALID_HTTP_URL = "jdbc:jcr:http://server:host";
    private static final String VALID_JNDI_URL = "jdbc:jcr:jndi:java:MyRepository";
    private static final String VALID_JNDI_URL_WITH_PARMS = "jdbc:jcr:jndi:java:MyRepository?workspace=MyWorkspace&username=jsmith&password=secret&repositoryName=repositoryName";

    @Test
    public void shouldCreateLocalRepositoryDelegate() throws SQLException {
        RepositoryDelegate delegate = RepositoryDelegateFactory.createRepositoryDelegate((String)VALID_JNDI_URL_WITH_PARMS, (Properties)new Properties(), null);
        Assert.assertThat((Object)delegate, (Matcher)IsInstanceOf.instanceOf(LocalRepositoryDelegate.class));
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void shouldNotSupportCreatingHttpRepositoryDelegate() throws SQLException {
        RepositoryDelegateFactory.createRepositoryDelegate((String)VALID_HTTP_URL, (Properties)new Properties(), null);
    }

    @Test(expected=SQLException.class)
    public void shouldNotSupportCreatingInvalidURL() throws SQLException {
        RepositoryDelegateFactory.createRepositoryDelegate((String)INVALID_URL, (Properties)new Properties(), null);
    }

    @Test
    public void shouldAcceptValidURL() {
        Assert.assertThat((Object)RepositoryDelegateFactory.acceptUrl((String)VALID_JNDI_URL_WITH_PARMS), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)RepositoryDelegateFactory.acceptUrl((String)VALID_JNDI_URL), (Matcher)Is.is((Object)true));
    }

    public void shouldNotAcceptInvalidURL() {
        Assert.assertThat((Object)RepositoryDelegateFactory.acceptUrl((String)INVALID_URL), (Matcher)Is.is((Object)false));
    }
}

