/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.FindAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class FormUrlEncodedProvider
implements MessageBodyReader<MultivaluedMap<String, String>>,
MessageBodyWriter<MultivaluedMap<String, String>> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!MultivaluedMap.class.isAssignableFrom(type)) {
            return false;
        }
        if (genericType == null) {
            return true;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType params = (ParameterizedType)genericType;
        if (params.getActualTypeArguments().length != 2) {
            return false;
        }
        return params.getActualTypeArguments()[0].equals(String.class) && params.getActualTypeArguments()[1].equals(String.class);
    }

    @Override
    public MultivaluedMap<String, String> readFrom(Class<MultivaluedMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        boolean encoded;
        boolean bl = encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        if (encoded) {
            return FormUrlEncodedProvider.parseForm(entityStream);
        }
        return Encode.decode(FormUrlEncodedProvider.parseForm(entityStream));
    }

    public static MultivaluedMap<String, String> parseForm(InputStream entityStream) throws IOException {
        String[] params;
        char[] buffer = new char[100];
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 100)) <= 0) continue;
            buf.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        String form = buf.toString();
        MultivaluedMapImpl<String, String> formData = new MultivaluedMapImpl<String, String>();
        for (String param : params = form.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=");
                String val = nv.length > 1 ? nv[1] : "";
                formData.add(nv[0], val);
                continue;
            }
            formData.add(param, "");
        }
        return formData;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!MultivaluedMap.class.isAssignableFrom(type)) {
            return false;
        }
        if (genericType == null) {
            return true;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType params = (ParameterizedType)genericType;
        if (params.getActualTypeArguments().length != 2) {
            return false;
        }
        return params.getActualTypeArguments()[0].equals(String.class) && params.getActualTypeArguments()[1].equals(String.class);
    }

    @Override
    public long getSize(MultivaluedMap<String, String> stringStringMultivaluedMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(MultivaluedMap<String, String> formData, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        boolean encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        boolean first = true;
        for (Map.Entry entry : formData.entrySet()) {
            String encodedName = (String)entry.getKey();
            if (!encoded) {
                encodedName = URLEncoder.encode((String)entry.getKey(), "UTF-8");
            }
            for (String value : (List)entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    writer.write("&");
                }
                if (!encoded) {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                writer.write(encodedName);
                writer.write("=");
                writer.write(value);
            }
            writer.flush();
        }
        byte[] bytes = baos.toByteArray();
        httpHeaders.putSingle("Content-Length", Integer.toString(bytes.length));
        entityStream.write(bytes);
    }
}

