/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.modeshape.jdbc.JcrBlob;
import org.modeshape.jdbc.Transform;
import org.modeshape.jdbc.types.BlobTransform;
import org.modeshape.jdbc.types.BooleanTransform;
import org.modeshape.jdbc.types.DateTransform;
import org.modeshape.jdbc.types.FloatTransform;
import org.modeshape.jdbc.types.LongTransform;
import org.modeshape.jdbc.types.StringTransform;
import org.modeshape.jdbc.types.UUIDTransform;

public final class JcrType {
    private static final Map<String, JcrType> TYPE_INFO;
    private final int jcrType;
    private final String jcrName;
    private final Class<?> clazz;
    private final int jdbcType;
    private final int displaySize;
    private final int precision;
    private final Transform transform;

    private static void register(Map<String, JcrType> types, int jcrType, int jdbcType, Class<?> clazz, int displaySize, int precision, Transform transform) {
        JcrType type = new JcrType(jcrType, jdbcType, clazz, displaySize, precision, transform);
        types.put(type.getJcrName(), type);
    }

    protected JcrType(int jcrType, int jdbcType, Class<?> clazz, int displaySize, int precision, Transform transform) {
        this.jcrType = jcrType;
        this.jcrName = PropertyType.nameFromValue(jcrType);
        this.clazz = clazz;
        this.displaySize = displaySize;
        this.jdbcType = jdbcType;
        this.precision = precision;
        this.transform = transform;
        assert (this.jcrName != null);
        assert (this.clazz != null);
        assert (this.displaySize > 0);
        assert (this.transform != null);
    }

    public String getJcrName() {
        return this.jcrName;
    }

    public int getJcrType() {
        return this.jcrType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public Integer getDefaultPrecision() {
        return new Integer(this.precision);
    }

    protected Transform getTransform() {
        return this.transform;
    }

    public boolean isCaseSensitive() {
        switch (this.getJcrType()) {
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public boolean isSigned() {
        switch (this.getJcrType()) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public Class<?> getRepresentationClass() {
        return this.clazz;
    }

    public int getNominalDisplaySize() {
        return this.displaySize;
    }

    public Object translateValue(Value value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return this.getTransform().transform(value);
        }
        catch (ValueFormatException ve) {
            throw new SQLException(ve.getLocalizedMessage(), ve);
        }
        catch (IllegalStateException ie) {
            throw new SQLException(ie.getLocalizedMessage(), ie);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    public static Object translateValueToJDBC(Value value) throws SQLException {
        String jcrName = PropertyType.nameFromValue(value.getType());
        JcrType jcrtype = JcrType.typeInfo(jcrName);
        return jcrtype.translateValue(value);
    }

    public static Map<String, JcrType> builtInTypeMap() {
        return TYPE_INFO;
    }

    public static JcrType typeInfo(String typeName) {
        return TYPE_INFO.get(typeName);
    }

    public static JcrType typeInfo(int jcrType) {
        return JcrType.typeInfo(PropertyType.nameFromValue(jcrType));
    }

    static {
        HashMap<String, JcrType> types = new HashMap<String, JcrType>();
        JcrType.register(types, 2, 2004, JcrBlob.class, 30, Integer.MAX_VALUE, new BlobTransform());
        JcrType.register(types, 6, 16, Boolean.class, 5, 1, new BooleanTransform());
        JcrType.register(types, 5, 93, Timestamp.class, 30, 10, new DateTransform());
        JcrType.register(types, 4, 6, Float.class, 20, 20, new FloatTransform());
        JcrType.register(types, 3, -5, Long.class, 20, 19, new LongTransform());
        JcrType.register(types, 7, 12, String.class, 20, Integer.MAX_VALUE, new StringTransform());
        JcrType.register(types, 8, 12, String.class, 50, Integer.MAX_VALUE, new StringTransform());
        JcrType.register(types, 9, 2004, UUID.class, UUID.randomUUID().toString().length(), UUID.randomUUID().toString().length(), new UUIDTransform());
        JcrType.register(types, 1, 12, String.class, 50, Integer.MAX_VALUE, new StringTransform());
        JcrType.register(types, 0, 12, String.class, 50, Integer.MAX_VALUE, new StringTransform());
        TYPE_INFO = Collections.unmodifiableMap(types);
    }

    public static final class DefaultDataTypes {
        public static final String STRING = "String";
        public static final String BOOLEAN = "Boolean";
        public static final String LONG = "Long";
        public static final String DOUBLE = "Double";
        public static final String DECIMAL = "Decimal";
        public static final String DATE = "Date";
        public static final String URI = "URI";
        public static final String WEAK_REF = "WeakReference";
        public static final String UNDEFINED = "undefined";
        public static final String BINARY = "Binary";
        public static final String REFERENCE = "Reference";
        public static final String PATH = "Path";
        public static final String NAME = "Name";
    }
}

