/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.QueryResult;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.delegate.AbstractRepositoryDelegate;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonRestClient;

public class HttpRepositoryDelegate
extends AbstractRepositoryDelegate {
    private static final String HTTP_EXAMPLE_URL = "jdbc:jcr:http://{hostname}:{port}/{context root}";
    private static final String URL_PATH = "/jcr:system/jcr:nodeTypes";
    private static final String URL_DEPTH = "?depth=5";
    private JsonRestClient restClient;
    private Workspace workspace = null;
    private Map<String, NodeType> nodeTypes;

    public HttpRepositoryDelegate(String url, Properties info, JcrDriver.JcrContextFactory contextFactory) {
        super(url, info);
    }

    @Override
    protected ConnectionInfo createConnectionInfo(String url, Properties info) {
        return new HttpConnectionInfo(url, info);
    }

    @Override
    public QueryResult execute(String query, String language) throws RepositoryException {
        LOGGER.trace("Executing query: {0}" + query, new Object[0]);
        try {
            List<QueryRow> results = this.restClient.query(this.workspace, language, query);
            for (QueryRow row : results) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getDescriptor(String descriptorKey) {
        return "";
    }

    @Override
    public synchronized NodeType nodeType(String name) throws RepositoryException {
        NodeType nodetype;
        if (this.nodeTypes == null) {
            this.nodeTypes();
        }
        if ((nodetype = this.nodeTypes.get(name)) == null) {
            throw new RepositoryException(JdbcI18n.unableToGetNodeType.text(name));
        }
        return nodetype;
    }

    @Override
    public synchronized List<NodeType> nodeTypes() throws RepositoryException {
        if (this.nodeTypes == null) {
            try {
                Collection<org.modeshape.web.jcr.rest.client.domain.NodeType> results = this.restClient.getNodeTypes(this.workspace, URL_PATH, URL_DEPTH);
                if (results == null || results.size() == 0) {
                    String msg = JdbcI18n.noNodeTypesReturned.text(this.workspace.getServer().getUrl() + "/" + this.workspace.getRepository().getName() + "/" + this.workspace.getName() + URL_PATH + URL_DEPTH);
                    throw new RepositoryException(msg);
                }
                HashMap<String, NodeType> loadingNodeTypes = new HashMap<String, NodeType>(results.size());
                for (org.modeshape.web.jcr.rest.client.domain.NodeType nodetype : results) {
                    if (nodetype == null) continue;
                    HttpNodeType localnodetype = new HttpNodeType(nodetype);
                    loadingNodeTypes.put(localnodetype.getName(), localnodetype);
                }
                this.nodeTypes = loadingNodeTypes;
            }
            catch (Exception e) {
                throw new RepositoryException(JdbcI18n.unableToGetNodeTypes.text(this.workspace.getRepository().getName()), e);
            }
        }
        return new ArrayList<NodeType>(this.nodeTypes.values());
    }

    @Override
    protected void createRepository() throws SQLException {
        LOGGER.debug("Creating repository for HttpRepositoryDelegte", new Object[0]);
        ConnectionInfo info = this.getConnectionInfo();
        assert (info != null);
        String path = info.getRepositoryPath();
        if (path == null) {
            throw new SQLException("Missing repo path from " + info.getUrl());
        }
        if (info.getUsername() == null) {
            throw new SQLException("Missing username from " + info.getUrl());
        }
        if (info.getPassword() == null) {
            throw new SQLException("Missing password path from " + info.getUrl());
        }
        if (info.getRepositoryName() == null) {
            throw new SQLException("Missing repo name from " + info.getUrl());
        }
        Server server = new Server("http://" + path, info.getUsername(), new String(info.getPassword()));
        Repository repo = new Repository(info.getRepositoryName(), server);
        this.workspace = new Workspace(info.getWorkspaceName(), repo);
        this.restClient = new JsonRestClient();
        try {
            this.restClient.getRepositories(server);
        }
        catch (Exception e) {
            throw new SQLException(JdbcI18n.noRepositoryNamesFound.text(new Object[0]), e);
        }
        HashSet<String> repositoryNames = new HashSet<String>(1);
        repositoryNames.add(info.getRepositoryName());
        this.setRepositoryNames(repositoryNames);
    }

    @Override
    public boolean isValid(int timeout) throws RepositoryException {
        return false;
    }

    @Override
    public void commit() throws RepositoryException {
    }

    @Override
    public void rollback() throws RepositoryException {
    }

    @Override
    public void close() {
        this.restClient = null;
        this.workspace = null;
        if (this.nodeTypes != null) {
            this.nodeTypes.clear();
        }
    }

    protected class HttpPropertyDefinition
    implements PropertyDefinition {
        private Properties properties = null;
        private String name;

        public HttpPropertyDefinition(String name, Properties nodeTypeProperties) {
            this.properties = nodeTypeProperties;
            this.name = name;
        }

        @Override
        public String[] getAvailableQueryOperators() {
            return null;
        }

        @Override
        public Value[] getDefaultValues() {
            return null;
        }

        @Override
        public int getRequiredType() {
            return 0;
        }

        @Override
        public String[] getValueConstraints() {
            return null;
        }

        @Override
        public boolean isFullTextSearchable() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public boolean isQueryOrderable() {
            return true;
        }

        @Override
        public NodeType getDeclaringNodeType() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getOnParentVersion() {
            return 0;
        }

        @Override
        public boolean isAutoCreated() {
            return this.convertBoolean("jcr:autoCreated");
        }

        @Override
        public boolean isMandatory() {
            return this.convertBoolean("jcr:mandatory");
        }

        @Override
        public boolean isProtected() {
            return this.convertBoolean("jcr:protected");
        }

        private boolean convertBoolean(String key) {
            String value = this.properties.getProperty(key);
            return value != null && !value.equalsIgnoreCase("false");
        }
    }

    protected class HttpNodeType
    implements NodeType {
        private org.modeshape.web.jcr.rest.client.domain.NodeType restnodetype;

        public HttpNodeType(org.modeshape.web.jcr.rest.client.domain.NodeType nodetype) {
            assert (nodetype != null);
            this.restnodetype = nodetype;
        }

        public void setNodeType(org.modeshape.web.jcr.rest.client.domain.NodeType nodetype) {
            this.restnodetype = nodetype;
        }

        public org.modeshape.web.jcr.rest.client.domain.NodeType getNodeType() {
            return this.restnodetype;
        }

        public boolean hasProperties() {
            return this.restnodetype.getProperties().size() > 0;
        }

        @Override
        public String getName() {
            return this.restnodetype.getName();
        }

        @Override
        public String getPrimaryItemName() {
            return this.restnodetype.getProperty("jcr:primaryItemName");
        }

        @Override
        public boolean isMixin() {
            return this.convertBoolean("jcr:isMixin");
        }

        @Override
        public boolean isQueryable() {
            return this.convertBoolean("jcr:isQueryable");
        }

        @Override
        public boolean canAddChildNode(String arg0) {
            return false;
        }

        @Override
        public boolean canAddChildNode(String arg0, String arg1) {
            return false;
        }

        @Override
        public boolean canRemoveItem(String arg0) {
            return false;
        }

        @Override
        public boolean canRemoveNode(String arg0) {
            return false;
        }

        @Override
        public boolean canRemoveProperty(String arg0) {
            return false;
        }

        @Override
        public boolean canSetProperty(String arg0, Value arg1) {
            return false;
        }

        @Override
        public boolean canSetProperty(String arg0, Value[] arg1) {
            return false;
        }

        @Override
        public NodeDefinition[] getChildNodeDefinitions() {
            return null;
        }

        @Override
        public NodeTypeIterator getDeclaredSubtypes() {
            return null;
        }

        @Override
        public NodeType[] getDeclaredSupertypes() {
            return null;
        }

        @Override
        public NodeTypeIterator getSubtypes() {
            return null;
        }

        @Override
        public NodeType[] getSupertypes() {
            return null;
        }

        @Override
        public boolean isNodeType(String arg0) {
            String value = this.restnodetype.getProperty("jcr:nodeTypeName");
            return value != null && arg0.equals(value);
        }

        @Override
        public NodeDefinition[] getDeclaredChildNodeDefinitions() {
            return null;
        }

        @Override
        public PropertyDefinition[] getDeclaredPropertyDefinitions() {
            return null;
        }

        @Override
        public String[] getDeclaredSupertypeNames() {
            return null;
        }

        @Override
        public boolean hasOrderableChildNodes() {
            return this.convertBoolean("jcr:hasOrderableChildNodes");
        }

        @Override
        public boolean isAbstract() {
            return this.convertBoolean("jcr:isAbstract");
        }

        @Override
        public PropertyDefinition[] getPropertyDefinitions() {
            HttpPropertyDefinition propDefn;
            PropertyDefinition[] defns = null;
            int cnt = this.restnodetype.getPropertyDefinitions().size() + this.restnodetype.getChildNodeDefinitions().size();
            defns = new PropertyDefinition[cnt];
            int i = 0;
            if (this.restnodetype.getPropertyDefinitions() != null) {
                for (org.modeshape.web.jcr.rest.client.domain.NodeType nt : this.restnodetype.getPropertyDefinitions()) {
                    propDefn = new HttpPropertyDefinition(nt.getName(), nt.getProperties());
                    defns[i] = propDefn;
                    ++i;
                }
            }
            if (this.restnodetype.getChildNodeDefinitions() != null) {
                for (org.modeshape.web.jcr.rest.client.domain.NodeType nt : this.restnodetype.getChildNodeDefinitions()) {
                    propDefn = new HttpPropertyDefinition(nt.getName(), nt.getProperties());
                    defns[i] = propDefn;
                    ++i;
                }
            }
            return defns;
        }

        private boolean convertBoolean(String key) {
            String value = this.restnodetype.getProperty(key);
            return value != null && !value.equalsIgnoreCase("false");
        }
    }

    class HttpConnectionInfo
    extends ConnectionInfo {
        protected HttpConnectionInfo(String url, Properties properties) {
            super(url, properties);
        }

        @Override
        protected void init() {
            super.init();
            StringBuilder url = new StringBuilder();
            String[] urlsections = this.repositoryPath.split("/");
            if (urlsections.length < 3) {
                return;
            }
            int workspacePos = -1;
            int repositoryPos = -1;
            int repoPos = 1;
            if (this.getWorkspaceName() == null && urlsections.length > 3) {
                workspacePos = urlsections.length - 1;
                String workspaceName = urlsections[workspacePos];
                this.setWorkspaceName(workspaceName);
                repoPos = 2;
            }
            if (this.getRepositoryName() == null && urlsections.length > 2) {
                repositoryPos = urlsections.length - repoPos;
                String repositoryName = urlsections[repositoryPos];
                this.setRepositoryName(repositoryName);
            }
            for (int i = 0; i < repositoryPos; ++i) {
                url.append(urlsections[i]);
                if (i >= repositoryPos - 1) continue;
                url.append("/");
            }
            this.repositoryPath = url.toString();
        }

        @Override
        public String getUrlExample() {
            return HttpRepositoryDelegate.HTTP_EXAMPLE_URL;
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:jcr:http://";
        }

        @Override
        protected void addUrlPropertyInfo(List<DriverPropertyInfo> results) {
            if (this.repositoryPath.indexOf("/") == -1) {
                this.setUrl(null);
            }
            super.addUrlPropertyInfo(results);
        }
    }
}

