/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Context;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.security.config.IDTrustConfiguration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jdbc.ConnectionResultsComparator;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrDriverIntegrationTest
extends ConnectionResultsComparator {
    @Mock
    private Context jndi;
    private JcrDriver driver;
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static JcrRepository repository;
    private JcrConnection connection;
    private DatabaseMetaData dbmd;
    private static String jndiNameForRepository;
    private static String validUrl;
    private JcrDriver.JcrContextFactory contextFactory;

    protected static URL resourceUrl(String name) {
        return JcrDriverIntegrationTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrDriverIntegrationTest.class.getClassLoader().getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void beforeAll() throws Exception {
        configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
        configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrDriverIntegrationTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite,admin").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        engine = configuration.build();
        engine.start();
        String configFile = "security/jaas.conf.xml";
        IDTrustConfiguration idtrustConfig = new IDTrustConfiguration();
        try {
            idtrustConfig.config(configFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        try {
            repository = engine.getRepository("cars");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        Session session = repository.login();
        try {
            InputStream stream = JcrDriverIntegrationTest.resourceStream("cars-system-view.xml");
            Assert.assertNotNull((Object)stream);
            try {
                session.getWorkspace().importXML("/", stream, 0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                stream.close();
            }
            Node other = session.getRootNode().addNode("Other", "nt:unstructured");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value3 quick brown fox");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value2 quick brown cat");
            other.addNode("NodeA", "nt:unstructured").setProperty("something", "value1 quick black dog");
            session.getRootNode().addNode("NodeB", "nt:unstructured").setProperty("myUrl", "http://www.acme.com/foo/bar");
            session.save();
        }
        finally {
            session.logout();
        }
    }

    @AfterClass
    public static void afterAll() throws Exception {
        engine.shutdown();
        engine.awaitTermination(3L, TimeUnit.SECONDS);
        engine = null;
        configuration = null;
    }

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.jndi.lookup(jndiNameForRepository)).thenReturn((Object)repository);
        this.contextFactory = new JcrDriver.JcrContextFactory(){

            public Context createContext(Properties properties) {
                return JcrDriverIntegrationTest.this.jndi;
            }
        };
        this.driver = new JcrDriver();
        this.driver.setContextFactory(this.contextFactory);
        Properties validProperties = new Properties();
        this.connection = (JcrConnection)this.driver.connect(validUrl, validProperties);
        this.dbmd = this.connection.getMetaData();
        this.compareColumns = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        DriverManager.deregisterDriver((Driver)this.driver);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
        }
        this.driver = null;
        this.contextFactory = null;
        this.dbmd = null;
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)engine.getRepositoryService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldBeAbleToExecuteSqlSelectAllNodes() throws SQLException {
        String[] expected = new String[]{"jcr:primaryType[STRING]", "mode:root", "car:Car", "car:Car", "nt:unstructured", "nt:unstructured", "car:Car", "nt:unstructured", "car:Car", "car:Car", "car:Car", "car:Car", "nt:unstructured", "car:Car", "nt:unstructured", "car:Car", "car:Car", "car:Car", "car:Car", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured"};
        JcrDriverIntegrationTest.executeTest((Connection)this.connection, "SELECT * FROM [nt:base]", expected, 23);
    }

    @Test
    public void shouldBeAbleToExecuteSqlSelectAllCars() throws SQLException {
        String[] expected = new String[]{"car:maker[STRING]    car:model[STRING]    car:year[STRING]    car:msrp[STRING]    car:userRating[LONG]    car:valueRating[LONG]    car:mpgCity[LONG]    car:mpgHighway[LONG]    car:lengthInInches[DOUBLE]    car:wheelbaseInInches[DOUBLE]    car:engine[STRING]    jcr:primaryType[STRING]", "Hummer    H3    2008    $30,595    3    4    13    16    null    null    null    car:Car", "Infiniti    G37    2008    $34,900    3    4    18    24    null    null    null    car:Car", "Cadillac    DTS    2008    null    1    null    null    null    null    null    3.6 liter V6    car:Car", "Nissan    Altima    2008    $18,260    null    null    23    32    null    null    null    car:Car", "Land Rover    LR2    2008    $33,985    4    5    16    23    null    null    null    car:Car", "Toyota    Prius    2008    $21,500    4    5    48    45    null    null    null    car:Car", "Ford    F-150    2008    $23,910    5    1    14    20    null    null    null    car:Car", "Aston Martin    DB9    2008    $171,600    5    null    12    19    185.5    108.0    5,935 cc 5.9 liters V 12    car:Car", "Bentley    Continental    2008    $170,990    null    null    10    17    null    null    null    car:Car", "Land Rover    LR3    2008    $48,525    5    2    12    17    null    null    null    car:Car", "Toyota    Highlander    2008    $34,200    4    5    27    25    null    null    null    car:Car", "Lexus    IS350    2008    $36,305    4    5    18    25    null    null    null    car:Car"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT * FROM [car:Car]", expected, 12);
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryWithOrderByClauseUsingDefault() throws SQLException {
        String[] expected = new String[]{"car:maker[STRING]    car:model[STRING]    car:year[STRING]    car:msrp[STRING]    car:userRating[LONG]    car:valueRating[LONG]    car:mpgCity[LONG]    car:mpgHighway[LONG]    car:lengthInInches[DOUBLE]    car:wheelbaseInInches[DOUBLE]    car:engine[STRING]    jcr:primaryType[STRING]", "Aston Martin    DB9    2008    $171,600    5    null    12    19    185.5    108.0    5,935 cc 5.9 liters V 12    car:Car", "Bentley    Continental    2008    $170,990    null    null    10    17    null    null    null    car:Car", "Cadillac    DTS    2008    null    1    null    null    null    null    null    3.6 liter V6    car:Car", "Ford    F-150    2008    $23,910    5    1    14    20    null    null    null    car:Car", "Hummer    H3    2008    $30,595    3    4    13    16    null    null    null    car:Car", "Infiniti    G37    2008    $34,900    3    4    18    24    null    null    null    car:Car", "Land Rover    LR2    2008    $33,985    4    5    16    23    null    null    null    car:Car", "Land Rover    LR3    2008    $48,525    5    2    12    17    null    null    null    car:Car", "Lexus    IS350    2008    $36,305    4    5    18    25    null    null    null    car:Car", "Nissan    Altima    2008    $18,260    null    null    23    32    null    null    null    car:Car", "Toyota    Prius    2008    $21,500    4    5    48    45    null    null    null    car:Car", "Toyota    Highlander    2008    $34,200    4    5    27    25    null    null    null    car:Car"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT * FROM [car:Car] ORDER BY [car:maker]", expected, 12);
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryWithOrderByClauseAsc() throws SQLException {
        String[] expected = new String[]{"car:model[STRING]", "Altima", "Continental", "DB9", "DTS", "F-150", "G37", "H3", "Highlander", "IS350", "LR2", "LR3", "Prius"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT car.[car:model] FROM [car:Car] As car WHERE car.[car:model] IS NOT NULL ORDER BY car.[car:model] ASC", expected, 12);
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryWithOrderedByClauseDesc() throws SQLException {
        String[] expected = new String[]{"car:maker[STRING]    car:model[STRING]    car:year[STRING]    car:msrp[STRING]    car:userRating[LONG]    car:valueRating[LONG]    car:mpgCity[LONG]    car:mpgHighway[LONG]    car:lengthInInches[DOUBLE]    car:wheelbaseInInches[DOUBLE]    car:engine[STRING]    jcr:primaryType[STRING]", "Land Rover    LR3    2008    $48,525    5    2    12    17    null    null    null    car:Car", "Lexus    IS350    2008    $36,305    4    5    18    25    null    null    null    car:Car", "Infiniti    G37    2008    $34,900    3    4    18    24    null    null    null    car:Car", "Toyota    Highlander    2008    $34,200    4    5    27    25    null    null    null    car:Car", "Land Rover    LR2    2008    $33,985    4    5    16    23    null    null    null    car:Car", "Hummer    H3    2008    $30,595    3    4    13    16    null    null    null    car:Car", "Ford    F-150    2008    $23,910    5    1    14    20    null    null    null    car:Car", "Toyota    Prius    2008    $21,500    4    5    48    45    null    null    null    car:Car", "Nissan    Altima    2008    $18,260    null    null    23    32    null    null    null    car:Car", "Aston Martin    DB9    2008    $171,600    5    null    12    19    185.5    108.0    5,935 cc 5.9 liters V 12    car:Car", "Bentley    Continental    2008    $170,990    null    null    10    17    null    null    null    car:Car", "Cadillac    DTS    2008    null    1    null    null    null    null    null    3.6 liter V6    car:Car"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT * FROM [car:Car] ORDER BY [car:msrp] DESC", expected, 12);
    }

    @Test
    public void shouldBeAbleToCreateAndExecuteSqlQueryToFindAllCarsUnderHybrid() throws SQLException {
        String[] expected = new String[]{"car:maker[STRING]    car:model[STRING]    car:year[STRING]    car:msrp[STRING]", "Nissan    Altima    2008    $18,260", "Toyota    Prius    2008    $21,500", "Toyota    Highlander    2008    $34,200"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT car.[car:maker], car.[car:model], car.[car:year], car.[car:msrp] FROM [car:Car] AS car WHERE PATH(car) LIKE '%/Hybrid/%'", expected, 3);
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryUsingJoinToFindAllCarsUnderHybrid() throws SQLException {
        String[] expected = new String[]{"car:maker[STRING]    car:model[STRING]    car:year[STRING]    car:msrp[STRING]", "Nissan    Altima    2008    $18,260", "Toyota    Prius    2008    $21,500", "Toyota    Highlander    2008    $34,200"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT car.[car:maker], car.[car:model], car.[car:year], car.[car:msrp] FROM [car:Car] AS car JOIN [nt:unstructured] AS hybrid ON ISCHILDNODE(car,hybrid) WHERE NAME(hybrid) = 'Hybrid'", expected, 3);
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryToFindAllUnstructuredNodes() throws SQLException {
        String[] expected = new String[]{"jcr:primaryType[STRING]", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "nt:unstructured", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car", "car:Car"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT * FROM [nt:unstructured]", expected, 22);
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryWithChildAxisCriteria() throws SQLException {
        String[] expected = new String[]{"jcr:path[STRING]    jcr:score[DOUBLE]    jcr:primaryType[STRING]", "/Cars/Utility    1.0    nt:unstructured", "/Cars/Hybrid    1.0    nt:unstructured", "/Cars/Sports    1.0    nt:unstructured", "/Cars/Luxury    1.0    nt:unstructured"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT * FROM nt:base WHERE jcr:path LIKE '/Cars/%' AND NOT jcr:path LIKE '/Cars/%/%' ", expected, 4, "sql");
    }

    @Test
    public void shouldBeAbleToExecuteSqlQueryWithContainsCriteria() throws SQLException {
        String[] expected = new String[]{"jcr:path[STRING]    jcr:score[DOUBLE]    jcr:primaryType[STRING]", "/Cars/Utility    1.0    nt:unstructured", "/Cars/Hybrid    1.0    nt:unstructured", "/Cars/Sports    1.0    nt:unstructured", "/Cars/Luxury    1.0    nt:unstructured"};
        ConnectionResultsComparator.executeTest((Connection)this.connection, "SELECT * FROM nt:base WHERE jcr:path LIKE '/Cars/%' AND NOT jcr:path LIKE '/Cars/%/%'", expected, 4, "sql");
    }

    @Test
    public void shouldGetCatalogs() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]", "cars"};
        ResultSet rs = this.dbmd.getCatalogs();
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(1);
    }

    @Test
    public void shouldGetTableTypes() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_TYPE[String]", "VIEW"};
        ResultSet rs = this.dbmd.getTableTypes();
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(1);
    }

    @Test
    public void shouldGetAllTables() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    TABLE_TYPE[String]    REMARKS[String]    TYPE_CAT[String]    TYPE_SCHEM[String]    TYPE_NAME[String]    SELF_REFERENCING_COL_NAME[String]    REF_GENERATION[String]", "cars    NULL    car:Car    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:created    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:etag    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:language    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:lastModified    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:lifecycle    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:lockable    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:managedRetention    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:mimeType    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:referenceable    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:shareable    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:simpleVersionable    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:title    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mix:versionable    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:defined    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:hashed    VIEW    Is Mixin: true    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:lock    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:locks    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:namespace    VIEW    Is Mixin: false    NULL    NULL    NULL    mode:uri    DERIVED", "cars    NULL    mode:namespaces    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:nodeTypes    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:resource    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:data    DERIVED", "cars    NULL    mode:root    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:share    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:system    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    mode:versionStorage    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:activity    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:address    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:base    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:childNodeDefinition    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:configuration    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:file    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:content    DERIVED", "cars    NULL    nt:folder    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:frozenNode    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:hierarchyNode    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:linkedFile    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:content    DERIVED", "cars    NULL    nt:naturalText    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:nodeType    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:propertyDefinition    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:query    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:resource    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:data    DERIVED", "cars    NULL    nt:unstructured    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:version    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:versionHistory    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:versionLabels    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:versionedChild    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED"};
        ResultSet rs = this.dbmd.getTables("%", "%", "%", new String[0]);
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(44);
    }

    @Test
    public void shouldGetNTPrefixedTables() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    TABLE_TYPE[String]    REMARKS[String]    TYPE_CAT[String]    TYPE_SCHEM[String]    TYPE_NAME[String]    SELF_REFERENCING_COL_NAME[String]    REF_GENERATION[String]", "cars    NULL    nt:activity    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:address    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:base    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:childNodeDefinition    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:configuration    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:file    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:content    DERIVED", "cars    NULL    nt:folder    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:frozenNode    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:hierarchyNode    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:linkedFile    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:content    DERIVED", "cars    NULL    nt:naturalText    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:nodeType    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:propertyDefinition    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:query    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:resource    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:data    DERIVED", "cars    NULL    nt:unstructured    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:version    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:versionHistory    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:versionLabels    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:versionedChild    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED"};
        ResultSet rs = this.dbmd.getTables("%", "%", "nt:%", new String[0]);
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(20);
    }

    @Test
    public void shouldGetResourceSuffixedTables() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    TABLE_TYPE[String]    REMARKS[String]    TYPE_CAT[String]    TYPE_SCHEM[String]    TYPE_NAME[String]    SELF_REFERENCING_COL_NAME[String]    REF_GENERATION[String]", "cars    NULL    mode:resource    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:data    DERIVED", "cars    NULL    nt:resource    VIEW    Is Mixin: false    NULL    NULL    NULL    jcr:data    DERIVED"};
        ResultSet rs = this.dbmd.getTables("%", "%", "%:resource", new String[0]);
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(20);
    }

    @Test
    public void shouldGetTablesThatContainNodeTpe() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    TABLE_TYPE[String]    REMARKS[String]    TYPE_CAT[String]    TYPE_SCHEM[String]    TYPE_NAME[String]    SELF_REFERENCING_COL_NAME[String]    REF_GENERATION[String]", "cars    NULL    mode:nodeTypes    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED", "cars    NULL    nt:nodeType    VIEW    Is Mixin: false    NULL    NULL    NULL    null    DERIVED"};
        ResultSet rs = this.dbmd.getTables("%", "%", "%nodeType%", new String[0]);
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(2);
    }

    @Test
    public void shouldGetAllColumnsFor1Table() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    COLUMN_NAME[String]    DATA_TYPE[Long]    TYPE_NAME[String]    COLUMN_SIZE[Long]    BUFFER_LENGTH[Long]    DECIMAL_DIGITS[Long]    NUM_PREC_RADIX[Long]    NULLABLE[Long]    REMARKS[String]    COLUMN_DEF[String]    SQL_DATA_TYPE[Long]    SQL_DATETIME_SUB[Long]    CHAR_OCTET_LENGTH[Long]    ORDINAL_POSITION[Long]    IS_NULLABLE[String]    SCOPE_CATLOG[String]    SCOPE_SCHEMA[String]    SCOPE_TABLE[String]    SOURCE_DATA_TYPE[Long]", "cars    NULL    car:Car    *    12    undefined    50    NULL    0    0    2        NULL    0    0    0    1    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    *    12    undefined    50    NULL    0    0    2        NULL    0    0    0    2    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:engine    12    String    50    NULL    0    0    2        NULL    0    0    0    3    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:lengthInInches    6    Double    20    NULL    0    0    2        NULL    0    0    0    4    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:maker    12    String    50    NULL    0    0    2        NULL    0    0    0    5    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:model    12    String    50    NULL    0    0    2        NULL    0    0    0    6    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:mpgCity    -5    Long    20    NULL    0    0    2        NULL    0    0    0    7    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:mpgHighway    -5    Long    20    NULL    0    0    2        NULL    0    0    0    8    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:msrp    12    String    50    NULL    0    0    2        NULL    0    0    0    9    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:userRating    -5    Long    20    NULL    0    0    2        NULL    0    0    0    10    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:valueRating    -5    Long    20    NULL    0    0    2        NULL    0    0    0    11    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:wheelbaseInInches    6    Double    20    NULL    0    0    2        NULL    0    0    0    12    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:year    12    String    50    NULL    0    0    2        NULL    0    0    0    13    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    jcr:mixinTypes    12    Name    20    NULL    0    0    2        NULL    0    0    0    14    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    jcr:primaryType    12    Name    20    NULL    0    0    1        NULL    0    0    0    15    NO    NULL    NULL    NULL    0", "cars    NULL    car:Car    modeint:multiValuedProperties    12    String    50    NULL    0    0    2        NULL    0    0    0    16    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    modeint:nodeDefinition    12    String    50    NULL    0    0    2        NULL    0    0    0    17    YES    NULL    NULL    NULL    0"};
        ResultSet rs = this.dbmd.getColumns("%", "%", "car:Car", "%");
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(17);
    }

    @Test
    public void shouldGetOnlyColumnsForCarPrefixedTables() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    COLUMN_NAME[String]    DATA_TYPE[Long]    TYPE_NAME[String]    COLUMN_SIZE[Long]    BUFFER_LENGTH[Long]    DECIMAL_DIGITS[Long]    NUM_PREC_RADIX[Long]    NULLABLE[Long]    REMARKS[String]    COLUMN_DEF[String]    SQL_DATA_TYPE[Long]    SQL_DATETIME_SUB[Long]    CHAR_OCTET_LENGTH[Long]    ORDINAL_POSITION[Long]    IS_NULLABLE[String]    SCOPE_CATLOG[String]    SCOPE_SCHEMA[String]    SCOPE_TABLE[String]    SOURCE_DATA_TYPE[Long]", "cars    NULL    car:Car    *    12    undefined    50    NULL    0    0    2        NULL    0    0    0    1    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    *    12    undefined    50    NULL    0    0    2        NULL    0    0    0    2    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:engine    12    String    50    NULL    0    0    2        NULL    0    0    0    3    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:lengthInInches    6    Double    20    NULL    0    0    2        NULL    0    0    0    4    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:maker    12    String    50    NULL    0    0    2        NULL    0    0    0    5    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:model    12    String    50    NULL    0    0    2        NULL    0    0    0    6    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:mpgCity    -5    Long    20    NULL    0    0    2        NULL    0    0    0    7    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:mpgHighway    -5    Long    20    NULL    0    0    2        NULL    0    0    0    8    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:msrp    12    String    50    NULL    0    0    2        NULL    0    0    0    9    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:userRating    -5    Long    20    NULL    0    0    2        NULL    0    0    0    10    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:valueRating    -5    Long    20    NULL    0    0    2        NULL    0    0    0    11    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:wheelbaseInInches    6    Double    20    NULL    0    0    2        NULL    0    0    0    12    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    car:year    12    String    50    NULL    0    0    2        NULL    0    0    0    13    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    jcr:mixinTypes    12    Name    20    NULL    0    0    2        NULL    0    0    0    14    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    jcr:primaryType    12    Name    20    NULL    0    0    1        NULL    0    0    0    15    NO    NULL    NULL    NULL    0", "cars    NULL    car:Car    modeint:multiValuedProperties    12    String    50    NULL    0    0    2        NULL    0    0    0    16    YES    NULL    NULL    NULL    0", "cars    NULL    car:Car    modeint:nodeDefinition    12    String    50    NULL    0    0    2        NULL    0    0    0    17    YES    NULL    NULL    NULL    0"};
        ResultSet rs = this.dbmd.getColumns("%", "%", "car%", "%");
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(11);
    }

    @Test
    public void shouldGetOnlyMSRPColumnForCarTable() throws SQLException {
        this.compareColumns = false;
        String[] expected = new String[]{"TABLE_CAT[String]    TABLE_SCHEM[String]    TABLE_NAME[String]    COLUMN_NAME[String]    DATA_TYPE[Long]    TYPE_NAME[String]    COLUMN_SIZE[Long]    BUFFER_LENGTH[Long]    DECIMAL_DIGITS[Long]    NUM_PREC_RADIX[Long]    NULLABLE[Long]    REMARKS[String]    COLUMN_DEF[String]    SQL_DATA_TYPE[Long]    SQL_DATETIME_SUB[Long]    CHAR_OCTET_LENGTH[Long]    ORDINAL_POSITION[Long]    IS_NULLABLE[String]    SCOPE_CATLOG[String]    SCOPE_SCHEMA[String]    SCOPE_TABLE[String]    SOURCE_DATA_TYPE[Long]", "cars    NULL    car:Car    car:msrp    12    String    50    NULL    0    0    2        NULL    0    0    0    1    YES    NULL    NULL    NULL    0"};
        ResultSet rs = this.dbmd.getColumns("%", "%", "car:Car", "car:msrp");
        this.assertResultsSetEquals(rs, expected);
        this.assertRowCount(1);
    }

    static {
        jndiNameForRepository = "jcr/local";
        validUrl = "jdbc:jcr:jndi:" + jndiNameForRepository + "?repositoryName=cars";
    }
}

