/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.SQLException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrResultSetMetaData;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.delegate.ConnectionInfo;

public class JcrResultSetMetaDataTest {
    public static final String STRING = TestUtil.STRING;
    public static final String DOUBLE = TestUtil.DOUBLE;
    public static final String LONG = TestUtil.LONG;
    public static final String PATH = TestUtil.PATH;
    public static final String REFERENCE = TestUtil.REFERENCE;
    public static final Class<?> STRING_CLASS = ((JcrType)JcrType.builtInTypeMap().get(STRING)).getRepresentationClass();
    private JcrResultSetMetaData metadata;
    private JcrResultSetMetaData extMetadata;
    @Mock
    private JcrConnection connection;
    @Mock
    private javax.jcr.query.QueryResult results;
    @Mock
    private QueryResult extendedResults;
    private String[] columnNames = TestUtil.COLUMN_NAMES;
    private String[] tableNames = TestUtil.TABLE_NAMES;
    private String[] typeNames = TestUtil.TYPE_NAMES;
    @Mock
    private ConnectionInfo info;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.results.getColumnNames()).thenReturn((Object)this.columnNames);
        Mockito.when((Object)this.results.getSelectorNames()).thenReturn((Object)this.tableNames);
        Mockito.when((Object)this.extendedResults.getColumnNames()).thenReturn((Object)this.columnNames);
        Mockito.when((Object)this.extendedResults.getSelectorNames()).thenReturn((Object)this.tableNames);
        Mockito.when((Object)this.extendedResults.getColumnTypes()).thenReturn((Object)this.typeNames);
        this.addPropDefn("typeA", "propA", true);
        this.addPropDefn("typeA", "propC", false);
        this.addPropDefn("typeB", "propB", false);
        this.addPropDefn("typeA", "propE", false);
        Mockito.when((Object)this.info.getWorkspaceName()).thenReturn((Object)"workspaceName");
        Mockito.when((Object)this.info.getRepositoryName()).thenReturn((Object)"repositoryName");
        Mockito.when((Object)this.connection.info()).thenReturn((Object)this.info);
        this.metadata = new JcrResultSetMetaData(this.connection, this.results);
        this.extMetadata = new JcrResultSetMetaData(this.connection, (javax.jcr.query.QueryResult)this.extendedResults);
    }

    @Test
    public void shouldReturnRepositoryNameAsCatalogName() throws SQLException {
        int i;
        for (i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getCatalogName(i), (Matcher)Is.is((Object)this.info.getRepositoryName()));
        }
        Mockito.when((Object)this.info.getRepositoryName()).thenReturn(null);
        for (i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getCatalogName(i), (Matcher)Is.is((Object)this.info.getRepositoryName()));
        }
    }

    @Test
    public void shouldReturnWorkspaceNameAsSchemaName() throws SQLException {
        int i;
        for (i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getSchemaName(i), (Matcher)Is.is((Object)this.info.getWorkspaceName()));
        }
        Mockito.when((Object)this.info.getWorkspaceName()).thenReturn(null);
        for (i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getSchemaName(i), (Matcher)Is.is((Object)this.info.getWorkspaceName()));
        }
    }

    @Test
    public void shouldReturnColumnCountFromQueryResults() throws SQLException {
        Assert.assertThat((Object)this.metadata.getColumnCount(), (Matcher)Is.is((Object)this.columnNames.length));
    }

    @Test
    public void shouldReturnColumnNameFromQueryResultColumNames() throws SQLException {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getColumnName(i + 1), (Matcher)Is.is((Object)this.columnNames[i]));
        }
    }

    @Test
    public void shouldReturnColumnLabelFromQueryResultColumNames() throws SQLException {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getColumnLabel(i + 1), (Matcher)Is.is((Object)this.columnNames[i]));
        }
    }

    @Test
    public void shouldReturnStringForColumnTypeWhenResultIsNotExtendedJcrQueryResult() {
        Assert.assertThat((Object)(this.results instanceof QueryResult), (Matcher)Is.is((Object)false));
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getColumnTypeName(i + 1), (Matcher)Is.is((Object)STRING));
            Assert.assertThat((Object)this.metadata.getColumnType(i + 1), (Matcher)Is.is((Object)12));
            Assert.assertThat((Object)this.metadata.getColumnClassName(i + 1), (Matcher)Is.is((Object)String.class.getName()));
        }
    }

    @Test
    public void shouldReturnActualTypeForColumnTypeWhenResultIsExtendedJcrQueryResult() {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.extMetadata.getColumnTypeName(i + 1), (Matcher)Is.is((Object)this.typeNames[i]));
            JcrType expectedType = JcrType.typeInfo((String)this.typeNames[i]);
            Assert.assertThat((Object)this.extMetadata.getColumnType(i + 1), (Matcher)Is.is((Object)expectedType.getJdbcType()));
            Assert.assertThat((Object)this.extMetadata.getColumnClassName(i + 1), (Matcher)Is.is((Object)expectedType.getRepresentationClass().getName()));
        }
    }

    @Test
    public void shouldReturnZeroForPrecisionWhenResultIsNotExtendedJcrQueryResult() {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getPrecision(i + 1), (Matcher)Is.is((Object)JcrType.typeInfo((String)STRING).getNominalDisplaySize()));
        }
    }

    @Test
    public void shouldReturnPrecisionBasedUponPropertyTypeWhenResultIsNotExtendedJcrQueryResult() {
        Assert.assertThat((Object)this.extMetadata.getPrecision(1), (Matcher)Is.is((Object)JcrType.typeInfo((String)STRING).getNominalDisplaySize()));
        Assert.assertThat((Object)this.extMetadata.getPrecision(2), (Matcher)Is.is((Object)JcrType.typeInfo((String)LONG).getNominalDisplaySize()));
        Assert.assertThat((Object)this.extMetadata.getPrecision(3), (Matcher)Is.is((Object)JcrType.typeInfo((String)PATH).getNominalDisplaySize()));
        Assert.assertThat((Object)this.extMetadata.getPrecision(4), (Matcher)Is.is((Object)JcrType.typeInfo((String)REFERENCE).getNominalDisplaySize()));
        Assert.assertThat((Object)this.extMetadata.getPrecision(5), (Matcher)Is.is((Object)JcrType.typeInfo((String)DOUBLE).getNominalDisplaySize()));
    }

    @Test
    public void shouldReturnZeroForScaleWhenResultIsNotExtendedJcrQueryResult() {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.getScale(i + 1), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void shouldReturnScaleBasedUponPropertyTypeWhenResultIsNotExtendedJcrQueryResult() {
        Assert.assertThat((Object)this.extMetadata.getScale(1), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.getScale(2), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.getScale(3), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.getScale(4), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.getScale(5), (Matcher)Is.is((Object)3));
    }

    @Ignore
    @Test
    public void shouldReturnUnknownNullableWhenResultIsNotExtendedJcrQueryResult() throws SQLException {
        Assert.assertThat((Object)this.metadata.isNullable(1), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.metadata.isNullable(2), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.metadata.isNullable(3), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.metadata.isNullable(4), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.metadata.isNullable(5), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldReturnNullableBasedUponNodeTypeWhenResultIsExtendedJcrQueryResult() throws SQLException {
        Assert.assertThat((Object)this.extMetadata.isNullable(1), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.extMetadata.isNullable(2), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.isNullable(3), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.isNullable(4), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.extMetadata.isNullable(5), (Matcher)Is.is((Object)0));
        this.addPropDefn("typeB", "*", true);
        Assert.assertThat((Object)this.extMetadata.isNullable(2), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnNullableBasedUponNodeTypeIncludingResidualsWhenResultIsExtendedJcrQueryResult() throws SQLException {
        this.addPropDefn("typeB", "*", true);
        Assert.assertThat((Object)this.extMetadata.isNullable(1), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.extMetadata.isNullable(2), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.extMetadata.isNullable(3), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.extMetadata.isNullable(4), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.extMetadata.isNullable(5), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnCaseSensitiveWhenResultIsNotExtendedJcrQueryResult() throws SQLException {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.isCaseSensitive(i + 1), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldReturnCaseSensitiveBasedUponNodeTypeWhenResultIsExtendedJcrQueryResult() throws SQLException {
        Assert.assertThat((Object)this.extMetadata.isCaseSensitive(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.extMetadata.isCaseSensitive(2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.extMetadata.isCaseSensitive(3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.extMetadata.isCaseSensitive(4), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.extMetadata.isCaseSensitive(5), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromSignedWhenResultIsNotExtendedJcrQueryResult() throws SQLException {
        Assert.assertThat((Object)this.metadata.isCaseSensitive(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.metadata.isCaseSensitive(2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.metadata.isCaseSensitive(3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.metadata.isCaseSensitive(4), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.metadata.isCaseSensitive(5), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnSignedBasedUponNodeTypeWhenResultIsExtendedJcrQueryResult() throws SQLException {
        Assert.assertThat((Object)this.extMetadata.isSigned(1), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.extMetadata.isSigned(2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.extMetadata.isSigned(3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.extMetadata.isSigned(4), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.extMetadata.isSigned(5), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAlwaysReturnFalseForIsAutoincrement() throws SQLException {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.isAutoIncrement(i + 1), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.extMetadata.isAutoIncrement(i + 1), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void shouldAlwaysReturnTrueForIsSearchable() {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.isSearchable(i + 1), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.extMetadata.isSearchable(i + 1), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldAlwaysReturnFalseForIsCurrency() throws SQLException {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.isCurrency(i + 1), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.extMetadata.isCurrency(i + 1), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void shouldAlwaysReturnFalseForIsDefinitelyWritable() throws SQLException {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.isDefinitelyWritable(i + 1), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.extMetadata.isDefinitelyWritable(i + 1), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void shouldAlwaysReturnTrueForIsReadOnly() {
        for (int i = 0; i != this.columnNames.length; ++i) {
            Assert.assertThat((Object)this.metadata.isReadOnly(i + 1), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.extMetadata.isReadOnly(i + 1), (Matcher)Is.is((Object)true));
        }
    }

    protected void addPropDefn(String nodeTypeName, String propName, boolean isMultiple) throws SQLException {
        NodeType nodeType = this.connection.nodeType(nodeTypeName);
        if (nodeType == null) {
            nodeType = (NodeType)Mockito.mock(NodeType.class);
        }
        PropertyDefinition defn = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)defn.getName()).thenReturn((Object)propName);
        Mockito.when((Object)defn.isMandatory()).thenReturn((Object)isMultiple);
        PropertyDefinition[] defns = nodeType.getPropertyDefinitions();
        if (defns == null) {
            defns = new PropertyDefinition[]{defn};
        } else {
            PropertyDefinition[] newDefns = new PropertyDefinition[defns.length + 1];
            System.arraycopy(defns, 0, newDefns, 0, defns.length);
            newDefns[defns.length] = defn;
            defns = newDefns;
        }
        Mockito.when((Object)nodeType.getPropertyDefinitions()).thenReturn((Object)defns);
        Mockito.when((Object)this.connection.nodeType(nodeTypeName)).thenReturn((Object)nodeType);
    }
}

