/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.QueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

public class JcrStatementTest {
    private JcrStatement stmt;
    @Mock
    private JcrConnection connection;
    @Mock
    private QueryResult queryResult;

    @After
    public void afterEach() {
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
    }

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.stmt = new JcrStatement(this.connection);
        Mockito.when((Object)this.connection.getRepositoryDelegate()).thenReturn((Object)new TestJcrCommRepositoryInterface());
        Mockito.when((Object)this.queryResult.getColumnNames()).thenReturn((Object)TestUtil.COLUMN_NAMES);
    }

    @Test
    public void shouldHaveStatement() {
        Assert.assertThat((Object)this.stmt, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldBeAbleToClearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Test
    public void shouldHaveConnection() throws SQLException {
        Assert.assertThat((Object)this.stmt.getConnection(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldReturnDefaultForFetchDirection() throws SQLException {
        Assert.assertThat((Object)this.stmt.getFetchDirection(), (Matcher)Is.is((Object)1000));
    }

    @Test
    public void shouldHaveFetchSize() throws SQLException {
        Assert.assertThat((Object)this.stmt.getFetchSize(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnDefaultForMaxRows() throws SQLException {
        Assert.assertThat((Object)this.stmt.getMaxRows(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveMoreResults() throws SQLException {
        Assert.assertThat((Object)this.stmt.getMoreResults(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveMoreResultsAtPostion() throws SQLException {
        Assert.assertThat((Object)this.stmt.getMoreResults(1), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnDefaultForMaxFieldSize() throws SQLException {
        Assert.assertThat((Object)this.stmt.getMaxFieldSize(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnDefaultForQueryTimeout() throws SQLException {
        Assert.assertThat((Object)this.stmt.getQueryTimeout(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnDefaultForUpdateCount() throws SQLException {
        Assert.assertThat((Object)this.stmt.getUpdateCount(), (Matcher)Is.is((Object)-1));
    }

    @Test
    public void shouldExcute() throws SQLException {
        this.stmt.execute("Select propA FROM typeA");
    }

    public void shouldExcuteQuery() throws SQLException {
        this.stmt.executeQuery("Select propA FROM typeA");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForAddBatch() throws SQLException {
        this.stmt.addBatch("Update sql");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForExcuteBatch() throws SQLException {
        this.stmt.executeBatch();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForUpdate() throws SQLException {
        this.stmt.executeUpdate("Update sql");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForClearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Test
    public void shouldReturnResultSetConcurreny() throws SQLException {
        Assert.assertThat((Object)this.stmt.getResultSetConcurrency(), (Matcher)Is.is((Object)1007));
    }

    @Test
    public void shouldReturnResultSetHoldability() throws SQLException {
        Assert.assertThat((Object)this.stmt.getResultSetHoldability(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldReturnResultSetType() throws SQLException {
        Assert.assertThat((Object)this.stmt.getResultSetType(), (Matcher)Is.is((Object)1004));
    }

    @Test
    public void shouldReturnDefaultForGeneratedKeys() throws SQLException {
        Assert.assertThat((Object)this.stmt.getGeneratedKeys(), (Matcher)Is.is(ResultSet.class));
    }

    @Test
    public void shouldReturnDefaultResultSet() throws SQLException {
        Assert.assertNull((Object)this.stmt.getResultSet());
    }

    @Test
    public void shouldReturnDefaultForWarnings() throws SQLException {
        Assert.assertNull((Object)this.stmt.getWarnings());
    }

    @Test
    public void shouldSupportCancel() throws SQLException {
        this.stmt.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSupportEquals() {
        Assert.assertTrue((boolean)this.stmt.equals(this.stmt));
        JcrStatement stmt2 = null;
        try {
            stmt2 = new JcrStatement(this.connection);
            Assert.assertFalse((boolean)this.stmt.equals(stmt2));
        }
        finally {
            if (stmt2 != null) {
                stmt2.close();
            }
        }
    }

    @Test
    public void shouldBeAbleToClose() {
        this.stmt.close();
    }

    @Test
    public void shouldSetFetchSize() throws SQLException {
        this.stmt.setFetchSize(100);
    }

    @Test(expected=SQLException.class)
    public void shouldSetCursorName() throws SQLException {
        this.stmt.setCursorName("CursorName");
    }

    @Test
    public void shouldSetEscapeProcessingTrue() throws SQLException {
        this.stmt.setEscapeProcessing(true);
    }

    @Test
    public void shouldSetEscapeProcessingFalse() throws SQLException {
        this.stmt.setEscapeProcessing(false);
    }

    @Test
    public void shouldSetFetchDirectionReverse() throws SQLException {
        this.stmt.setFetchDirection(1001);
    }

    @Test
    public void shouldSetFetchDirectionUnknown() throws SQLException {
        this.stmt.setFetchDirection(1002);
    }

    @Test
    public void shouldSetFetchDirectionForward() throws SQLException {
        this.stmt.setFetchDirection(1000);
    }

    @Test
    public void shouldSetMaxFieldSize() throws SQLException {
        this.stmt.setMaxFieldSize(30);
    }

    @Test
    public void shouldSetMaxRows() throws SQLException {
        this.stmt.setMaxRows(200);
    }

    @Test
    public void shouldSetPoolableTrue() throws SQLException {
        this.stmt.setPoolable(true);
    }

    @Test
    public void shouldSetPoolableFalse() throws SQLException {
        this.stmt.setPoolable(false);
    }

    @Test
    public void shouldSetQueryTimeout() throws SQLException {
        this.stmt.setQueryTimeout(60);
    }

    public class TestJcrCommRepositoryInterface
    implements RepositoryDelegate {
        public Connection createConnection() {
            return null;
        }

        public QueryResult execute(String query, String language) {
            return JcrStatementTest.this.queryResult;
        }

        public ConnectionInfo getConnectionInfo() {
            return null;
        }

        public void close() {
        }

        public void commit() {
        }

        public JcrMetaData createMetaData(JcrConnection connection) {
            return null;
        }

        public boolean isValid(int timeout) {
            return false;
        }

        public NodeType nodeType(String name) {
            return null;
        }

        public List<NodeType> nodeTypes() throws RepositoryException {
            return null;
        }

        public void rollback() {
        }

        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        public Set<String> getRepositoryNames() throws RepositoryException {
            return null;
        }

        public String getDescriptor(String descriptorKey) {
            return null;
        }
    }
}

