/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.mockito.Mockito;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.QueryResultNodeIterator;
import org.modeshape.jdbc.QueryResultRowIterator;

public class TestUtil {
    public static final String STRING = PropertyType.nameFromValue((int)1);
    public static final String DOUBLE = PropertyType.nameFromValue((int)4);
    public static final String LONG = PropertyType.nameFromValue((int)3);
    public static final String BOOLEAN = PropertyType.nameFromValue((int)6);
    public static final String DATE = PropertyType.nameFromValue((int)5);
    public static final String PATH = PropertyType.nameFromValue((int)8);
    public static final String BINARY = PropertyType.nameFromValue((int)2);
    public static final String REFERENCE = PropertyType.nameFromValue((int)9);
    public static String[] COLUMN_NAMES;
    public static String[] TABLE_NAMES;
    public static String[] TYPE_NAMES;
    public static String[] NODE_NAMES;
    public static List<Object[]> TUPLES;
    public static final String SQL_SELECT = "Select propA FROM typeA";
    public static final String DRIVER_VERSION;

    static Node[] createNodes() {
        Node[] nodes = new Node[NODE_NAMES.length];
        for (int i = 0; i < NODE_NAMES.length; ++i) {
            Node n = (Node)Mockito.mock(Node.class);
            try {
                Mockito.when((Object)n.getName()).thenReturn((Object)NODE_NAMES[i]);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            nodes[i] = n;
        }
        return nodes;
    }

    public static int minorVersion() {
        String[] coords = DRIVER_VERSION.split("[.-]");
        int major = Integer.parseInt(coords[0]);
        int minor = Integer.parseInt(coords[1]);
        return minor;
    }

    public static int majorVersion() {
        String[] coords = DRIVER_VERSION.split("[.-]");
        int major = Integer.parseInt(coords[0]);
        return major;
    }

    public static QueryResult createQueryResult() {
        final Node[] nodes = TestUtil.createNodes();
        org.modeshape.jcr.api.query.QueryResult qr = new org.modeshape.jcr.api.query.QueryResult(){

            public String[] getColumnNames() {
                String[] cns = new String[COLUMN_NAMES.length];
                System.arraycopy(COLUMN_NAMES, 0, cns, 0, COLUMN_NAMES.length);
                return cns;
            }

            public NodeIterator getNodes() {
                ArrayList<Node> nodeArray = new ArrayList<Node>();
                for (int i = 0; i < nodes.length; ++i) {
                    nodeArray.add(nodes[i]);
                }
                return new QueryResultNodeIterator(nodeArray);
            }

            public RowIterator getRows() {
                ArrayList<Object[]> tuplesArray = new ArrayList<Object[]>(TUPLES);
                QueryResultRowIterator ri = new QueryResultRowIterator(nodes, TestUtil.SQL_SELECT, tuplesArray.iterator(), tuplesArray.size());
                return ri;
            }

            public String[] getColumnTypes() {
                return null;
            }

            public String[] getSelectorNames() {
                return null;
            }
        };
        return qr;
    }

    static {
        DRIVER_VERSION = JdbcI18n.driverVersion.text(new Object[0]);
        COLUMN_NAMES = new String[]{"propA", "propB", "propC", "propD", "propE", "propF", "propG", "propH"};
        TABLE_NAMES = new String[]{"typeA", "typeB", "typeA", "", "typeA"};
        TYPE_NAMES = new String[]{STRING, LONG, PATH, REFERENCE, DOUBLE, BOOLEAN, DATE, BINARY};
        NODE_NAMES = new String[]{"node1", "node2"};
        TUPLES = new ArrayList<Object[]>();
        TUPLES.add(new Object[]{"r1c1", new Long(1L), null, null, new Double(1.0), new Boolean(true), new Date(), new String("Heres my data at r1").getBytes()});
        TUPLES.add(new Object[]{"r2c1", new Long(2L), null, null, new Double(2.0), new Boolean(false), new Date(), new String("Heres my data r2   ").getBytes()});
        TUPLES.add(new Object[]{"r3c1", new Long(3L), null, null, new Double(3.0), new Boolean(true), new Date(), new String("Heres my data at r3  ").getBytes()});
        TUPLES.add(new Object[]{"r4c1", 4L, null, null, 4.0, (boolean)new Boolean(true), new Date(), new String("Heres  my  data    r4  ").getBytes()});
    }

    public static interface COLUMN_NAME_PROPERTIES {
        public static final String PROP_A = "propA";
        public static final String PROP_B = "propB";
        public static final String PROP_C = "propC";
        public static final String PROP_D = "propD";
        public static final String PROP_E = "propE";
        public static final String PROP_F = "propF";
        public static final String PROP_G = "propG";
        public static final String PROP_H = "propH";
    }
}

