/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import javax.jcr.Repository;
import javax.naming.Context;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.delegate.ConnectionInfo;

public class JcrDriverTest {
    private JcrDriver driver;
    private String jndiNameForRepository;
    private String jndiNameForRepositories;
    private String validUrl;
    private Properties validProperties;
    private String validRepositoryName;
    @Mock
    private Context jndi;
    @Mock
    private Repository repository;
    @Mock
    private Repositories repositories;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.validRepositoryName = "MyRepository";
        this.jndiNameForRepository = "java:MyRepository";
        this.jndiNameForRepositories = "java:Repositories";
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepository + "?workspace=MyWorkspace&user=jsmith&password=secret";
        this.validProperties = new Properties();
        Mockito.when((Object)this.jndi.lookup(this.jndiNameForRepository)).thenReturn((Object)this.repository);
        Mockito.when((Object)this.jndi.lookup(this.jndiNameForRepositories)).thenReturn((Object)this.repositories);
        Mockito.when((Object)this.repositories.getRepository(this.validRepositoryName)).thenReturn((Object)this.repository);
        JcrDriver.JcrContextFactory contextFactory = new JcrDriver.JcrContextFactory(){

            public Context createContext(Properties properties) {
                return JcrDriverTest.this.jndi;
            }
        };
        this.driver = new JcrDriver();
        this.driver.setContextFactory(contextFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        try {
            DriverManager.deregisterDriver((Driver)this.driver);
        }
        finally {
            this.jndi = null;
            this.repositories = null;
            this.driver = null;
        }
    }

    @Test
    public void shouldNotBeJdbcCompliant() {
        Assert.assertThat((Object)this.driver.jdbcCompliant(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveMajorVersion() {
        Assert.assertThat((Object)this.driver.getMajorVersion(), (Matcher)Is.is((Object)TestUtil.majorVersion()));
    }

    @Test
    public void shouldHaveMinorVersion() {
        Assert.assertThat((Object)this.driver.getMinorVersion(), (Matcher)Is.is((Object)TestUtil.minorVersion()));
    }

    @Test
    public void shouldHaveVendorUrl() {
        Assert.assertThat((Object)this.driver.getVendorUrl(), (Matcher)Is.is((Object)JdbcI18n.driverVendorUrl.text(new Object[0])));
    }

    @Test
    public void shouldHaveVendorName() {
        Assert.assertThat((Object)this.driver.getVendorName(), (Matcher)Is.is((Object)JdbcI18n.driverVendor.text(new Object[0])));
    }

    @Test
    public void shouldHaveVersion() {
        Assert.assertThat((Object)this.driver.getVersion(), (Matcher)Is.is((Object)JdbcI18n.driverVersion.text(new Object[0])));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidAndCompleteUrlAndNoProperties() throws SQLException {
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidUrlAndAllPropertiesWithRepositoryInJndi() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepository;
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidUrlAndAllPropertiesWithRepositoriesInJndi() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepositories;
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingRequiredRepositoryName() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepositories;
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcI18n.repositoryNamePropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcI18n.repositoryNamePropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingWorkspaceName() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepositories;
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcI18n.workspaceNamePropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcI18n.workspaceNamePropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingUsername() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepositories;
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcI18n.usernamePropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcI18n.usernamePropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingPassword() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:" + this.jndiNameForRepositories;
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcI18n.passwordPropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcI18n.passwordPropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAcceptValidUrls() {
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java:nameInJndi?workspace=MyWorkspace&user=jsmith&password=secret&teiidsupport=true"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java:nameInJndi?workspace=MyWorkspace&user=jsmith&password=secret"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java:nameInJndi?workspace=MyWorkspace&user=jsmith"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java:nameInJndi?workspace=My%20Workspace"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java:nameInJndi"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java:nameInJndi?"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:java"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:j"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:j "), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi: j"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAcceptInvalidUrls() {
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi:"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:jndi: "), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("file://"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc://"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateConnectionInfoForUrlWithEscapedCharacters() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:java:nameInJndi?workspace=My%20Workspace&user=j%20smith&password=secret&repositoryName=My%20Repository&teiidsupport=true";
        ConnectionInfo info = this.driver.createConnectionInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)info.getWorkspaceName(), (Matcher)Is.is((Object)"My Workspace"));
        Assert.assertThat((Object)info.getUsername(), (Matcher)Is.is((Object)"j smith"));
        Assert.assertThat((Object)info.getPassword(), (Matcher)Is.is((Object)"secret".toCharArray()));
        Assert.assertThat((Object)info.getRepositoryName(), (Matcher)Is.is((Object)"My Repository"));
        Assert.assertThat((Object)info.isTeiidSupport(), (Matcher)Is.is((Object)Boolean.TRUE));
    }

    @Test
    public void shouldCreateConnectionInfoButIndicateNoTeiidSupport() throws SQLException {
        this.validUrl = "jdbc:jcr:jndi:java:nameInJndi?workspace=My%20Workspace&user=j%20smith&password=secret&repositoryName=My%20Repository";
        ConnectionInfo info = this.driver.createConnectionInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)info.isTeiidSupport(), (Matcher)Is.is((Object)Boolean.FALSE));
    }

    @Test
    public void shouldCreateConnectionWithValidUrlAndProperties() throws SQLException {
        Connection conn = this.driver.connect(this.validUrl, this.validProperties);
        Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)conn.isClosed(), (Matcher)Is.is((Object)false));
        conn.close();
        Assert.assertThat((Object)conn.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateConnectionWithDriverManagerAfterRegisteringDriver() throws SQLException {
        DriverManager.registerDriver((Driver)this.driver);
        Connection connection = DriverManager.getConnection(this.validUrl, this.validProperties);
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(JcrConnection.class)));
        Assert.assertThat((Object)connection.isWrapperFor(JcrConnection.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)connection.unwrap(JcrConnection.class), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(JcrConnection.class)));
    }
}

