/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;

public class HttpRepositoryDelegateTest {
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final String USER_NAME = "jsmith";
    private static final String PASSWORD = "secret";
    private static final String WORKSPACE = "MyWorkspace";
    private static final String SERVER = "serverName:8080";
    private static final String INVALID_URL = "jdbc:jcr:http://serverName:8080";
    private static final String VALID_HTTP_URL = "jdbc:jcr:http://serverName:8080/modeshape-rest";
    private static final String VALID_HTTP_URL_WITH_PARMS = "jdbc:jcr:http://serverName:8080/modeshape-rest/repositoryName/MyWorkspace?user=jsmith&password=secret&teiidsupport=true";
    private RepositoryDelegate delegate;

    @Test
    public void testNoContextOverride() throws SQLException {
        this.delegate = RepositoryDelegateFactory.createRepositoryDelegate((String)VALID_HTTP_URL_WITH_PARMS, (Properties)new Properties(), null);
    }

    @Test
    public void connectionInfoShouldBeValid() throws SQLException {
        this.delegate = RepositoryDelegateFactory.createRepositoryDelegate((String)VALID_HTTP_URL_WITH_PARMS, (Properties)new Properties(), null);
        Assert.assertNotNull((Object)this.delegate.getConnectionInfo());
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getUsername(), (Matcher)Is.is((Object)USER_NAME));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getPassword(), (Matcher)Is.is((Object)new String(PASSWORD).toCharArray()));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getEffectiveUrl(), (Matcher)Is.is((Object)"jdbc:jcr:http://serverName:8080/modeshape-rest?teiidsupport=true&user=jsmith&workspace=MyWorkspace&password=******&repositoryName=repositoryName"));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().isTeiidSupport(), (Matcher)Is.is((Object)Boolean.TRUE));
        DriverPropertyInfo[] infos = this.delegate.getConnectionInfo().getPropertyInfos();
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.delegate.getConnectionInfo().getRepositoryPath(), (Matcher)Is.is((Object)"serverName:8080/modeshape-rest"));
    }

    @Test
    public void connectionPropertyInfoShouldIndicateMissingData() throws SQLException {
        this.delegate = RepositoryDelegateFactory.createRepositoryDelegate((String)INVALID_URL, (Properties)new Properties(), null);
        Assert.assertNotNull((Object)this.delegate.getConnectionInfo());
        DriverPropertyInfo[] infos = this.delegate.getConnectionInfo().getPropertyInfos();
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)5));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidUrlAndAllPropertiesWithRepositoriesInHTTP() throws SQLException {
        Properties validProperties = new Properties();
        validProperties.put("workspace", WORKSPACE);
        validProperties.put("user", USER_NAME);
        validProperties.put("password", PASSWORD);
        validProperties.put(REPOSITORY_NAME, REPOSITORY_NAME);
        this.delegate = RepositoryDelegateFactory.createRepositoryDelegate((String)VALID_HTTP_URL, (Properties)validProperties, null);
        DriverPropertyInfo[] infos = this.delegate.getConnectionInfo().getPropertyInfos();
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }
}

