/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.delegate.ConnectionInfo;

public class JcrDriverHttpTest {
    private JcrDriver driver;
    private String validServerName;
    private String validRepositoryName;
    private String validWorkspaceName;
    private String validUrl;
    private Properties validProperties;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.validRepositoryName = "MyRepository";
        this.validServerName = "serverName:8080";
        this.validWorkspaceName = "default";
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape-rest/" + this.validRepositoryName + "/" + this.validWorkspaceName + "?user=jsmith&password=secret";
        this.validProperties = new Properties();
        this.driver = new JcrDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        try {
            DriverManager.deregisterDriver((Driver)this.driver);
        }
        finally {
            this.driver = null;
        }
    }

    @Test
    public void shouldNotBeJdbcCompliant() {
        Assert.assertThat((Object)this.driver.jdbcCompliant(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveMajorVersion() {
        Assert.assertThat((Object)this.driver.getMajorVersion(), (Matcher)Is.is((Object)TestUtil.majorVersion()));
    }

    @Test
    public void shouldHaveMinorVersion() {
        Assert.assertThat((Object)this.driver.getMinorVersion(), (Matcher)Is.is((Object)TestUtil.minorVersion()));
    }

    @Test
    public void shouldHaveVendorUrl() {
        Assert.assertThat((Object)this.driver.getVendorUrl(), (Matcher)Is.is((Object)JdbcI18n.driverVendorUrl.text(new Object[0])));
    }

    @Test
    public void shouldHaveVendorName() {
        Assert.assertThat((Object)this.driver.getVendorName(), (Matcher)Is.is((Object)JdbcI18n.driverVendor.text(new Object[0])));
    }

    @Test
    public void shouldHaveVersion() {
        Assert.assertThat((Object)this.driver.getVersion(), (Matcher)Is.is((Object)JdbcI18n.driverVersion.text(new Object[0])));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidAndCompleteUrlAndNoProperties() throws SQLException {
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnEmptyPropertyInfosWhenSuppliedValidUrlAndAllPropertiesWithRepositoryInHttp() throws SQLException {
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape-rest";
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingRequiredRepositoryName() throws SQLException {
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape-rest";
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcLocalI18n.repositoryNamePropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcLocalI18n.repositoryNamePropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingWorkspaceName() throws SQLException {
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape-rest";
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcLocalI18n.workspaceNamePropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcLocalI18n.workspaceNamePropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingUsername() throws SQLException {
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape-rest";
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("password", "secret");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcLocalI18n.usernamePropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcLocalI18n.usernamePropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnRepositoryPropertyInfoWhenMissingPassword() throws SQLException {
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape-rest";
        this.validProperties.put("workspace", "MyWorkspace");
        this.validProperties.put("user", "jsmith");
        this.validProperties.put("repositoryName", this.validRepositoryName);
        DriverPropertyInfo[] infos = this.driver.getPropertyInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)infos.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)infos[0].name, (Matcher)Is.is((Object)JdbcLocalI18n.passwordPropertyName.text(new Object[0])));
        Assert.assertThat((Object)infos[0].description, (Matcher)Is.is((Object)JdbcLocalI18n.passwordPropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)infos[0].required, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAcceptValidUrls() {
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:http://" + this.validServerName + "/modeshape-rest/" + this.validRepositoryName + "/MyWorkspace" + "&user=jsmith&password=secret"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:http://" + this.validServerName + "/modeshape-rest/" + this.validRepositoryName + "&user=jsmith&password=secret"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:http://" + this.validServerName + "/modeshape-rest/" + "&user=jsmith&password=secret"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotAcceptInvalidUrls() {
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:http"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:http://"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc:jcr:http:// "), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("file://"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.driver.acceptsURL("jdbc://"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateConnectionInfoForUrlWithEscapedCharacters() throws SQLException {
        this.validUrl = "jdbc:jcr:http://" + this.validServerName + "/modeshape%20rest" + "?repositoryName=My%20Repository&workspace=My%20Workspace&user=j%20smith&password=secret";
        ConnectionInfo info = this.driver.createConnectionInfo(this.validUrl, this.validProperties);
        Assert.assertThat((Object)info.getWorkspaceName(), (Matcher)Is.is((Object)"My Workspace"));
        Assert.assertThat((Object)info.getUsername(), (Matcher)Is.is((Object)"j smith"));
        Assert.assertThat((Object)info.getPassword(), (Matcher)Is.is((Object)"secret".toCharArray()));
        Assert.assertThat((Object)info.getRepositoryName(), (Matcher)Is.is((Object)"My Repository"));
    }
}

