/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jdbc.JdbcJcrValueFactory;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;

public final class HttpQueryResult
implements QueryResult {
    protected final List<HttpRow> rows = new ArrayList<HttpRow>();
    protected final Map<String, String> columns = new LinkedHashMap<String, String>();

    HttpQueryResult(List<QueryRow> queryRows) {
        assert (queryRows != null);
        if (!queryRows.isEmpty()) {
            QueryRow firstQueryRow = queryRows.get(0);
            Collection queryColumnNames = firstQueryRow.getColumnNames();
            for (String queryColumnName : queryColumnNames) {
                this.columns.put(queryColumnName, firstQueryRow.getColumnType(queryColumnName));
            }
        }
        for (QueryRow queryRow : queryRows) {
            this.rows.add(new HttpRow(queryRow));
        }
    }

    public String getPlan() {
        return null;
    }

    public Collection<String> getWarnings() {
        return Collections.emptyList();
    }

    public String[] getColumnNames() {
        return this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    public RowIterator getRows() {
        return new HttpRowIterator();
    }

    public NodeIterator getNodes() {
        throw new UnsupportedOperationException("Method getNodes() not supported");
    }

    public String[] getSelectorNames() {
        throw new UnsupportedOperationException("Method getSelectorNames() not supported");
    }

    public String[] getColumnTypes() {
        return this.columns.values().toArray(new String[this.columns.size()]);
    }

    private class HttpRow
    implements Row {
        private final Map<String, Value> valuesMap = new LinkedHashMap<String, Value>();

        protected HttpRow(QueryRow row) {
            assert (row != null);
            for (String columnName : HttpQueryResult.this.columns.keySet()) {
                Object queryRowValue = row.getValue(columnName);
                this.valuesMap.put(columnName, JdbcJcrValueFactory.createValue((Object)queryRowValue));
            }
        }

        public Node getNode() {
            throw new UnsupportedOperationException("Method getNode() not supported");
        }

        public Value[] getValues() {
            return this.valuesMap.values().toArray(new Value[this.valuesMap.size()]);
        }

        public Value getValue(String columnName) {
            return this.valuesMap.get(columnName);
        }

        public Node getNode(String selectorName) {
            throw new UnsupportedOperationException("Method getNode(selectorName) not supported");
        }

        public String getPath() {
            throw new UnsupportedOperationException("Method getPath() not supported");
        }

        public String getPath(String selectorName) {
            throw new UnsupportedOperationException("Method getPath(selectorName) not supported");
        }

        public double getScore() {
            throw new UnsupportedOperationException("Method getScore() not supported");
        }

        public double getScore(String selectorName) {
            throw new UnsupportedOperationException("Method getScore( String selectorName ) not supported");
        }
    }

    private class HttpRowIterator
    implements RowIterator {
        private static final int EMPTY_CURSOR = -1;
        private int cursor;

        protected HttpRowIterator() {
            this.cursor = HttpQueryResult.this.rows.isEmpty() ? -1 : 0;
        }

        public Row nextRow() {
            if (this.cursor == -1 || this.cursor >= HttpQueryResult.this.rows.size()) {
                throw new NoSuchElementException("No more rows to iterate over");
            }
            return HttpQueryResult.this.rows.get(this.cursor++);
        }

        public void skip(long skipNum) {
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must be a positive value");
            }
            int availableRowsCount = HttpQueryResult.this.rows.size() - this.cursor;
            if (skipNum > (long)availableRowsCount) {
                throw new NoSuchElementException("Skip would go past collection end");
            }
            this.cursor = (int)((long)this.cursor + skipNum);
        }

        public long getSize() {
            return HttpQueryResult.this.rows.size();
        }

        public long getPosition() {
            return this.cursor;
        }

        public boolean hasNext() {
            return this.cursor != -1 && this.cursor < HttpQueryResult.this.rows.size();
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not supported by this iterator");
        }
    }
}

