/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.core.interception.DecoratorMatcher;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.jaxb.ExternalEntityUnmarshaller;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBMarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.TypeConverter;

public abstract class AbstractJAXBProvider<T>
extends AbstractEntityProvider<T> {
    @Context
    protected Providers providers;
    private boolean expandEntityReferences = true;

    public AbstractJAXBProvider() {
        String s;
        ResteasyConfiguration context = (ResteasyConfiguration)ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
        if (context != null && (s = context.getParameter("resteasy.document.expand.entity.references")) != null) {
            this.setExpandEntityReferences(Boolean.parseBoolean(s));
        }
    }

    public JAXBContext findJAXBContext(Class<?> type, Annotation[] annotations, MediaType mediaType, boolean reader) throws JAXBException {
        ContextResolver resolver = this.providers.getContextResolver(JAXBContextFinder.class, mediaType);
        JAXBContextFinder finder = (JAXBContextFinder)resolver.getContext(type);
        if (finder == null) {
            if (reader) {
                throw new JAXBUnmarshalException("Could not find JAXBContextFinder for media type: " + mediaType);
            }
            throw new JAXBMarshalException("Could not find JAXBContextFinder for media type: " + mediaType);
        }
        return finder.findCachedContext(type, mediaType, annotations);
    }

    public static Marshaller decorateMarshaller(Class type, Annotation[] annotations, MediaType mediaType, Marshaller marshaller) throws JAXBException {
        DecoratorMatcher processor = new DecoratorMatcher();
        return (Marshaller)processor.decorate(Marshaller.class, (Object)marshaller, type, annotations, mediaType);
    }

    public static Unmarshaller decorateUnmarshaller(Class type, Annotation[] annotations, MediaType mediaType, Unmarshaller marshaller) throws JAXBException {
        DecoratorMatcher processor = new DecoratorMatcher();
        return (Unmarshaller)processor.decorate(Unmarshaller.class, (Object)marshaller, type, annotations, mediaType);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            String contentLength = (String)httpHeaders.getFirst((Object)"Content-Length");
            if (contentLength != null) {
                try {
                    long length = Long.valueOf(contentLength);
                    if (length == 0L) {
                        return null;
                    }
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType, true);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller = AbstractJAXBProvider.decorateUnmarshaller(type, annotations, mediaType, unmarshaller);
            if (this.suppressExpandEntityExpansion()) {
                return this.processWithoutEntityExpansion(unmarshaller, entityStream);
            }
            return (T)unmarshaller.unmarshal((Source)new StreamSource(entityStream));
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        try {
            Marshaller marshaller = this.getMarshaller(type, annotations, mediaType);
            marshaller = AbstractJAXBProvider.decorateMarshaller(type, annotations, mediaType, marshaller);
            marshaller.marshal(t, outputStream);
        }
        catch (JAXBException e) {
            throw new JAXBMarshalException(e);
        }
    }

    protected Marshaller getMarshaller(Class<?> type, Annotation[] annotations, MediaType mediaType) {
        try {
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType, false);
            Marshaller marshaller = jaxb.createMarshaller();
            AbstractJAXBProvider.setCharset(mediaType, marshaller);
            Object formatted = mediaType.getParameters().get("formatted");
            if (formatted != null) {
                Boolean value = TypeConverter.getBooleanValue((String)formatted.toString());
                marshaller.setProperty("jaxb.formatted.output", (Object)value);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw new JAXBMarshalException(e);
        }
    }

    public static void setCharset(MediaType mediaType, Marshaller marshaller) throws PropertyException {
        String charset = AbstractJAXBProvider.getCharset(mediaType);
        if (charset != null) {
            marshaller.setProperty("jaxb.encoding", (Object)charset);
        }
    }

    protected abstract boolean isReadWritable(Class<?> var1, Type var2, Annotation[] var3, MediaType var4);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadWritable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadWritable(type, genericType, annotations, mediaType);
    }

    public static String getCharset(MediaType mediaType) {
        if (mediaType != null) {
            return (String)mediaType.getParameters().get("charset");
        }
        return null;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public void setExpandEntityReferences(boolean expandEntityReferences) {
        this.expandEntityReferences = expandEntityReferences;
    }

    protected boolean suppressExpandEntityExpansion() {
        return !this.isExpandEntityReferences();
    }

    protected T processWithoutEntityExpansion(Unmarshaller unmarshaller, InputStream entityStream) throws JAXBException {
        unmarshaller = new ExternalEntityUnmarshaller(unmarshaller);
        return (T)unmarshaller.unmarshal(entityStream);
    }
}

