/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.jdbc.JdbcJcrValueFactory;
import org.modeshape.jdbc.rest.QueryResult;

public final class HttpQueryResult
implements org.modeshape.jcr.api.query.QueryResult {
    protected final List<HttpRow> rows = new ArrayList<HttpRow>();
    protected final Map<String, String> columnTypesByName = new LinkedHashMap<String, String>();

    protected HttpQueryResult(QueryResult queryResult) {
        assert (queryResult != null);
        if (!queryResult.isEmpty()) {
            this.columnTypesByName.putAll(queryResult.getColumns());
            for (QueryResult.Row queryRow : queryResult) {
                this.rows.add(new HttpRow(queryRow));
            }
        }
    }

    public String getPlan() {
        throw new UnsupportedOperationException("Method getPlan() not supported");
    }

    public Collection<String> getWarnings() {
        return Collections.emptyList();
    }

    public String[] getColumnNames() {
        return this.columnTypesByName.keySet().toArray(new String[this.columnTypesByName.size()]);
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public RowIterator getRows() {
        return new HttpRowIterator();
    }

    public NodeIterator getNodes() {
        throw new UnsupportedOperationException("Method getNodes() not supported");
    }

    public String[] getSelectorNames() {
        throw new UnsupportedOperationException("Method getSelectorNames() not supported");
    }

    public void close() {
    }

    public String[] getColumnTypes() {
        return this.columnTypesByName.values().toArray(new String[this.columnTypesByName.size()]);
    }

    private class HttpRow
    implements Row {
        private final Map<String, Value> valuesMap = new LinkedHashMap<String, Value>();

        protected HttpRow(QueryResult.Row row) {
            assert (row != null);
            for (String columnName : HttpQueryResult.this.columnTypesByName.keySet()) {
                String queryRowValue = row.getValue(columnName);
                this.valuesMap.put(columnName, JdbcJcrValueFactory.createValue((Object)queryRowValue));
            }
        }

        public Node getNode() {
            throw new UnsupportedOperationException("Method getNode() not supported");
        }

        public Value[] getValues() {
            return this.valuesMap.values().toArray(new Value[this.valuesMap.size()]);
        }

        public Value getValue(String columnName) {
            return this.valuesMap.get(columnName);
        }

        public Node getNode(String selectorName) {
            throw new UnsupportedOperationException("Method getNode(selectorName) not supported");
        }

        public String getPath() {
            throw new UnsupportedOperationException("Method getPath() not supported");
        }

        public String getPath(String selectorName) {
            throw new UnsupportedOperationException("Method getPath(selectorName) not supported");
        }

        public double getScore() {
            throw new UnsupportedOperationException("Method getScore() not supported");
        }

        public double getScore(String selectorName) {
            throw new UnsupportedOperationException("Method getScore( String selectorName ) not supported");
        }
    }

    private class HttpRowIterator
    implements RowIterator {
        private static final int EMPTY_CURSOR = -1;
        private int cursor;

        protected HttpRowIterator() {
            this.cursor = HttpQueryResult.this.rows.isEmpty() ? -1 : 0;
        }

        public Row nextRow() {
            if (this.cursor == -1 || this.cursor >= HttpQueryResult.this.rows.size()) {
                throw new NoSuchElementException("No more rows to iterate over");
            }
            return HttpQueryResult.this.rows.get(this.cursor++);
        }

        public void skip(long skipNum) {
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must be a positive value");
            }
            int availableRowsCount = HttpQueryResult.this.rows.size() - this.cursor;
            if (skipNum > (long)availableRowsCount) {
                throw new NoSuchElementException("Skip would go past collection end");
            }
            this.cursor = (int)((long)this.cursor + skipNum);
        }

        public long getSize() {
            return HttpQueryResult.this.rows.size();
        }

        public long getPosition() {
            return this.cursor;
        }

        public boolean hasNext() {
            return this.cursor != -1 && this.cursor < HttpQueryResult.this.rows.size();
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not supported by this iterator");
        }
    }
}

