/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.jdbc.rest.ItemDefinition;
import org.modeshape.jdbc.rest.JSONHelper;
import org.modeshape.jdbc.rest.NodeType;
import org.modeshape.jdbc.rest.NodeTypes;

@Immutable
public class ChildNodeDefinition
extends ItemDefinition
implements NodeDefinition {
    private final Id id;
    private final String defaultPrimaryTypeName;

    protected ChildNodeDefinition(String declaringNodeTypeName, JSONObject json, NodeTypes nodeTypes) {
        super(declaringNodeTypeName, json, nodeTypes);
        String name = JSONHelper.valueFrom(json, "jcr:name", "*");
        boolean allowsSns = JSONHelper.valueFrom(json, "jcr:sameNameSiblings", false);
        HashSet<String> requiredTypes = new HashSet<String>(JSONHelper.valuesFrom(json, "jcr:requiredPrimaryTypes"));
        this.id = new Id(name, allowsSns, requiredTypes);
        this.defaultPrimaryTypeName = JSONHelper.valueFrom(json, "jcr:defaultPrimaryType");
    }

    protected Id id() {
        return this.id;
    }

    public String getName() {
        return this.id.name;
    }

    public boolean allowsSameNameSiblings() {
        return this.id.isMultiple;
    }

    public String[] getRequiredPrimaryTypeNames() {
        return this.id.requiredTypes.toArray(new String[this.id.requiredTypes.size()]);
    }

    public NodeType getDefaultPrimaryType() {
        return this.nodeTypes().getNodeType(this.getDefaultPrimaryTypeName());
    }

    public String getDefaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }

    public javax.jcr.nodetype.NodeType[] getRequiredPrimaryTypes() {
        return this.nodeTypes().toNodeTypes(this.id.requiredTypes);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildNodeDefinition) {
            ChildNodeDefinition that = (ChildNodeDefinition)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" + ");
        sb.append(this.id.name);
        if (this.getRequiredPrimaryTypeNames().length != 0) {
            sb.append(" (");
            boolean first = true;
            for (String typeName : this.getRequiredPrimaryTypeNames()) {
                if (typeName == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(typeName);
            }
            sb.append(')');
        }
        if (this.getDefaultPrimaryTypeName() != null) {
            sb.append(" = ").append(this.getDefaultPrimaryTypeName());
        }
        if (this.isAutoCreated()) {
            sb.append(" autocreated");
        }
        if (this.isMandatory()) {
            sb.append(" mandatory");
        }
        if (this.allowsSameNameSiblings()) {
            sb.append(" sns");
        }
        if (this.isProtected()) {
            sb.append(" protected");
        }
        sb.append(' ').append(OnParentVersionAction.nameFromValue((int)this.getOnParentVersion()));
        return sb.toString();
    }

    protected static class Id {
        protected final String name;
        protected final boolean isMultiple;
        protected final Set<String> requiredTypes;

        protected Id(String name, boolean isMultiple, Set<String> requiredTypes) {
            this.name = name;
            this.isMultiple = isMultiple;
            this.requiredTypes = requiredTypes;
            assert (this.name != null);
            assert (this.requiredTypes != null);
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.isMultiple, this.name, this.requiredTypes});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                if (this.isMultiple != that.isMultiple) {
                    return false;
                }
                if (!this.requiredTypes.equals(that.requiredTypes)) {
                    return false;
                }
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append('(');
            boolean first = true;
            for (String requiredType : this.requiredTypes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(requiredType);
            }
            sb.append(')');
            sb.append(this.isMultiple ? (char)'*' : '1');
            return sb.toString();
        }
    }
}

