/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;

public final class JSONRestClient {
    private static final UrlEncoder URL_ENCODER = new UrlEncoder().setSlashEncoded(false);
    protected final DefaultHttpClient httpClient;
    private final HttpHost host;
    private final String url;
    private final String baseUrl;

    protected JSONRestClient(String url, String username, String password) {
        CheckArg.isNotNull((Object)url, (String)"url");
        try {
            this.url = url;
            URL connectionUrl = new URL(url);
            this.host = new HttpHost(connectionUrl.getHost(), connectionUrl.getPort(), connectionUrl.getProtocol());
            String urlPath = connectionUrl.getPath();
            if (urlPath.length() > 0) {
                String[] segments = urlPath.split("\\/");
                this.baseUrl = this.host.toURI() + "/" + (segments[0].length() > 0 ? segments[0] : segments[1]);
            } else {
                this.baseUrl = this.host.toURI();
            }
            this.httpClient = new DefaultHttpClient();
            if (!StringUtil.isBlank((String)username)) {
                this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.host), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL string: " + url, e);
        }
    }

    protected String url() {
        return this.url;
    }

    protected HttpHost host() {
        return this.host;
    }

    protected Response doGet() {
        return new Response((HttpRequestBase)this.newJSONRequest(HttpGet.class, null, null, null));
    }

    protected Response doGet(String url) {
        return new Response((HttpRequestBase)this.newJSONRequest(HttpGet.class, null, null, url));
    }

    protected Response postStream(InputStream is, String url, String requestContentType) {
        HttpPost post = this.newJSONRequest(HttpPost.class, is, requestContentType, url);
        return new Response((HttpRequestBase)post);
    }

    protected Response postStreamTextPlain(InputStream is, String url, String requestContentType) {
        HttpPost post = this.newRequest(HttpPost.class, is, requestContentType, "text/plain;", url);
        return new Response((HttpRequestBase)post);
    }

    private <T extends HttpRequestBase> T newJSONRequest(Class<T> clazz, InputStream inputStream, String contentType, String url) {
        return this.newRequest(clazz, inputStream, contentType, "application/json", url);
    }

    private <T extends HttpRequestBase> T newRequest(Class<T> clazz, InputStream inputStream, String contentType, String accepts, String url) {
        assert (accepts != null);
        try {
            URIBuilder uriBuilder;
            if (url == null) {
                url = this.baseUrl;
            } else if (!url.startsWith(this.host.getSchemeName())) {
                url = this.appendToBaseURL(url);
            }
            try {
                uriBuilder = new URIBuilder(url);
            }
            catch (URISyntaxException e) {
                uriBuilder = new URIBuilder(URL_ENCODER.encode(url));
            }
            HttpRequestBase result = (HttpRequestBase)clazz.getConstructor(URI.class).newInstance(uriBuilder.build());
            result.setHeader("Accept", accepts);
            if (contentType != null) {
                result.setHeader("Content-Type", contentType);
            }
            HttpParams params = result.getParams();
            for (NameValuePair nameValuePair : uriBuilder.getQueryParams()) {
                params.setParameter(nameValuePair.getName(), (Object)nameValuePair.getValue());
            }
            if (inputStream != null) {
                assert (result instanceof HttpEntityEnclosingRequestBase);
                InputStreamEntity inputStreamEntity = new InputStreamEntity(inputStream, (long)inputStream.available());
                ((HttpEntityEnclosingRequestBase)result).setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)inputStreamEntity));
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static String append(String url, String ... segments) {
        for (String segment : segments) {
            if (url.endsWith(segment)) continue;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            url = url + segment;
        }
        return url;
    }

    protected String appendToBaseURL(String ... segments) {
        return JSONRestClient.append(this.baseUrl, segments);
    }

    protected String appendToURL(String ... segments) {
        return JSONRestClient.append(this.url, segments);
    }

    protected class Response {
        private final HttpResponse response;
        private byte[] content;
        private String contentString;
        private JSONObject contentJSON;

        protected Response(HttpRequestBase request) {
            try {
                this.response = JSONRestClient.this.httpClient.execute(JSONRestClient.this.host(), (HttpRequest)request);
                HttpEntity entity = this.response.getEntity();
                if (entity != null) {
                    ByteArrayOutputStream baous = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)baous);
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                    this.content = baous.toByteArray();
                } else {
                    this.content = new byte[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                request.releaseConnection();
            }
        }

        public boolean isOK() {
            return this.hasCode(200);
        }

        private int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        private boolean hasCode(int statusCode) {
            return this.getStatusCode() == statusCode;
        }

        public JSONObject json() {
            try {
                if (this.contentJSON == null) {
                    this.contentJSON = new JSONObject(this.asString());
                }
                return this.contentJSON;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public String asString() {
            if (this.contentString == null) {
                this.contentString = new String(this.content);
            }
            return this.contentString;
        }

        public String toString() {
            return this.asString();
        }
    }

    protected static interface MediaType {
        public static final String APPLICATION_JSON = "application/json";
        public static final String TEXT_PLAIN = "text/plain;";
    }
}

