/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.dom4j.Element;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.tool.hbm2x.MetaAttributeHelper;

public class MetaAttributeBinder {
    public static MultiMap mergeMetaMaps(Map specific, Map general) {
        MultiHashMap result = new MultiHashMap();
        MetaAttributeHelper.copyMultiMap(result, specific);
        if (general != null) {
            Iterator iter = general.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (specific.containsKey(key)) continue;
                Collection ml = (Collection)general.get(key);
                Iterator iterator = ml.iterator();
                while (iterator.hasNext()) {
                    SimpleMetaAttribute element = (SimpleMetaAttribute)iterator.next();
                    if (!element.inheritable) continue;
                    result.put(key, element);
                }
            }
        }
        return result;
    }

    public static MetaAttribute toRealMetaAttribute(String name, List values) {
        MetaAttribute attribute = new MetaAttribute(name);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            SimpleMetaAttribute element = (SimpleMetaAttribute)iter.next();
            attribute.addValue(element.value);
        }
        return attribute;
    }

    public static MultiMap loadAndMergeMetaMap(Element classElement, MultiMap inheritedMeta) {
        return MetaAttributeBinder.mergeMetaMaps(MetaAttributeBinder.loadMetaMap(classElement), inheritedMeta);
    }

    protected static MultiMap loadMetaMap(Element element) {
        MultiHashMap result = new MultiHashMap();
        ArrayList metaAttributeList = new ArrayList();
        metaAttributeList.addAll(element.elements("meta"));
        Iterator iter = metaAttributeList.iterator();
        while (iter.hasNext()) {
            Element metaAttrib = (Element)iter.next();
            String attribute = metaAttrib.attributeValue("attribute");
            String value = metaAttrib.getText();
            String inheritStr = metaAttrib.attributeValue("inherit");
            boolean inherit = true;
            if (inheritStr != null) {
                inherit = Boolean.valueOf(inheritStr);
            }
            SimpleMetaAttribute ma = new SimpleMetaAttribute(value, inherit);
            result.put(attribute, ma);
        }
        return result;
    }

    static class SimpleMetaAttribute {
        String value;
        boolean inheritable = true;

        public SimpleMetaAttribute(String value, boolean inherit) {
            this.value = value;
            this.inheritable = inherit;
        }

        public String toString() {
            return this.value;
        }
    }
}

