/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.DatasourceConnectionProvider;
import org.hibernate.connection.DriverManagerConnectionProvider;
import org.hibernate.connection.UserSuppliedConnectionProvider;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionProviderFactory.class);
    private static final Set SPECIAL_PROPERTIES = new HashSet();

    public static ConnectionProvider newConnectionProvider() throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(Environment.getProperties());
    }

    public static ConnectionProvider newConnectionProvider(Properties properties) throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(properties, null);
    }

    public static ConnectionProvider newConnectionProvider(Properties properties, Map connectionProviderInjectionData) throws HibernateException {
        ConnectionProvider connections;
        String providerClass = properties.getProperty("hibernate.connection.provider_class");
        if (providerClass != null) {
            try {
                log.info("Initializing connection provider: " + providerClass);
                connections = (ConnectionProvider)ReflectHelper.classForName(providerClass).newInstance();
            }
            catch (Exception e) {
                log.error("Could not instantiate connection provider", e);
                throw new HibernateException("Could not instantiate connection provider: " + providerClass);
            }
        } else {
            connections = properties.getProperty("hibernate.connection.datasource") != null ? new DatasourceConnectionProvider() : (properties.getProperty("hibernate.connection.url") != null ? new DriverManagerConnectionProvider() : new UserSuppliedConnectionProvider());
        }
        if (connectionProviderInjectionData != null && connectionProviderInjectionData.size() != 0) {
            try {
                BeanInfo info = Introspector.getBeanInfo(connections.getClass());
                PropertyDescriptor[] descritors = info.getPropertyDescriptors();
                int size = descritors.length;
                for (int index = 0; index < size; ++index) {
                    String propertyName = descritors[index].getName();
                    if (!connectionProviderInjectionData.containsKey(propertyName)) continue;
                    Method method = descritors[index].getWriteMethod();
                    method.invoke((Object)connections, connectionProviderInjectionData.get(propertyName));
                }
            }
            catch (IntrospectionException e) {
                throw new HibernateException("Unable to inject objects into the conenction provider", e);
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to inject objects into the conenction provider", e);
            }
            catch (InvocationTargetException e) {
                throw new HibernateException("Unable to inject objects into the conenction provider", e);
            }
        }
        connections.configure(properties);
        return connections;
    }

    private ConnectionProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static Properties getConnectionProperties(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (!prop.startsWith("hibernate.connection") || SPECIAL_PROPERTIES.contains(prop)) continue;
            result.setProperty(prop.substring("hibernate.connection".length() + 1), properties.getProperty(prop));
        }
        String userName = properties.getProperty("hibernate.connection.username");
        if (userName != null) {
            result.setProperty("user", userName);
        }
        return result;
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
    }
}

