/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;
import org.hibernate.ejb.criteria.predicate.TruthValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitTruthValueCheck
extends AbstractSimplePredicate
implements Serializable {
    private final Expression<Boolean> booleanExpression;
    private final TruthValue truthValue;

    public ExplicitTruthValueCheck(CriteriaBuilderImpl criteriaBuilder, Expression<Boolean> booleanExpression, TruthValue truthValue) {
        super(criteriaBuilder);
        this.booleanExpression = booleanExpression;
        this.truthValue = truthValue;
    }

    public Expression<Boolean> getBooleanExpression() {
        return this.booleanExpression;
    }

    public TruthValue getTruthValue() {
        return this.truthValue;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getBooleanExpression(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return ((Renderable)((Object)this.getBooleanExpression())).render(renderingContext) + " = " + (this.getTruthValue() == TruthValue.TRUE ? "true" : "false");
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

