/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.ejb.metamodel.AbstractManagedType;
import org.hibernate.ejb.metamodel.AttributeImplementor;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttribute<X, Y>
implements Attribute<X, Y>,
AttributeImplementor<X, Y>,
Serializable {
    private final String name;
    private final Class<Y> javaType;
    private final AbstractManagedType<X> declaringType;
    private transient Member member;
    private final Attribute.PersistentAttributeType persistentAttributeType;

    public AbstractAttribute(String name, Class<Y> javaType, AbstractManagedType<X> declaringType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
        this.name = name;
        this.javaType = javaType;
        this.declaringType = declaringType;
        this.member = member;
        this.persistentAttributeType = persistentAttributeType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ManagedType<X> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Class<Y> getJavaType() {
        return this.javaType;
    }

    @Override
    public Member getJavaMember() {
        return this.member;
    }

    @Override
    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistentAttributeType;
    }

    protected void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String memberDeclaringClassName = (String)ois.readObject();
        String memberName = (String)ois.readObject();
        String memberType = (String)ois.readObject();
        Class<?> memberDeclaringClass = Class.forName(memberDeclaringClassName, false, this.declaringType.getJavaType().getClassLoader());
        try {
            this.member = "method".equals(memberType) ? memberDeclaringClass.getMethod(memberName, ReflectHelper.NO_PARAM_SIGNATURE) : memberDeclaringClass.getField(memberName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to locate member [" + memberDeclaringClassName + "#" + memberName + "]");
        }
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getJavaMember().getDeclaringClass().getName());
        oos.writeObject(this.getJavaMember().getName());
        oos.writeObject(Method.class.isInstance(this.getJavaMember()) ? "method" : "field");
    }
}

