/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.EntityMode;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ejb.metamodel.AbstractIdentifiableType;
import org.hibernate.ejb.metamodel.AbstractManagedType;
import org.hibernate.ejb.metamodel.AttributeImplementor;
import org.hibernate.ejb.metamodel.BasicTypeImpl;
import org.hibernate.ejb.metamodel.EmbeddableTypeImpl;
import org.hibernate.ejb.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.ejb.metamodel.PluralAttributeImpl;
import org.hibernate.ejb.metamodel.SingularAttributeImpl;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeFactory {
    private static final Logger log = LoggerFactory.getLogger(AttributeFactory.class);
    private final MetadataContext context;
    private final MemberResolver EMBEDDED_MEMBER_RESOLVER = new MemberResolver(){

        public Member resolveMember(AttributeContext attributeContext) {
            EmbeddableTypeImpl embeddableType = (EmbeddableTypeImpl)attributeContext.getOwnerType();
            String attributeName = attributeContext.getPropertyMapping().getName();
            return embeddableType.getHibernateType().getTuplizerMapping().getTuplizer(EntityMode.POJO).getGetter(embeddableType.getHibernateType().getPropertyIndex(attributeName)).getMember();
        }
    };
    private final MemberResolver VIRTUAL_IDENTIFIER_MEMBER_RESOLVER = new MemberResolver(){

        public Member resolveMember(AttributeContext attributeContext) {
            IdentifiableType identifiableType = (IdentifiableType)((Object)attributeContext.getOwnerType());
            EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
            if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
                throw new IllegalArgumentException("expecting IdClass mapping");
            }
            Type type = entityMetamodel.getIdentifierProperty().getType();
            if (!EmbeddedComponentType.class.isInstance(type)) {
                throw new IllegalArgumentException("expecting IdClass mapping");
            }
            EmbeddedComponentType componentType = (EmbeddedComponentType)type;
            String attributeName = attributeContext.getPropertyMapping().getName();
            return componentType.getTuplizerMapping().getTuplizer(EntityMode.POJO).getGetter(componentType.getPropertyIndex(attributeName)).getMember();
        }
    };
    private final MemberResolver NORMAL_MEMBER_RESOLVER = new MemberResolver(){

        public Member resolveMember(AttributeContext attributeContext) {
            AbstractManagedType ownerType = attributeContext.getOwnerType();
            Property property = attributeContext.getPropertyMapping();
            Type.PersistenceType persistenceType = ownerType.getPersistenceType();
            if (Type.PersistenceType.EMBEDDABLE == persistenceType) {
                return AttributeFactory.this.EMBEDDED_MEMBER_RESOLVER.resolveMember(attributeContext);
            }
            if (Type.PersistenceType.ENTITY == persistenceType || Type.PersistenceType.MAPPED_SUPERCLASS == persistenceType) {
                String propertyName;
                IdentifiableType identifiableType = (IdentifiableType)((Object)ownerType);
                EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
                Integer index = entityMetamodel.getPropertyIndexOrNull(propertyName = property.getName());
                if (index == null) {
                    return AttributeFactory.this.VIRTUAL_IDENTIFIER_MEMBER_RESOLVER.resolveMember(attributeContext);
                }
                return entityMetamodel.getTuplizer(EntityMode.POJO).getGetter(index).getMember();
            }
            throw new IllegalArgumentException("Unexpected owner type : " + (Object)((Object)persistenceType));
        }
    };
    private final MemberResolver IDENTIFIER_MEMBER_RESOLVER = new MemberResolver(){

        public Member resolveMember(AttributeContext attributeContext) {
            IdentifiableType identifiableType = (IdentifiableType)((Object)attributeContext.getOwnerType());
            EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
            if (!attributeContext.getPropertyMapping().getName().equals(entityMetamodel.getIdentifierProperty().getName())) {
                return AttributeFactory.this.VIRTUAL_IDENTIFIER_MEMBER_RESOLVER.resolveMember(attributeContext);
            }
            return entityMetamodel.getTuplizer(EntityMode.POJO).getIdentifierGetter().getMember();
        }
    };
    private final MemberResolver VERSION_MEMBER_RESOLVER = new MemberResolver(){

        public Member resolveMember(AttributeContext attributeContext) {
            IdentifiableType identifiableType = (IdentifiableType)((Object)attributeContext.getOwnerType());
            EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
            String versionPropertyName = attributeContext.getPropertyMapping().getName();
            if (!versionPropertyName.equals(entityMetamodel.getVersionProperty().getName())) {
                throw new IllegalArgumentException("Given property did not match declared version property");
            }
            return entityMetamodel.getTuplizer(EntityMode.POJO).getVersionGetter().getMember();
        }
    };

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> AttributeImplementor<X, Y> buildAttribute(AbstractManagedType<X> ownerType, Property property) {
        if (property.isSynthetic()) {
            log.trace("Skipping synthetic property {}({})", (Object)ownerType.getJavaType().getName(), (Object)property.getName());
            return null;
        }
        log.trace("Building attribute [{}.{}]", (Object)ownerType.getJavaType().getName(), (Object)property.getName());
        AttributeContext<X> attributeContext = this.wrap(ownerType, property);
        AttributeMetadata<X, Y> attributeMetadata = this.determineAttributeMetadata(attributeContext, this.NORMAL_MEMBER_RESOLVER);
        if (attributeMetadata.isPlural()) {
            return this.buildPluralAttribute((PluralAttributeMetadata)attributeMetadata);
        }
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        javax.persistence.metamodel.Type<Y> metaModelType = this.getMetaModelType(singularAttributeMetadata.getValueContext());
        return new SingularAttributeImpl<X, Y>(attributeMetadata.getName(), attributeMetadata.getJavaType(), ownerType, attributeMetadata.getMember(), false, false, property.isOptional(), metaModelType, attributeMetadata.getPersistentAttributeType());
    }

    private <X> AttributeContext<X> wrap(final AbstractManagedType<X> ownerType, final Property property) {
        return new AttributeContext<X>(){

            @Override
            public AbstractManagedType<X> getOwnerType() {
                return ownerType;
            }

            @Override
            public Property getPropertyMapping() {
                return property;
            }
        };
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildIdAttribute(AbstractIdentifiableType<X> ownerType, Property property) {
        log.trace("Building identifier attribute [{}.{}]", (Object)ownerType.getJavaType().getName(), (Object)property.getName());
        AttributeContext<X> attributeContext = this.wrap(ownerType, property);
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(attributeContext, this.IDENTIFIER_MEMBER_RESOLVER);
        javax.persistence.metamodel.Type<Y> metaModelType = this.getMetaModelType(attributeMetadata.getValueContext());
        return new SingularAttributeImpl.Identifier(property.getName(), attributeMetadata.getJavaType(), ownerType, attributeMetadata.getMember(), metaModelType, attributeMetadata.getPersistentAttributeType());
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(AbstractIdentifiableType<X> ownerType, Property property) {
        log.trace("Building version attribute [{}.{}]", (Object)ownerType.getJavaType().getName(), (Object)property.getName());
        AttributeContext<X> attributeContext = this.wrap(ownerType, property);
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(attributeContext, this.VERSION_MEMBER_RESOLVER);
        javax.persistence.metamodel.Type<Y> metaModelType = this.getMetaModelType(attributeMetadata.getValueContext());
        return new SingularAttributeImpl.Version(property.getName(), attributeMetadata.getJavaType(), ownerType, attributeMetadata.getMember(), metaModelType, attributeMetadata.getPersistentAttributeType());
    }

    private <X, Y, E, K> AttributeImplementor<X, Y> buildPluralAttribute(PluralAttributeMetadata<X, Y, E> attributeMetadata) {
        javax.persistence.metamodel.Type<Y> elementType = this.getMetaModelType(attributeMetadata.getElementValueContext());
        if (java.util.Map.class.isAssignableFrom(attributeMetadata.getJavaType())) {
            javax.persistence.metamodel.Type<Y> keyType = this.getMetaModelType(attributeMetadata.getMapKeyValueContext());
            return PluralAttributeImpl.create(attributeMetadata.getOwnerType(), elementType, attributeMetadata.getJavaType(), keyType).member(attributeMetadata.getMember()).property(attributeMetadata.getPropertyMapping()).persistentAttributeType(attributeMetadata.getPersistentAttributeType()).build();
        }
        return PluralAttributeImpl.create(attributeMetadata.getOwnerType(), elementType, attributeMetadata.getJavaType(), null).member(attributeMetadata.getMember()).property(attributeMetadata.getPropertyMapping()).persistentAttributeType(attributeMetadata.getPersistentAttributeType()).build();
    }

    private <Y> javax.persistence.metamodel.Type<Y> getMetaModelType(ValueContext typeContext) {
        switch (typeContext.getValueClassification()) {
            case BASIC: {
                return new BasicTypeImpl(typeContext.getBindableType(), Type.PersistenceType.BASIC);
            }
            case ENTITY: {
                EntityType type = (EntityType)typeContext.getValue().getType();
                return this.context.locateEntityType(type.getAssociatedEntityName());
            }
            case EMBEDDABLE: {
                Component component = (Component)typeContext.getValue();
                EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(typeContext.getBindableType(), typeContext.getAttributeMetadata().getOwnerType(), (ComponentType)typeContext.getValue().getType());
                this.context.registerEmbeddedableType(embeddableType);
                Iterator subProperties = component.getPropertyIterator();
                while (subProperties.hasNext()) {
                    Property property = (Property)subProperties.next();
                    AttributeImplementor attribute = this.buildAttribute(embeddableType, property);
                    if (attribute == null) continue;
                    embeddableType.getBuilder().addAttribute(attribute);
                }
                embeddableType.lock();
                return embeddableType;
            }
        }
        throw new AssertionFailure("Unknown type : " + (Object)((Object)typeContext.getValueClassification()));
    }

    private EntityMetamodel getDeclarerEntityMetamodel(IdentifiableType<?> ownerType) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return this.context.getSessionFactory().getEntityPersister(ownerType.getJavaType().getName()).getEntityMetamodel();
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = this.context.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return this.context.getSessionFactory().getEntityPersister(persistentClass.getClassName()).getEntityMetamodel();
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + (Object)((Object)persistenceType));
    }

    private <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver) {
        log.trace("Starting attribute metadata determination [{}]", (Object)attributeContext.getPropertyMapping().getName());
        Member member = memberResolver.resolveMember(attributeContext);
        log.trace("    Determined member [{}]", member);
        Value value = attributeContext.getPropertyMapping().getValue();
        Type type = value.getType();
        log.trace("    determined type [name={}, class={}]", (Object)type.getName(), (Object)type.getClass().getName());
        if (type.isAnyType()) {
            throw new UnsupportedOperationException("any not supported yet");
        }
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                return new SingularAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, AttributeFactory.determineSingularAssociationAttributeType(member));
            }
            if (value instanceof org.hibernate.mapping.Collection) {
                Attribute.PersistentAttributeType keyPersistentAttributeType;
                Attribute.PersistentAttributeType persistentAttributeType;
                Attribute.PersistentAttributeType elementPersistentAttributeType;
                org.hibernate.mapping.Collection collValue = (org.hibernate.mapping.Collection)value;
                Value elementValue = collValue.getElement();
                Type elementType = elementValue.getType();
                if (elementType.isAnyType()) {
                    throw new UnsupportedOperationException("collection of any not supported yet");
                }
                boolean isManyToMany = AttributeFactory.isManyToMany(member);
                if (elementValue instanceof Component) {
                    elementPersistentAttributeType = Attribute.PersistentAttributeType.EMBEDDED;
                    persistentAttributeType = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                } else if (elementType.isAssociationType()) {
                    persistentAttributeType = elementPersistentAttributeType = isManyToMany ? Attribute.PersistentAttributeType.MANY_TO_MANY : Attribute.PersistentAttributeType.ONE_TO_MANY;
                } else {
                    elementPersistentAttributeType = Attribute.PersistentAttributeType.BASIC;
                    persistentAttributeType = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                }
                if (value instanceof Map) {
                    Value keyValue = ((Map)value).getIndex();
                    Type keyType = keyValue.getType();
                    if (keyType.isAnyType()) {
                        throw new UnsupportedOperationException("collection of any not supported yet");
                    }
                    keyPersistentAttributeType = keyValue instanceof Component ? Attribute.PersistentAttributeType.EMBEDDED : (keyType.isAssociationType() ? Attribute.PersistentAttributeType.MANY_TO_ONE : Attribute.PersistentAttributeType.BASIC);
                } else {
                    keyPersistentAttributeType = null;
                }
                return new PluralAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, persistentAttributeType, elementPersistentAttributeType, keyPersistentAttributeType);
            }
            if (value instanceof OneToMany) {
                throw new IllegalArgumentException("HUH???");
            }
        } else {
            if (attributeContext.getPropertyMapping().isComposite()) {
                return new SingularAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, Attribute.PersistentAttributeType.EMBEDDED);
            }
            return new SingularAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, Attribute.PersistentAttributeType.BASIC);
        }
        throw new UnsupportedOperationException("oops, we are missing something: " + attributeContext.getPropertyMapping());
    }

    public static Attribute.PersistentAttributeType determineSingularAssociationAttributeType(Member member) {
        if (Field.class.isInstance(member)) {
            return ((Field)member).getAnnotation(OneToOne.class) != null ? Attribute.PersistentAttributeType.ONE_TO_ONE : Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
        return ((Method)member).getAnnotation(OneToOne.class) != null ? Attribute.PersistentAttributeType.ONE_TO_ONE : Attribute.PersistentAttributeType.MANY_TO_ONE;
    }

    protected <Y> Class<Y> accountForPrimitiveTypes(Class<Y> declaredType) {
        return declaredType;
    }

    public static ParameterizedType getSignatureType(Member member) {
        java.lang.reflect.Type type;
        java.lang.reflect.Type type2 = type = Field.class.isInstance(member) ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType();
        if (type instanceof Class) {
            return null;
        }
        return (ParameterizedType)type;
    }

    public static PluralAttribute.CollectionType determineCollectionType(Class javaType) {
        if (List.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.LIST;
        }
        if (Set.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.SET;
        }
        if (java.util.Map.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.MAP;
        }
        if (Collection.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.COLLECTION;
        }
        throw new IllegalArgumentException("Expecting collection type [" + javaType.getName() + "]");
    }

    public static boolean isManyToMany(Member member) {
        return Field.class.isInstance(member) ? ((Field)member).getAnnotation(ManyToMany.class) != null : ((Method)member).getAnnotation(ManyToMany.class) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluralAttributeMetadataImpl<X, Y, E>
    extends BaseAttributeMetadata<X, Y>
    implements PluralAttributeMetadata<X, Y, E> {
        private final PluralAttribute.CollectionType attributeCollectionType;
        private final Attribute.PersistentAttributeType elementPersistentAttributeType;
        private final Attribute.PersistentAttributeType keyPersistentAttributeType;
        private final Class elementJavaType;
        private final Class keyJavaType;
        private final ValueContext elementValueContext;
        private final ValueContext keyValueContext;

        private PluralAttributeMetadataImpl(Property propertyMapping, AbstractManagedType<X> ownerType, Member member, Attribute.PersistentAttributeType persistentAttributeType, Attribute.PersistentAttributeType elementPersistentAttributeType, Attribute.PersistentAttributeType keyPersistentAttributeType) {
            super(propertyMapping, ownerType, member, persistentAttributeType);
            this.attributeCollectionType = AttributeFactory.determineCollectionType(this.getJavaType());
            this.elementPersistentAttributeType = elementPersistentAttributeType;
            this.keyPersistentAttributeType = keyPersistentAttributeType;
            ParameterizedType signatureType = AttributeFactory.getSignatureType(member);
            if (keyPersistentAttributeType == null) {
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                this.keyJavaType = null;
            } else {
                this.keyJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[1]) : Object.class;
            }
            this.elementValueContext = new ValueContext(){

                public Value getValue() {
                    return ((org.hibernate.mapping.Collection)PluralAttributeMetadataImpl.this.getPropertyMapping().getValue()).getElement();
                }

                public Class getBindableType() {
                    return PluralAttributeMetadataImpl.this.elementJavaType;
                }

                public ValueContext.ValueClassification getValueClassification() {
                    switch (PluralAttributeMetadataImpl.this.elementPersistentAttributeType) {
                        case EMBEDDED: {
                            return ValueContext.ValueClassification.EMBEDDABLE;
                        }
                        case BASIC: {
                            return ValueContext.ValueClassification.BASIC;
                        }
                    }
                    return ValueContext.ValueClassification.ENTITY;
                }

                public AttributeMetadata getAttributeMetadata() {
                    return PluralAttributeMetadataImpl.this;
                }
            };
            this.keyValueContext = keyPersistentAttributeType != null ? new ValueContext(){

                public Value getValue() {
                    return ((Map)PluralAttributeMetadataImpl.this.getPropertyMapping().getValue()).getIndex();
                }

                public Class getBindableType() {
                    return PluralAttributeMetadataImpl.this.keyJavaType;
                }

                public ValueContext.ValueClassification getValueClassification() {
                    switch (PluralAttributeMetadataImpl.this.keyPersistentAttributeType) {
                        case EMBEDDED: {
                            return ValueContext.ValueClassification.EMBEDDABLE;
                        }
                        case BASIC: {
                            return ValueContext.ValueClassification.BASIC;
                        }
                    }
                    return ValueContext.ValueClassification.ENTITY;
                }

                public AttributeMetadata getAttributeMetadata() {
                    return PluralAttributeMetadataImpl.this;
                }
            } : null;
        }

        private Class<?> getClassFromGenericArgument(java.lang.reflect.Type type) {
            Class<?> javaType;
            java.lang.reflect.Type unsafeElementType = type;
            if (unsafeElementType instanceof Class) {
                javaType = (Class<?>)unsafeElementType;
            } else if (unsafeElementType instanceof TypeVariable) {
                java.lang.reflect.Type upperBound = ((TypeVariable)unsafeElementType).getBounds()[0];
                javaType = this.getClassFromGenericArgument(upperBound);
            } else {
                throw new AssertionFailure("Fail to process type argument in a generic declaration. Type: " + type.getClass());
            }
            return javaType;
        }

        @Override
        public ValueContext getElementValueContext() {
            return this.elementValueContext;
        }

        @Override
        public PluralAttribute.CollectionType getAttributeCollectionType() {
            return this.attributeCollectionType;
        }

        @Override
        public ValueContext getMapKeyValueContext() {
            return this.keyValueContext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingularAttributeMetadataImpl<X, Y>
    extends BaseAttributeMetadata<X, Y>
    implements SingularAttributeMetadata<X, Y> {
        private final ValueContext valueContext;

        private SingularAttributeMetadataImpl(Property propertyMapping, AbstractManagedType<X> ownerType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
            super(propertyMapping, ownerType, member, persistentAttributeType);
            this.valueContext = new ValueContext(){

                public Value getValue() {
                    return SingularAttributeMetadataImpl.this.getPropertyMapping().getValue();
                }

                public Class getBindableType() {
                    return this.getAttributeMetadata().getJavaType();
                }

                public ValueContext.ValueClassification getValueClassification() {
                    switch (SingularAttributeMetadataImpl.this.getPersistentAttributeType()) {
                        case EMBEDDED: {
                            return ValueContext.ValueClassification.EMBEDDABLE;
                        }
                        case BASIC: {
                            return ValueContext.ValueClassification.BASIC;
                        }
                    }
                    return ValueContext.ValueClassification.ENTITY;
                }

                public AttributeMetadata getAttributeMetadata() {
                    return SingularAttributeMetadataImpl.this;
                }
            };
        }

        @Override
        public ValueContext getValueContext() {
            return this.valueContext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseAttributeMetadata<X, Y>
    implements AttributeMetadata<X, Y> {
        private final Property propertyMapping;
        private final AbstractManagedType<X> ownerType;
        private final Member member;
        private final Class<Y> javaType;
        private final Attribute.PersistentAttributeType persistentAttributeType;

        protected BaseAttributeMetadata(Property propertyMapping, AbstractManagedType<X> ownerType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
            Class<?> declaredType;
            this.propertyMapping = propertyMapping;
            this.ownerType = ownerType;
            this.member = member;
            this.persistentAttributeType = persistentAttributeType;
            if (Field.class.isInstance(member)) {
                declaredType = ((Field)member).getType();
            } else if (Method.class.isInstance(member)) {
                declaredType = ((Method)member).getReturnType();
            } else {
                throw new IllegalArgumentException("Cannot determine java-type from given member [" + member + "]");
            }
            this.javaType = AttributeFactory.this.accountForPrimitiveTypes(declaredType);
        }

        @Override
        public String getName() {
            return this.propertyMapping.getName();
        }

        @Override
        public Member getMember() {
            return this.member;
        }

        @Override
        public Class<Y> getJavaType() {
            return this.javaType;
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            return this.persistentAttributeType;
        }

        @Override
        public AbstractManagedType<X> getOwnerType() {
            return this.ownerType;
        }

        @Override
        public boolean isPlural() {
            return this.propertyMapping.getType().isCollectionType();
        }

        @Override
        public Property getPropertyMapping() {
            return this.propertyMapping;
        }
    }

    private static interface MemberResolver {
        public Member resolveMember(AttributeContext var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AttributeContext<X> {
        public AbstractManagedType<X> getOwnerType();

        public Property getPropertyMapping();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PluralAttributeMetadata<X, Y, E>
    extends AttributeMetadata<X, Y> {
        public PluralAttribute.CollectionType getAttributeCollectionType();

        public ValueContext getElementValueContext();

        public ValueContext getMapKeyValueContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SingularAttributeMetadata<X, Y>
    extends AttributeMetadata<X, Y> {
        public ValueContext getValueContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AttributeMetadata<X, Y> {
        public String getName();

        public Member getMember();

        public Class<Y> getJavaType();

        public Attribute.PersistentAttributeType getPersistentAttributeType();

        public AbstractManagedType<X> getOwnerType();

        public Property getPropertyMapping();

        public boolean isPlural();
    }

    private static interface ValueContext {
        public Value getValue();

        public Class getBindableType();

        public ValueClassification getValueClassification();

        public AttributeMetadata getAttributeMetadata();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ValueClassification {
            EMBEDDABLE,
            ENTITY,
            BASIC;

        }
    }
}

