/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.ejb.metamodel.EmbeddableTypeImpl;
import org.hibernate.ejb.metamodel.EntityTypeImpl;
import org.hibernate.ejb.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
implements Metamodel,
Serializable {
    private final Map<Class<?>, EntityTypeImpl<?>> entities;
    private final Map<Class<?>, EmbeddableTypeImpl<?>> embeddables;

    public static MetamodelImpl buildMetamodel(Iterator<PersistentClass> persistentClasses, SessionFactoryImplementor sessionFactory) {
        MetadataContext context = new MetadataContext(sessionFactory);
        while (persistentClasses.hasNext()) {
            PersistentClass pc = persistentClasses.next();
            if (pc.getMappedClass() == null) continue;
            MetamodelImpl.locateOrBuildEntityType(pc, context);
        }
        context.wrapUp();
        return new MetamodelImpl(context.getEntityTypeMap(), context.getEmbeddableTypeMap());
    }

    private static EntityTypeImpl<?> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context) {
        EntityTypeImpl<?> entityType = context.locateEntityType(persistentClass);
        if (entityType == null) {
            entityType = MetamodelImpl.buildEntityType(persistentClass, context);
        }
        return entityType;
    }

    private static EntityTypeImpl<?> buildEntityType(PersistentClass persistentClass, MetadataContext context) {
        MappedSuperclassTypeImpl<?> superType;
        Class javaType = persistentClass.getMappedClass();
        context.pushEntityWorkedOn(persistentClass);
        MappedSuperclass superMappedSuperclass = persistentClass.getSuperMappedSuperclass();
        MappedSuperclassTypeImpl<?> mappedSuperclassTypeImpl = superType = superMappedSuperclass == null ? null : MetamodelImpl.locateOrBuildMappedsuperclassType(superMappedSuperclass, context);
        if (superType == null) {
            PersistentClass superPersistentClass = persistentClass.getSuperclass();
            superType = superPersistentClass == null ? null : MetamodelImpl.locateOrBuildEntityType(superPersistentClass, context);
        }
        EntityTypeImpl entityType = new EntityTypeImpl(javaType, superType, persistentClass.getClassName(), persistentClass.hasIdentifierProperty(), persistentClass.isVersioned());
        context.registerEntityType(persistentClass, entityType);
        context.popEntityWorkedOn(persistentClass);
        return entityType;
    }

    private static MappedSuperclassTypeImpl<?> locateOrBuildMappedsuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context) {
        MappedSuperclassTypeImpl<?> mappedSuperclassType = context.locateMappedSuperclassType(mappedSuperclass);
        if (mappedSuperclassType == null) {
            mappedSuperclassType = MetamodelImpl.buildMappedSuperclassType(mappedSuperclass, context);
        }
        return mappedSuperclassType;
    }

    private static MappedSuperclassTypeImpl<?> buildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context) {
        MappedSuperclassTypeImpl<?> superType;
        MappedSuperclass superMappedSuperclass = mappedSuperclass.getSuperMappedSuperclass();
        MappedSuperclassTypeImpl<?> mappedSuperclassTypeImpl = superType = superMappedSuperclass == null ? null : MetamodelImpl.locateOrBuildMappedsuperclassType(superMappedSuperclass, context);
        if (superType == null) {
            PersistentClass superPersistentClass = mappedSuperclass.getSuperPersistentClass();
            superType = superPersistentClass == null ? null : MetamodelImpl.locateOrBuildEntityType(superPersistentClass, context);
        }
        Class javaType = mappedSuperclass.getMappedClass();
        MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(javaType, superType, mappedSuperclass.hasIdentifierProperty(), mappedSuperclass.isVersioned());
        context.registerMappedSuperclassType(mappedSuperclass, mappedSuperclassType);
        return mappedSuperclassType;
    }

    private MetamodelImpl(Map<Class<?>, EntityTypeImpl<?>> entities, Map<Class<?>, EmbeddableTypeImpl<?>> embeddables) {
        this.entities = entities;
        this.embeddables = embeddables;
    }

    @Override
    public <X> EntityType<X> entity(Class<X> cls) {
        EntityType entityType = this.entities.get(cls);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return entityType;
    }

    @Override
    public <X> ManagedType<X> managedType(Class<X> cls) {
        ManagedType type = this.entities.get(cls);
        if (type == null) {
            throw new IllegalArgumentException("Not an managed type: " + cls);
        }
        return type;
    }

    @Override
    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        EmbeddableType embeddableType = this.embeddables.get(cls);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return embeddableType;
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        HashSet managedTypes = new HashSet(this.entities.size() + this.embeddables.size());
        managedTypes.addAll(this.entities.values());
        managedTypes.addAll(this.embeddables.values());
        return managedTypes;
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.entities.values());
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.embeddables.values());
    }
}

