/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.Region;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.impl.CacheDataDescriptionImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.context.JTASessionContext;
import org.hibernate.context.ManagedSessionContext;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.QueryPlanCache;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventListeners;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.impl.SessionImpl;
import org.hibernate.impl.StatelessSessionImpl;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.PersisterFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImpl;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryImpl.class);
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private final String name;
    private final String uuid;
    private final transient Map entityPersisters;
    private final transient Map classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map collectionRolesByEntityParticipant;
    private final transient Map identifierGenerators;
    private final transient Map namedQueries;
    private final transient Map namedSqlQueries;
    private final transient Map sqlResultSetMappings;
    private final transient Map filters;
    private final transient Map fetchProfiles;
    private final transient Map imports;
    private final transient Interceptor interceptor;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient TransactionManager transactionManager;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map queryCaches;
    private final transient Map allCacheRegions = new HashMap();
    private final transient Statistics statistics;
    private final transient EventListeners eventListeners;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient EntityNotFoundDelegate entityNotFoundDelegate;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserver observer;
    private final transient HashMap entityNameResolvers = new HashMap();
    private final transient QueryPlanCache queryPlanCache = new QueryPlanCache(this);
    private final transient Cache cacheAccess = new CacheImpl();
    private transient boolean isClosed = false;
    static /* synthetic */ Class class$org$hibernate$ObjectNotFoundException;

    public SessionFactoryImpl(Configuration cfg, Mapping mapping, Settings settings, EventListeners listeners, SessionFactoryObserver observer) throws HibernateException {
        Map errors;
        Object persister;
        String entityName;
        log.info("building session factory");
        Statistics concurrentStatistics = null;
        try {
            Class concurrentStatsClass = ReflectHelper.classForName("org.hibernate.stat.ConcurrentStatisticsImpl");
            Constructor constructor = concurrentStatsClass.getConstructor(SessionFactoryImplementor.class);
            concurrentStatistics = (Statistics)constructor.newInstance(this);
            log.trace("JDK 1.5 concurrent classes present");
        }
        catch (Exception noJava5) {
            log.trace("JDK 1.5 concurrent classes missing");
        }
        this.statistics = concurrentStatistics != null ? concurrentStatistics : new StatisticsImpl(this);
        if (log.isTraceEnabled()) {
            log.trace("Statistics initialized with " + this.statistics.getClass().getName());
        }
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)cfg.getProperties());
        this.interceptor = cfg.getInterceptor();
        this.settings = settings;
        this.sqlFunctionRegistry = new SQLFunctionRegistry(settings.getDialect(), cfg.getSqlFunctions());
        this.eventListeners = listeners;
        this.observer = observer != null ? observer : new SessionFactoryObserver(){

            public void sessionFactoryCreated(SessionFactory factory) {
            }

            public void sessionFactoryClosed(SessionFactory factory) {
            }
        };
        this.filters = new HashMap();
        this.filters.putAll(cfg.getFilterDefinitions());
        if (log.isDebugEnabled()) {
            log.debug("Session factory constructed with filter configurations : " + this.filters);
        }
        if (log.isDebugEnabled()) {
            log.debug("instantiating session factory with properties: " + this.properties);
        }
        settings.getRegionFactory().start(settings, this.properties);
        this.identifierGenerators = new HashMap();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = (PersistentClass)classes.next();
            if (model.isInherited()) continue;
            IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(cfg.getIdentifierGeneratorFactory(), settings.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)model);
            this.identifierGenerators.put(model.getEntityName(), generator);
        }
        String cacheRegionPrefix = settings.getCacheRegionPrefix() == null ? "" : settings.getCacheRegionPrefix() + ".";
        this.entityPersisters = new HashMap();
        HashMap<String, Object> entityAccessStrategies = new HashMap<String, Object>();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            AccessType accessType;
            PersistentClass model = (PersistentClass)classes.next();
            model.prepareTemporaryTables(mapping, settings.getDialect());
            String cacheRegionName = cacheRegionPrefix + model.getRootClass().getCacheRegionName();
            EntityRegionAccessStrategy accessStrategy = (EntityRegionAccessStrategy)entityAccessStrategies.get(cacheRegionName);
            if (accessStrategy == null && settings.isSecondLevelCacheEnabled() && (accessType = AccessType.parse(model.getCacheConcurrencyStrategy())) != null) {
                log.trace("Building cache for entity data [" + model.getEntityName() + "]");
                EntityRegion entityRegion = settings.getRegionFactory().buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = entityRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, accessStrategy);
                this.allCacheRegions.put(cacheRegionName, entityRegion);
            }
            EntityPersister cp = PersisterFactory.createClassPersister(model, accessStrategy, this, mapping);
            this.entityPersisters.put(model.getEntityName(), cp);
            classMeta.put(model.getEntityName(), cp.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap();
        Iterator collections = cfg.getCollectionMappings();
        while (collections.hasNext()) {
            Type elementType;
            Collection model = (Collection)collections.next();
            String cacheRegionName = cacheRegionPrefix + model.getCacheRegionName();
            AccessType accessType = AccessType.parse(model.getCacheConcurrencyStrategy());
            CollectionRegionAccessStrategy accessStrategy = null;
            if (accessType != null && settings.isSecondLevelCacheEnabled()) {
                log.trace("Building cache for collection data [" + model.getRole() + "]");
                CollectionRegion collectionRegion = settings.getRegionFactory().buildCollectionRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, accessStrategy);
                this.allCacheRegions.put(cacheRegionName, collectionRegion);
            }
            CollectionPersister persister2 = PersisterFactory.createCollectionPersister(cfg, model, accessStrategy, this);
            this.collectionPersisters.put(model.getRole(), persister2.getCollectionMetadata());
            Type indexType = persister2.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                String entityName2 = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName2);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName2, roles);
                }
                roles.add(persister2.getRole());
            }
            if (!(elementType = persister2.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            entityName = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName, roles);
            }
            roles.add(persister2.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        Iterator itr = tmpEntityToCollectionRoleMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap(cfg.getNamedQueries());
        this.namedSqlQueries = new HashMap(cfg.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap(cfg.getSqlResultSetMappings());
        this.imports = new HashMap(cfg.getImports());
        Iterator iter = this.entityPersisters.values().iterator();
        while (iter.hasNext()) {
            persister = (EntityPersister)iter.next();
            persister.postInstantiate();
            this.registerEntityNameResolvers((EntityPersister)persister);
        }
        iter = this.collectionPersisters.values().iterator();
        while (iter.hasNext()) {
            persister = (CollectionPersister)iter.next();
            persister.postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, this.properties);
        log.debug("instantiated session factory");
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(cfg, settings).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(cfg, settings).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(cfg, settings).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(cfg, settings);
        }
        if (settings.getTransactionManagerLookup() != null) {
            log.debug("obtaining JTA TransactionManager");
            this.transactionManager = settings.getTransactionManagerLookup().getTransactionManager(this.properties);
        } else {
            if (settings.getTransactionFactory().isTransactionManagerRequired()) {
                throw new HibernateException("The chosen transaction strategy requires access to the JTA TransactionManager");
            }
            this.transactionManager = null;
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings, this.properties);
            this.queryCache = settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, settings, this.properties);
            this.queryCaches = new HashMap();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        if (settings.isNamedQueryStartupCheckingEnabled() && !(errors = this.checkNamedQueries()).isEmpty()) {
            Set keys = errors.keySet();
            StringBuffer failingQueries = new StringBuffer("Errors in named queries: ");
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String queryName = (String)iterator.next();
                HibernateException e = (HibernateException)errors.get(queryName);
                failingQueries.append(queryName);
                if (iterator.hasNext()) {
                    failingQueries.append(", ");
                }
                log.error("Error in named query: " + queryName, e);
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.getStatistics().setStatisticsEnabled(settings.isStatisticsEnabled());
        EntityNotFoundDelegate entityNotFoundDelegate = cfg.getEntityNotFoundDelegate();
        if (entityNotFoundDelegate == null) {
            entityNotFoundDelegate = new EntityNotFoundDelegate(){

                public void handleEntityNotFound(String entityName, Serializable id) {
                    throw new ObjectNotFoundException(id, entityName);
                }

                public boolean isEntityNotFoundException(RuntimeException exception) {
                    return (class$org$hibernate$ObjectNotFoundException == null ? (class$org$hibernate$ObjectNotFoundException = SessionFactoryImpl.class$("org.hibernate.ObjectNotFoundException")) : class$org$hibernate$ObjectNotFoundException).isInstance(exception);
                }
            };
        }
        this.entityNotFoundDelegate = entityNotFoundDelegate;
        this.fetchProfiles = new HashMap();
        itr = cfg.iterateFetchProfiles();
        while (itr.hasNext()) {
            org.hibernate.mapping.FetchProfile mappingProfile = (org.hibernate.mapping.FetchProfile)itr.next();
            FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
            Iterator fetches = mappingProfile.getFetches().iterator();
            while (fetches.hasNext()) {
                FetchProfile.Fetch mappingFetch = (FetchProfile.Fetch)fetches.next();
                entityName = this.getImportedClassName(mappingFetch.getEntity());
                EntityPersister owner = entityName == null ? null : this.entityPersisters.get(entityName);
                if (owner == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
                }
                Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                if (associationType == null || !associationType.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an invalid association");
                }
                Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                ((Loadable)owner).registerAffectingFetchProfile(fetchProfile.getName());
            }
            this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        this.observer.sessionFactoryCreated(this);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    private void registerEntityNameResolvers(EntityPersister persister) {
        if (persister.getEntityMetamodel() == null || persister.getEntityMetamodel().getTuplizerMapping() == null) {
            return;
        }
        Iterator itr = persister.getEntityMetamodel().getTuplizerMapping().iterateTuplizers();
        while (itr.hasNext()) {
            EntityTuplizer tuplizer = (EntityTuplizer)itr.next();
            this.registerEntityNameResolvers(tuplizer);
        }
    }

    private void registerEntityNameResolvers(EntityTuplizer tuplizer) {
        EntityNameResolver[] resolvers = tuplizer.getEntityNameResolvers();
        if (resolvers == null) {
            return;
        }
        for (int i = 0; i < resolvers.length; ++i) {
            this.registerEntityNameResolver(resolvers[i], tuplizer.getEntityMode());
        }
    }

    public void registerEntityNameResolver(EntityNameResolver resolver, EntityMode entityMode) {
        LinkedHashSet<EntityNameResolver> resolversForMode = (LinkedHashSet<EntityNameResolver>)this.entityNameResolvers.get(entityMode);
        if (resolversForMode == null) {
            resolversForMode = new LinkedHashSet<EntityNameResolver>();
            this.entityNameResolvers.put(entityMode, resolversForMode);
        }
        resolversForMode.add(resolver);
    }

    public Iterator iterateEntityNameResolvers(EntityMode entityMode) {
        Set actualEntityNameResolvers = (Set)this.entityNameResolvers.get(entityMode);
        return actualEntityNameResolvers == null ? EmptyIterator.INSTANCE : actualEntityNameResolvers.iterator();
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map checkNamedQueries() throws HibernateException {
        NamedQueryDefinition qd;
        String queryName;
        Map.Entry entry;
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        log.debug("Checking " + this.namedQueries.size() + " named HQL queries");
        Iterator itr = this.namedQueries.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            queryName = (String)entry.getKey();
            qd = (NamedQueryDefinition)entry.getValue();
            try {
                log.debug("Checking named query: " + queryName);
                this.queryPlanCache.getHQLQueryPlan(qd.getQueryString(), false, CollectionHelper.EMPTY_MAP);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        log.debug("Checking " + this.namedSqlQueries.size() + " named SQL queries");
        itr = this.namedSqlQueries.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            queryName = (String)entry.getKey();
            qd = (NamedSQLQueryDefinition)entry.getValue();
            try {
                NativeSQLQuerySpecification spec;
                log.debug("Checking named SQL query: " + queryName);
                if (((NamedSQLQueryDefinition)qd).getResultSetRef() != null) {
                    ResultSetMappingDefinition definition = (ResultSetMappingDefinition)this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)qd).getResultSetRef());
                    if (definition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)qd).getResultSetRef());
                    }
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), definition.getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                } else {
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), ((NamedSQLQueryDefinition)qd).getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(spec);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        return errors;
    }

    public StatelessSession openStatelessSession() {
        return new StatelessSessionImpl(null, this);
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return new StatelessSessionImpl(connection, this);
    }

    private SessionImpl openSession(Connection connection, boolean autoClose, long timestamp, Interceptor sessionLocalInterceptor) {
        return new SessionImpl(connection, this, autoClose, timestamp, sessionLocalInterceptor == null ? this.interceptor : sessionLocalInterceptor, this.settings.getDefaultEntityMode(), this.settings.isFlushBeforeCompletionEnabled(), this.settings.isAutoCloseSessionEnabled(), this.settings.getConnectionReleaseMode());
    }

    public Session openSession(Connection connection, Interceptor sessionLocalInterceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, sessionLocalInterceptor);
    }

    public Session openSession(Interceptor sessionLocalInterceptor) throws HibernateException {
        long timestamp = this.settings.getRegionFactory().nextTimestamp();
        return this.openSession(null, true, timestamp, sessionLocalInterceptor);
    }

    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    public Session openTemporarySession() throws HibernateException {
        return new SessionImpl(null, this, true, this.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), false, false, ConnectionReleaseMode.AFTER_STATEMENT);
    }

    public Session openSession(Connection connection, boolean flushBeforeCompletionEnabled, boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode) throws HibernateException {
        return new SessionImpl(connection, this, true, this.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), flushBeforeCompletionEnabled, autoCloseSessionEnabled, connectionReleaseMode);
    }

    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        EntityPersister result = (EntityPersister)this.entityPersisters.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("Unknown collection role: " + role);
        }
        return result;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Dialect getDialect() {
        return this.settings.getDialect();
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public TransactionFactory getTransactionFactory() {
        return this.settings.getTransactionFactory();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.settings.getSQLExceptionConverter();
    }

    public Set getCollectionRolesByEntityParticipant(String entityName) {
        return (Set)this.collectionRolesByEntityParticipant.get(entityName);
    }

    public Reference getReference() throws NamingException {
        log.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace("Resolving serialized SessionFactory");
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug("resolved SessionFactory by name");
        } else {
            log.debug("resolved SessionFactory by uid");
        }
        return result;
    }

    public NamedQueryDefinition getNamedQuery(String queryName) {
        return (NamedQueryDefinition)this.namedQueries.get(queryName);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return (NamedSQLQueryDefinition)this.namedSqlQueries.get(queryName);
    }

    public ResultSetMappingDefinition getResultSetMapping(String resultSetName) {
        return (ResultSetMappingDefinition)this.sqlResultSetMappings.get(resultSetName);
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierType();
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierPropertyName();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.trace("deserializing");
        in.defaultReadObject();
        log.debug("deserialized: " + this.uuid);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        log.debug("serializing: " + this.uuid);
        out.defaultWriteObject();
        log.trace("serialized");
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(roleName);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return (ClassMetadata)this.classMetadata.get(entityName);
    }

    public String[] getImplementors(String className) throws MappingException {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return new String[]{className};
        }
        ArrayList<String> results = new ArrayList<String>();
        Iterator iter = this.entityPersisters.values().iterator();
        while (iter.hasNext()) {
            boolean assignableSuperclass;
            EntityPersister testPersister = (EntityPersister)iter.next();
            if (!(testPersister instanceof Queryable)) continue;
            Queryable testQueryable = (Queryable)testPersister;
            String testClassName = testQueryable.getEntityName();
            boolean isMappedClass = className.equals(testClassName);
            if (testQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(testClassName);
                continue;
            }
            Class mappedClass = testQueryable.getMappedClass(EntityMode.POJO);
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (testQueryable.isInherited()) {
                Class mappedSuperclass = this.getEntityPersister(testQueryable.getMappedSuperclass()).getMappedClass(EntityMode.POJO);
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(testClassName);
        }
        return results.toArray(new String[results.size()]);
    }

    public String getImportedClassName(String className) {
        String result = (String)this.imports.get(className);
        if (result == null) {
            try {
                ReflectHelper.classForName(className);
                return className;
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return result;
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getEntityPersister(className).getPropertyType(propertyName);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.settings.getConnectionProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HibernateException {
        Object p;
        if (this.isClosed) {
            log.trace("already closed");
            return;
        }
        log.info("closing");
        this.isClosed = true;
        Iterator iter = this.entityPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (EntityPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCacheAccessStrategy().getRegion().destroy();
        }
        iter = this.collectionPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (CollectionPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCacheAccessStrategy().getRegion().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            iter = this.queryCaches.values().iterator();
            while (iter.hasNext()) {
                QueryCache cache = (QueryCache)iter.next();
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.settings.getRegionFactory().stop();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        try {
            this.settings.getConnectionProvider().close();
        }
        finally {
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
        }
        this.observer.sessionFactoryClosed(this);
        this.eventListeners.destroyListeners();
    }

    public Cache getCache() {
        return this.cacheAccess;
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getCache().evictEntity(entityName, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        this.getCache().evictEntityRegion(entityName);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getCache().evictEntity(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getCache().evictEntityRegion(persistentClass);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getCache().evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getCache().evictCollectionRegion(roleName);
    }

    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    public void evictQueries(String regionName) throws HibernateException {
        this.getCache().evictQueryRegion(regionName);
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        if (regionName == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        Map map = this.allCacheRegions;
        synchronized (map) {
            QueryCache currentQueryCache = (QueryCache)this.queryCaches.get(regionName);
            if (currentQueryCache == null) {
                currentQueryCache = this.settings.getQueryCacheFactory().getQueryCache(regionName, this.updateTimestampsCache, this.settings, this.properties);
                this.queryCaches.put(regionName, currentQueryCache);
                this.allCacheRegions.put(currentQueryCache.getRegion().getName(), currentQueryCache.getRegion());
            }
            return currentQueryCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getSecondLevelCacheRegion(String regionName) {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return (Region)this.allCacheRegions.get(regionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllSecondLevelCacheRegions() {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return new HashMap(this.allCacheRegions);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return (StatisticsImplementor)((Object)this.statistics);
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = (FilterDefinition)this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    public BatcherFactory getBatcherFactory() {
        return this.settings.getBatcherFactory();
    }

    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return (IdentifierGenerator)this.identifierGenerators.get(rootEntityName);
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = this.properties.getProperty("hibernate.current_session_context_class");
        if (impl == null && this.transactionManager != null) {
            impl = "jta";
        }
        if (impl == null) {
            return null;
        }
        if ("jta".equals(impl)) {
            if (this.settings.getTransactionFactory().areCallbacksLocalToHibernateTransactions()) {
                log.warn("JTASessionContext being used with JDBCTransactionFactory; auto-flush will not operate correctly with getCurrentSession()");
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class implClass = ReflectHelper.classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            log.error("Unable to construct current session context [" + impl + "]", t);
            return null;
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    public FetchProfile getFetchProfile(String name) {
        return (FetchProfile)this.fetchProfiles.get(name);
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.uuid);
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object result;
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = null;
        if (isNamed) {
            name = ois.readUTF();
        }
        if ((result = SessionFactoryObjectFactory.getInstance(uuid)) == null) {
            log.trace("could not locate session factory by uuid [" + uuid + "] during session deserialization; trying name");
            if (isNamed) {
                result = SessionFactoryObjectFactory.getNamedInstance(name);
            }
            if (result == null) {
                throw new InvalidObjectException("could not resolve session factory during session deserialization [uuid=" + uuid + ", name=" + name + "]");
            }
        }
        return (SessionFactoryImpl)result;
    }

    private class CacheImpl
    implements Cache {
        private CacheImpl() {
        }

        public boolean containsEntity(Class entityClass, Serializable identifier) {
            return this.containsEntity(entityClass.getName(), identifier);
        }

        public boolean containsEntity(String entityName, Serializable identifier) {
            EntityPersister p = SessionFactoryImpl.this.getEntityPersister(entityName);
            return p.hasCache() && p.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(identifier, p));
        }

        public void evictEntity(Class entityClass, Serializable identifier) {
            this.evictEntity(entityClass.getName(), identifier);
        }

        public void evictEntity(String entityName, Serializable identifier) {
            EntityPersister p = SessionFactoryImpl.this.getEntityPersister(entityName);
            if (p.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + MessageHelper.infoString(p, identifier, (SessionFactoryImplementor)SessionFactoryImpl.this));
                }
                p.getCacheAccessStrategy().evict(this.buildCacheKey(identifier, p));
            }
        }

        private CacheKey buildCacheKey(Serializable identifier, EntityPersister p) {
            return new CacheKey(identifier, p.getIdentifierType(), p.getRootEntityName(), EntityMode.POJO, SessionFactoryImpl.this);
        }

        public void evictEntityRegion(Class entityClass) {
            this.evictEntityRegion(entityClass.getName());
        }

        public void evictEntityRegion(String entityName) {
            EntityPersister p = SessionFactoryImpl.this.getEntityPersister(entityName);
            if (p.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + p.getEntityName());
                }
                p.getCacheAccessStrategy().evictAll();
            }
        }

        public void evictEntityRegions() {
            Iterator entityNames = SessionFactoryImpl.this.entityPersisters.keySet().iterator();
            while (entityNames.hasNext()) {
                this.evictEntityRegion((String)entityNames.next());
            }
        }

        public boolean containsCollection(String role, Serializable ownerIdentifier) {
            CollectionPersister p = SessionFactoryImpl.this.getCollectionPersister(role);
            return p.hasCache() && p.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(ownerIdentifier, p));
        }

        public void evictCollection(String role, Serializable ownerIdentifier) {
            CollectionPersister p = SessionFactoryImpl.this.getCollectionPersister(role);
            if (p.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + MessageHelper.collectionInfoString(p, ownerIdentifier, (SessionFactoryImplementor)SessionFactoryImpl.this));
                }
                CacheKey cacheKey = this.buildCacheKey(ownerIdentifier, p);
                p.getCacheAccessStrategy().evict(cacheKey);
            }
        }

        private CacheKey buildCacheKey(Serializable ownerIdentifier, CollectionPersister p) {
            return new CacheKey(ownerIdentifier, p.getKeyType(), p.getRole(), EntityMode.POJO, SessionFactoryImpl.this);
        }

        public void evictCollectionRegion(String role) {
            CollectionPersister p = SessionFactoryImpl.this.getCollectionPersister(role);
            if (p.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + p.getRole());
                }
                p.getCacheAccessStrategy().evictAll();
            }
        }

        public void evictCollectionRegions() {
            Iterator collectionRoles = SessionFactoryImpl.this.collectionPersisters.keySet().iterator();
            while (collectionRoles.hasNext()) {
                this.evictCollectionRegion((String)collectionRoles.next());
            }
        }

        public boolean containsQuery(String regionName) {
            return SessionFactoryImpl.this.queryCaches.get(regionName) != null;
        }

        public void evictDefaultQueryRegion() {
            if (SessionFactoryImpl.this.settings.isQueryCacheEnabled()) {
                SessionFactoryImpl.this.queryCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evictQueryRegion(String regionName) {
            if (regionName == null) {
                throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
            }
            Map map = SessionFactoryImpl.this.allCacheRegions;
            synchronized (map) {
                QueryCache namedQueryCache;
                if (SessionFactoryImpl.this.settings.isQueryCacheEnabled() && (namedQueryCache = (QueryCache)SessionFactoryImpl.this.queryCaches.get(regionName)) != null) {
                    namedQueryCache.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evictQueryRegions() {
            Map map = SessionFactoryImpl.this.allCacheRegions;
            synchronized (map) {
                Iterator regions = SessionFactoryImpl.this.queryCaches.values().iterator();
                while (regions.hasNext()) {
                    QueryCache cache = (QueryCache)regions.next();
                    cache.clear();
                }
            }
        }
    }
}

