/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.NonFlushedChanges;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.engine.Status;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.query.FilterQueryPlan;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EventSource;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEvent;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEvent;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.impl.AbstractSessionImpl;
import org.hibernate.impl.CollectionFilterImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.FilterImpl;
import org.hibernate.impl.NonFlushedChangesImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.jdbc.Work;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.SessionStatisticsImpl;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionImpl
extends AbstractSessionImpl
implements EventSource,
org.hibernate.classic.Session,
JDBCContext.Context,
LobCreationContext {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private transient EntityMode entityMode = EntityMode.POJO;
    private transient boolean autoClear;
    private transient long timestamp;
    private transient FlushMode flushMode = FlushMode.AUTO;
    private transient CacheMode cacheMode = CacheMode.NORMAL;
    private transient Interceptor interceptor;
    private transient int dontFlushFromFind = 0;
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext;
    private transient JDBCContext jdbcContext;
    private transient EventListeners listeners;
    private transient boolean flushBeforeCompletionEnabled;
    private transient boolean autoCloseSessionEnabled;
    private transient ConnectionReleaseMode connectionReleaseMode;
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private transient Session rootSession;
    private transient Map childSessionsByEntityMode;
    private transient EntityNameResolver entityNameResolver = new CoordinatingEntityNameResolver();

    private SessionImpl(SessionImpl parent, EntityMode entityMode) {
        super(parent.factory);
        this.rootSession = parent;
        this.timestamp = parent.timestamp;
        this.jdbcContext = parent.jdbcContext;
        this.interceptor = parent.interceptor;
        this.listeners = parent.listeners;
        this.actionQueue = new ActionQueue(this);
        this.entityMode = entityMode;
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.flushBeforeCompletionEnabled = false;
        this.autoCloseSessionEnabled = false;
        this.connectionReleaseMode = null;
        this.loadQueryInfluencers = new LoadQueryInfluencers(this.factory);
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().openSession();
        }
        log.debug("opened session [" + entityMode + "]");
    }

    SessionImpl(Connection connection, SessionFactoryImpl factory, boolean autoclose, long timestamp, Interceptor interceptor, EntityMode entityMode, boolean flushBeforeCompletionEnabled, boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode) {
        super(factory);
        this.rootSession = null;
        this.timestamp = timestamp;
        this.entityMode = entityMode;
        this.interceptor = interceptor;
        this.listeners = factory.getEventListeners();
        this.actionQueue = new ActionQueue(this);
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.flushBeforeCompletionEnabled = flushBeforeCompletionEnabled;
        this.autoCloseSessionEnabled = autoCloseSessionEnabled;
        this.connectionReleaseMode = connectionReleaseMode;
        this.jdbcContext = new JDBCContext(this, connection, interceptor);
        this.loadQueryInfluencers = new LoadQueryInfluencers(factory);
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().openSession();
        }
        if (log.isDebugEnabled()) {
            log.debug("opened session at timestamp: " + timestamp);
        }
    }

    public Session getSession(EntityMode entityMode) {
        if (this.entityMode == entityMode) {
            return this;
        }
        if (this.rootSession != null) {
            return this.rootSession.getSession(entityMode);
        }
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SessionImpl rtn = null;
        if (this.childSessionsByEntityMode == null) {
            this.childSessionsByEntityMode = new HashMap();
        } else {
            rtn = (SessionImpl)this.childSessionsByEntityMode.get(entityMode);
        }
        if (rtn == null) {
            rtn = new SessionImpl(this, entityMode);
            this.childSessionsByEntityMode.put(entityMode, rtn);
        }
        return rtn;
    }

    public void clear() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.clear();
        this.actionQueue.clear();
    }

    public Batcher getBatcher() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.jdbcContext.getConnectionManager().getBatcher();
    }

    public long getTimestamp() {
        this.checkTransactionSynchStatus();
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() throws HibernateException {
        log.trace("closing session");
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().closeSession();
        }
        try {
            Connection connection;
            try {
                if (this.childSessionsByEntityMode != null) {
                    Iterator childSessions = this.childSessionsByEntityMode.values().iterator();
                    while (childSessions.hasNext()) {
                        SessionImpl child = (SessionImpl)childSessions.next();
                        child.close();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.rootSession == null) {
                connection = this.jdbcContext.getConnectionManager().close();
                return connection;
            }
            connection = null;
            return connection;
        }
        finally {
            this.setClosed();
            this.cleanup();
        }
    }

    public ConnectionReleaseMode getConnectionReleaseMode() {
        this.checkTransactionSynchStatus();
        return this.connectionReleaseMode;
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    public boolean isOpen() {
        this.checkTransactionSynchStatus();
        return !this.isClosed();
    }

    public boolean isFlushModeNever() {
        return FlushMode.isManualFlushMode(this.getFlushMode());
    }

    public boolean isFlushBeforeCompletionEnabled() {
        return this.flushBeforeCompletionEnabled;
    }

    public void managedFlush() {
        if (this.isClosed()) {
            log.trace("skipping auto-flush due to session closed");
            return;
        }
        log.trace("automatically flushing session");
        this.flush();
        if (this.childSessionsByEntityMode != null) {
            Iterator iter = this.childSessionsByEntityMode.values().iterator();
            while (iter.hasNext()) {
                ((Session)iter.next()).flush();
            }
        }
    }

    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        NonFlushedChangesImpl nonFlushedChanges = new NonFlushedChangesImpl(this);
        if (this.childSessionsByEntityMode != null) {
            Iterator it = this.childSessionsByEntityMode.values().iterator();
            while (it.hasNext()) {
                nonFlushedChanges.extractFromSession((EventSource)it.next());
            }
        }
        return nonFlushedChanges;
    }

    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.replacePersistenceContext(((NonFlushedChangesImpl)nonFlushedChanges).getPersistenceContext(this.entityMode));
        this.replaceActionQueue(((NonFlushedChangesImpl)nonFlushedChanges).getActionQueue(this.entityMode));
        if (this.childSessionsByEntityMode != null) {
            Iterator it = this.childSessionsByEntityMode.values().iterator();
            while (it.hasNext()) {
                ((SessionImpl)it.next()).applyNonFlushedChanges(nonFlushedChanges);
            }
        }
    }

    private void replacePersistenceContext(StatefulPersistenceContext persistenceContextNew) {
        if (persistenceContextNew.getSession() != null) {
            throw new IllegalStateException("new persistence context is already connected to a session ");
        }
        this.persistenceContext.clear();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializePersistenceContext(persistenceContextNew)));
            this.persistenceContext = StatefulPersistenceContext.deserialize(ois, this);
        }
        catch (IOException ex) {
            throw new SerializationException("could not deserialize the persistence context", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("could not deserialize the persistence context", ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static byte[] serializePersistenceContext(StatefulPersistenceContext pc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            pc.serialize(oos);
        }
        catch (IOException ex) {
            throw new SerializationException("could not serialize persistence context", ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {}
            }
        }
        return baos.toByteArray();
    }

    private void replaceActionQueue(ActionQueue actionQueueNew) {
        if (this.actionQueue.hasAnyQueuedActions()) {
            throw new IllegalStateException("cannot replace an ActionQueue with queued actions ");
        }
        this.actionQueue.clear();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializeActionQueue(actionQueueNew)));
            this.actionQueue = ActionQueue.deserialize(ois, this);
        }
        catch (IOException ex) {
            throw new SerializationException("could not deserialize the action queue", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("could not deserialize the action queue", ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static byte[] serializeActionQueue(ActionQueue actionQueue) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            actionQueue.serialize(oos);
        }
        catch (IOException ex) {
            throw new SerializationException("could not serialize action queue", ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {}
            }
        }
        return baos.toByteArray();
    }

    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    public void managedClose() {
        log.trace("automatically closing session");
        this.close();
    }

    public Connection connection() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcContext.borrowConnection();
    }

    public boolean isConnected() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.jdbcContext.getConnectionManager().isCurrentlyConnected();
    }

    public boolean isTransactionInProgress() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.jdbcContext.isTransactionInProgress();
    }

    public Connection disconnect() throws HibernateException {
        this.errorIfClosed();
        log.debug("disconnecting session");
        return this.jdbcContext.getConnectionManager().manualDisconnect();
    }

    public void reconnect() throws HibernateException {
        this.errorIfClosed();
        log.debug("reconnecting session");
        this.checkTransactionSynchStatus();
        this.jdbcContext.getConnectionManager().manualReconnect();
    }

    public void reconnect(Connection conn) throws HibernateException {
        this.errorIfClosed();
        log.debug("reconnecting session");
        this.checkTransactionSynchStatus();
        this.jdbcContext.getConnectionManager().manualReconnect(conn);
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace("before transaction completion");
        this.actionQueue.beforeTransactionCompletion();
        if (this.rootSession == null) {
            try {
                this.interceptor.beforeTransactionCompletion(tx);
            }
            catch (Throwable t) {
                log.error("exception in interceptor beforeTransactionCompletion()", t);
            }
        }
    }

    public void setAutoClear(boolean enabled) {
        this.errorIfClosed();
        this.autoClear = enabled;
    }

    public void afterOperation(boolean success) {
        if (!this.jdbcContext.isTransactionInProgress()) {
            this.jdbcContext.afterNontransactionalQuery(success);
        }
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace("after transaction completion");
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(success);
        if (this.rootSession == null && tx != null) {
            try {
                this.interceptor.afterTransactionCompletion(tx);
            }
            catch (Throwable t) {
                log.error("exception in interceptor afterTransactionCompletion()", t);
            }
        }
        if (this.autoClear) {
            this.clear();
        }
    }

    private void cleanup() {
        this.persistenceContext.clear();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.persistenceContext.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", e.getId(), e.getPersister().getEntityName());
        }
        return e.getLockMode();
    }

    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.errorIfClosed();
        Object result = this.persistenceContext.getEntity(key);
        if (result == null) {
            Object newObject = this.interceptor.getEntity(key.getEntityName(), key.getIdentifier());
            if (newObject != null) {
                this.lock(newObject, LockMode.NONE);
            }
            return newObject;
        }
        return result;
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    public void saveOrUpdate(String entityName, Object obj) throws HibernateException {
        this.fireSaveOrUpdate(new SaveOrUpdateEvent(entityName, obj, this));
    }

    private void fireSaveOrUpdate(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SaveOrUpdateEventListener[] saveOrUpdateEventListener = this.listeners.getSaveOrUpdateEventListeners();
        for (int i = 0; i < saveOrUpdateEventListener.length; ++i) {
            saveOrUpdateEventListener[i].onSaveOrUpdate(event);
        }
    }

    public void save(Object obj, Serializable id) throws HibernateException {
        this.save(null, obj, id);
    }

    public Serializable save(Object obj) throws HibernateException {
        return this.save(null, obj);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.fireSave(new SaveOrUpdateEvent(entityName, object, this));
    }

    public void save(String entityName, Object object, Serializable id) throws HibernateException {
        this.fireSave(new SaveOrUpdateEvent(entityName, object, id, this));
    }

    private Serializable fireSave(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SaveOrUpdateEventListener[] saveEventListener = this.listeners.getSaveEventListeners();
        for (int i = 0; i < saveEventListener.length; ++i) {
            saveEventListener[i].onSaveOrUpdate(event);
        }
        return event.getResultId();
    }

    public void update(Object obj) throws HibernateException {
        this.update(null, obj);
    }

    public void update(Object obj, Serializable id) throws HibernateException {
        this.update(null, obj, id);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(entityName, object, this));
    }

    public void update(String entityName, Object object, Serializable id) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(entityName, object, id, this));
    }

    private void fireUpdate(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SaveOrUpdateEventListener[] updateEventListener = this.listeners.getUpdateEventListeners();
        for (int i = 0; i < updateEventListener.length; ++i) {
            updateEventListener[i].onSaveOrUpdate(event);
        }
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(entityName, object, lockMode, (EventSource)this));
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return new LockRequestImpl(lockOptions);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(object, lockMode, (EventSource)this));
    }

    private void fireLock(String entityName, Object object, LockOptions options) {
        this.fireLock(new LockEvent(entityName, object, options, (EventSource)this));
    }

    private void fireLock(Object object, LockOptions options) {
        this.fireLock(new LockEvent(object, options, (EventSource)this));
    }

    private void fireLock(LockEvent lockEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LockEventListener[] lockEventListener = this.listeners.getLockEventListeners();
        for (int i = 0; i < lockEventListener.length; ++i) {
            lockEventListener[i].onLock(lockEvent);
        }
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.firePersist(new PersistEvent(entityName, object, this));
    }

    public void persist(Object object) throws HibernateException {
        this.persist(null, object);
    }

    public void persist(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.firePersist(copiedAlready, new PersistEvent(entityName, object, this));
    }

    private void firePersist(Map copiedAlready, PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] persistEventListener = this.listeners.getPersistEventListeners();
        for (int i = 0; i < persistEventListener.length; ++i) {
            persistEventListener[i].onPersist(event, copiedAlready);
        }
    }

    private void firePersist(PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] createEventListener = this.listeners.getPersistEventListeners();
        for (int i = 0; i < createEventListener.length; ++i) {
            createEventListener[i].onPersist(event);
        }
    }

    public void persistOnFlush(String entityName, Object object) throws HibernateException {
        this.firePersistOnFlush(new PersistEvent(entityName, object, this));
    }

    public void persistOnFlush(Object object) throws HibernateException {
        this.persist(null, object);
    }

    public void persistOnFlush(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.firePersistOnFlush(copiedAlready, new PersistEvent(entityName, object, this));
    }

    private void firePersistOnFlush(Map copiedAlready, PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] persistEventListener = this.listeners.getPersistOnFlushEventListeners();
        for (int i = 0; i < persistEventListener.length; ++i) {
            persistEventListener[i].onPersist(event, copiedAlready);
        }
    }

    private void firePersistOnFlush(PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] createEventListener = this.listeners.getPersistOnFlushEventListeners();
        for (int i = 0; i < createEventListener.length; ++i) {
            createEventListener[i].onPersist(event);
        }
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.fireMerge(new MergeEvent(entityName, object, this));
    }

    public Object merge(Object object) throws HibernateException {
        return this.merge(null, object);
    }

    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.fireMerge(copiedAlready, new MergeEvent(entityName, object, this));
    }

    private Object fireMerge(MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] mergeEventListener = this.listeners.getMergeEventListeners();
        for (int i = 0; i < mergeEventListener.length; ++i) {
            mergeEventListener[i].onMerge(event);
        }
        return event.getResult();
    }

    private void fireMerge(Map copiedAlready, MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] mergeEventListener = this.listeners.getMergeEventListeners();
        for (int i = 0; i < mergeEventListener.length; ++i) {
            mergeEventListener[i].onMerge(event, copiedAlready);
        }
    }

    public Object saveOrUpdateCopy(String entityName, Object object) throws HibernateException {
        return this.fireSaveOrUpdateCopy(new MergeEvent(entityName, object, this));
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        return this.saveOrUpdateCopy(null, object);
    }

    public Object saveOrUpdateCopy(String entityName, Object object, Serializable id) throws HibernateException {
        return this.fireSaveOrUpdateCopy(new MergeEvent(entityName, object, id, this));
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        return this.saveOrUpdateCopy(null, object, id);
    }

    public void saveOrUpdateCopy(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.fireSaveOrUpdateCopy(copiedAlready, new MergeEvent(entityName, object, this));
    }

    private void fireSaveOrUpdateCopy(Map copiedAlready, MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] saveOrUpdateCopyEventListener = this.listeners.getSaveOrUpdateCopyEventListeners();
        for (int i = 0; i < saveOrUpdateCopyEventListener.length; ++i) {
            saveOrUpdateCopyEventListener[i].onMerge(event, copiedAlready);
        }
    }

    private Object fireSaveOrUpdateCopy(MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] saveOrUpdateCopyEventListener = this.listeners.getSaveOrUpdateCopyEventListeners();
        for (int i = 0; i < saveOrUpdateCopyEventListener.length; ++i) {
            saveOrUpdateCopyEventListener[i].onMerge(event);
        }
        return event.getResult();
    }

    public void delete(Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(object, this));
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(entityName, object, this));
    }

    public void delete(String entityName, Object object, boolean isCascadeDeleteEnabled, Set transientEntities) throws HibernateException {
        this.fireDelete(new DeleteEvent(entityName, object, isCascadeDeleteEnabled, this), transientEntities);
    }

    private void fireDelete(DeleteEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        DeleteEventListener[] deleteEventListener = this.listeners.getDeleteEventListeners();
        for (int i = 0; i < deleteEventListener.length; ++i) {
            deleteEventListener[i].onDelete(event);
        }
    }

    private void fireDelete(DeleteEvent event, Set transientEntities) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        DeleteEventListener[] deleteEventListener = this.listeners.getDeleteEventListeners();
        for (int i = 0; i < deleteEventListener.length; ++i) {
            deleteEventListener[i].onDelete(event, transientEntities);
        }
    }

    public void load(Object object, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, object, this);
        this.fireLoad(event, LoadEventListener.RELOAD);
    }

    public Object load(Class entityClass, Serializable id) throws HibernateException {
        return this.load(entityClass.getName(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, false, (EventSource)this);
        boolean success = false;
        try {
            this.fireLoad(event, LoadEventListener.LOAD);
            if (event.getResult() == null) {
                this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
            }
            success = true;
            Object object = event.getResult();
            return object;
        }
        finally {
            this.afterOperation(success);
        }
    }

    public Object get(Class entityClass, Serializable id) throws HibernateException {
        return this.get(entityClass.getName(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, false, (EventSource)this);
        boolean success = false;
        try {
            this.fireLoad(event, LoadEventListener.GET);
            success = true;
            Object object = event.getResult();
            return object;
        }
        finally {
            this.afterOperation(success);
        }
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        if (log.isDebugEnabled()) {
            EntityPersister persister = this.getFactory().getEntityPersister(entityName);
            log.debug("initializing proxy: " + MessageHelper.infoString(persister, id, this.getFactory()));
        }
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this);
        this.fireLoad(event, LoadEventListener.IMMEDIATE_LOAD);
        return event.getResult();
    }

    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        LoadEventListener.LoadType type = nullable ? LoadEventListener.INTERNAL_LOAD_NULLABLE : (eager ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY);
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this);
        this.fireLoad(event, type);
        if (!nullable) {
            UnresolvableObjectException.throwIfNull(event.getResult(), id, entityName);
        }
        return event.getResult();
    }

    public Object load(Class entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.load(entityClass.getName(), id, lockMode);
    }

    public Object load(Class entityClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.load(entityClass.getName(), id, lockOptions);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockMode, (EventSource)this);
        this.fireLoad(event, LoadEventListener.LOAD);
        return event.getResult();
    }

    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockOptions, (EventSource)this);
        this.fireLoad(event, LoadEventListener.LOAD);
        return event.getResult();
    }

    public Object get(Class entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.get(entityClass.getName(), id, lockMode);
    }

    public Object get(Class entityClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.get(entityClass.getName(), id, lockOptions);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockMode, (EventSource)this);
        this.fireLoad(event, LoadEventListener.GET);
        return event.getResult();
    }

    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockOptions, (EventSource)this);
        this.fireLoad(event, LoadEventListener.GET);
        return event.getResult();
    }

    private void fireLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LoadEventListener[] loadEventListener = this.listeners.getLoadEventListeners();
        for (int i = 0; i < loadEventListener.length; ++i) {
            loadEventListener[i].onLoad(event, loadType);
        }
    }

    public void refresh(Object object) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, this));
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockMode, (EventSource)this));
    }

    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockOptions, (EventSource)this));
    }

    public void refresh(Object object, Map refreshedAlready) throws HibernateException {
        this.fireRefresh(refreshedAlready, new RefreshEvent(object, this));
    }

    private void fireRefresh(RefreshEvent refreshEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        RefreshEventListener[] refreshEventListener = this.listeners.getRefreshEventListeners();
        for (int i = 0; i < refreshEventListener.length; ++i) {
            refreshEventListener[i].onRefresh(refreshEvent);
        }
    }

    private void fireRefresh(Map refreshedAlready, RefreshEvent refreshEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        RefreshEventListener[] refreshEventListener = this.listeners.getRefreshEventListeners();
        for (int i = 0; i < refreshEventListener.length; ++i) {
            refreshEventListener[i].onRefresh(refreshEvent, refreshedAlready);
        }
    }

    public void replicate(Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(obj, replicationMode, this));
    }

    public void replicate(String entityName, Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(entityName, obj, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        ReplicateEventListener[] replicateEventListener = this.listeners.getReplicateEventListeners();
        for (int i = 0; i < replicateEventListener.length; ++i) {
            replicateEventListener[i].onReplicate(event);
        }
    }

    public void evict(Object object) throws HibernateException {
        this.fireEvict(new EvictEvent(object, this));
    }

    private void fireEvict(EvictEvent evictEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        EvictEventListener[] evictEventListener = this.listeners.getEvictEventListeners();
        for (int i = 0; i < evictEventListener.length; ++i) {
            evictEventListener[i].onEvict(evictEvent);
        }
    }

    protected boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        this.errorIfClosed();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, this);
        AutoFlushEventListener[] autoFlushEventListener = this.listeners.getAutoFlushEventListeners();
        for (int i = 0; i < autoFlushEventListener.length; ++i) {
            autoFlushEventListener[i].onAutoFlush(event);
        }
        return event.isFlushRequired();
    }

    public boolean isDirty() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        log.debug("checking session dirtiness");
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            log.debug("session dirty (scheduled updates and insertions)");
            return true;
        }
        DirtyCheckEvent event = new DirtyCheckEvent(this);
        DirtyCheckEventListener[] dirtyCheckEventListener = this.listeners.getDirtyCheckEventListeners();
        for (int i = 0; i < dirtyCheckEventListener.length; ++i) {
            dirtyCheckEventListener[i].onDirtyCheck(event);
        }
        return event.isDirty();
    }

    public void flush() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        FlushEventListener[] flushEventListener = this.listeners.getFlushEventListeners();
        for (int i = 0; i < flushEventListener.length; ++i) {
            flushEventListener[i].onFlush(new FlushEvent(this));
        }
    }

    public void forceFlush(EntityEntry entityEntry) throws HibernateException {
        this.errorIfClosed();
        if (log.isDebugEnabled()) {
            log.debug("flushing to force deletion of re-saved object: " + MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), this.getFactory()));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        this.flush();
    }

    public List find(String query) throws HibernateException {
        return this.list(query, new QueryParameters());
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        return this.list(query, new QueryParameters(type, value));
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        return this.list(query, new QueryParameters(types, values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        List results = CollectionHelper.EMPTY_LIST;
        boolean success = false;
        ++this.dontFlushFromFind;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        NativeSQLQueryPlan plan = this.getNativeSQLQueryPlan(nativeQuerySpecification);
        this.autoFlushIfRequired(plan.getCustomQuery().getQuerySpaces());
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        return result;
    }

    public Iterator iterate(String query) throws HibernateException {
        return this.iterate(query, new QueryParameters());
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return this.iterate(query, new QueryParameters(type, value));
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return this.iterate(query, new QueryParameters(types, values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, true);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            Iterator iterator = plan.performIterate(queryParameters, this);
            return iterator;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = plan.performScroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    public int delete(String query) throws HibernateException {
        return this.delete(query, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        return this.delete(query, new Object[]{value}, new Type[]{type});
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (query == null) {
            throw new IllegalArgumentException("attempt to doAfterTransactionCompletion delete-by-query with null query");
        }
        if (log.isTraceEnabled()) {
            log.trace("delete: " + query);
            if (values.length != 0) {
                log.trace("parameters: " + StringHelper.toString(values));
            }
        }
        List list = this.find(query, values, types);
        int deletionCount = list.size();
        for (int i = 0; i < deletionCount; ++i) {
            this.delete(list.get(i));
        }
        return deletionCount;
    }

    public Query createFilter(Object collection, String queryString) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        CollectionFilterImpl filter = new CollectionFilterImpl(queryString, collection, (SessionImplementor)this, this.getFilterQueryPlan(collection, queryString, null, false).getParameterMetadata());
        filter.setComment(queryString);
        return filter;
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.getNamedQuery(queryName);
    }

    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.instantiate(this.factory.getEntityPersister(entityName), id);
    }

    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Object result = this.interceptor.instantiate(persister.getEntityName(), this.entityMode, id);
        if (result == null) {
            result = persister.instantiate(id, this);
        }
        return result;
    }

    public EntityMode getEntityMode() {
        this.checkTransactionSynchStatus();
        return this.entityMode;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("setting flush mode to: " + flushMode);
        }
        this.flushMode = flushMode;
    }

    public FlushMode getFlushMode() {
        this.checkTransactionSynchStatus();
        return this.flushMode;
    }

    public CacheMode getCacheMode() {
        this.checkTransactionSynchStatus();
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("setting cache mode to: " + cacheMode);
        }
        this.cacheMode = cacheMode;
    }

    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcContext.getTransaction();
    }

    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        if (this.rootSession != null) {
            log.warn("Transaction started on non-root session");
        }
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    public void afterTransactionBegin(Transaction tx) {
        this.errorIfClosed();
        this.interceptor.afterTransactionBegin(tx);
    }

    public EntityPersister getEntityPersister(String entityName, Object object) {
        this.errorIfClosed();
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        try {
            return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory(), this.entityMode);
        }
        catch (HibernateException e) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException e2) {
                throw e;
            }
        }
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.getId();
    }

    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        if (object instanceof HibernateProxy) {
            return this.getProxyIdentifier(object);
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        return entry != null ? entry.getId() : null;
    }

    private Serializable getProxyIdentifier(Object proxy) {
        return ((HibernateProxy)proxy).getHibernateLazyInitializer().getIdentifier();
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        return this.listFilter(collection, filter, new QueryParameters(new Type[1], new Object[1]));
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        return this.listFilter(collection, filter, new QueryParameters(new Type[]{null, type}, new Object[]{null, value}));
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        Object[] vals = new Object[values.length + 1];
        Type[] typs = new Type[types.length + 1];
        System.arraycopy(values, 0, vals, 1, values.length);
        System.arraycopy(types, 0, typs, 1, types.length);
        return this.listFilter(collection, filter, new QueryParameters(typs, vals));
    }

    private FilterQueryPlan getFilterQueryPlan(Object collection, String filter, QueryParameters parameters, boolean shallow) throws HibernateException {
        if (collection == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        CollectionEntry entry = this.persistenceContext.getCollectionEntryOrNull(collection);
        CollectionPersister roleBeforeFlush = entry == null ? null : entry.getLoadedPersister();
        FilterQueryPlan plan = null;
        if (roleBeforeFlush == null) {
            CollectionPersister roleAfterFlush;
            this.flush();
            entry = this.persistenceContext.getCollectionEntryOrNull(collection);
            CollectionPersister collectionPersister = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
            if (roleAfterFlush == null) {
                throw new QueryException("The collection was unreferenced");
            }
            plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleAfterFlush.getRole(), shallow, this.getEnabledFilters());
        } else {
            plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleBeforeFlush.getRole(), shallow, this.getEnabledFilters());
            if (this.autoFlushIfRequired(plan.getQuerySpaces())) {
                CollectionPersister roleAfterFlush;
                entry = this.persistenceContext.getCollectionEntryOrNull(collection);
                CollectionPersister collectionPersister = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
                if (roleBeforeFlush != roleAfterFlush) {
                    if (roleAfterFlush == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleAfterFlush.getRole(), shallow, this.getEnabledFilters());
                }
            }
        }
        if (parameters != null) {
            parameters.getPositionalParameterValues()[0] = entry.getLoadedKey();
            parameters.getPositionalParameterTypes()[0] = entry.getLoadedPersister().getKeyType();
        }
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan plan = this.getFilterQueryPlan(collection, filter, queryParameters, false);
        List results = CollectionHelper.EMPTY_LIST;
        boolean success = false;
        ++this.dontFlushFromFind;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
        return results;
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan plan = this.getFilterQueryPlan(collection, filter, queryParameters, true);
        return plan.performIterate(queryParameters, this);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    public Criteria createCriteria(String entityName, String alias) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(entityName, alias, this);
    }

    public Criteria createCriteria(Class persistentClass) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    public Criteria createCriteria(String entityName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(entityName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String entityName = criteria.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteria, entityName, this.getLoadQueryInfluencers());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(CriteriaImpl criteria) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String[] implementors = this.factory.getImplementors(criteria.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteria, implementors[i], this.getLoadQueryInfluencers());
            spaces.addAll(loaders[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(spaces);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    public boolean contains(Object object) {
        EntityEntry entry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return li.getSession() == this;
            }
            object = li.getImplementation();
        }
        return (entry = this.persistenceContext.getEntry(object)) != null && entry.getStatus() != Status.DELETED && entry.getStatus() != Status.GONE;
    }

    public Query createQuery(String queryString) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createQuery(queryString);
    }

    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createSQLQuery(sql);
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new SQLQueryImpl(sql, new String[]{returnAlias}, new Class[]{returnClass}, this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new SQLQueryImpl(sql, returnAliases, returnClasses, this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("scroll SQL query: " + customQuery.getSQL());
        }
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("SQL query: " + customQuery.getSQL());
        }
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        boolean success = false;
        try {
            List results = loader.list(this, queryParameters);
            success = true;
            List list = results;
            return list;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
    }

    public SessionFactory getSessionFactory() {
        this.checkTransactionSynchStatus();
        return this.factory;
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        InitializeCollectionEventListener[] listener = this.listeners.getInitializeCollectionEventListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].onInitializeCollection(new InitializeCollectionEvent(collection, this));
        }
    }

    public String bestGuessEntityName(Object object) {
        EntityEntry entry;
        if (object instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (initializer.isUninitialized()) {
                return initializer.getEntityName();
            }
            object = initializer.getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return entry.getPersister().getEntityName();
    }

    public String getEntityName(Object object) {
        EntityEntry entry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entry.getPersister().getEntityName();
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    public String guessEntityName(Object object) throws HibernateException {
        this.errorIfClosed();
        return this.entityNameResolver.resolveEntityName(object);
    }

    public void cancelQuery() throws HibernateException {
        this.errorIfClosed();
        this.getBatcher().cancelLastQuery();
    }

    public Interceptor getInterceptor() {
        this.checkTransactionSynchStatus();
        return this.interceptor;
    }

    public int getDontFlushFromFind() {
        return this.dontFlushFromFind;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(500).append("SessionImpl(");
        if (!this.isClosed()) {
            buf.append(this.persistenceContext).append(";").append(this.actionQueue);
        } else {
            buf.append("<closed>");
        }
        return buf.append(')').toString();
    }

    public EventListeners getListeners() {
        return this.listeners;
    }

    public ActionQueue getActionQueue() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.actionQueue;
    }

    public PersistenceContext getPersistenceContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext;
    }

    public SessionStatistics getStatistics() {
        this.checkTransactionSynchStatus();
        return new SessionStatisticsImpl(this);
    }

    public boolean isEventSource() {
        this.checkTransactionSynchStatus();
        return true;
    }

    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.persistenceContext.setDefaultReadOnly(defaultReadOnly);
    }

    public boolean isReadOnly(Object entityOrProxy) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext.isReadOnly(entityOrProxy);
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.setReadOnly(entity, readOnly);
    }

    public void doWork(Work work) throws HibernateException {
        try {
            work.execute(this.jdbcContext.getConnectionManager().getConnection());
            this.jdbcContext.getConnectionManager().afterStatement();
        }
        catch (SQLException e) {
            throw JDBCExceptionHelper.convert(this.factory.getSettings().getSQLExceptionConverter(), e, "error executing work");
        }
    }

    public void afterScrollOperation() {
    }

    public JDBCContext getJDBCContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.jdbcContext;
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    public Filter getEnabledFilter(String filterName) {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilter(filterName);
    }

    public Filter enableFilter(String filterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.enableFilter(filterName);
    }

    public void disableFilter(String filterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.disableFilter(filterName);
    }

    public Object getFilterParameterValue(String filterParameterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterValue(filterParameterName);
    }

    public Type getFilterParameterType(String filterParameterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterType(filterParameterName);
    }

    public Map getEnabledFilters() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilters();
    }

    public String getFetchProfile() {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getInternalFetchProfile();
    }

    public void setFetchProfile(String fetchProfile) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.setInternalFetchProfile(fetchProfile);
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(name);
    }

    private void checkTransactionSynchStatus() {
        if (this.jdbcContext != null && !this.isClosed()) {
            this.jdbcContext.registerSynchronizationIfPossible();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        log.trace("deserializing session");
        ois.defaultReadObject();
        this.entityNameResolver = new CoordinatingEntityNameResolver();
        boolean isRootSession = ois.readBoolean();
        this.connectionReleaseMode = ConnectionReleaseMode.parse((String)ois.readObject());
        this.entityMode = EntityMode.parse((String)ois.readObject());
        this.autoClear = ois.readBoolean();
        this.flushMode = FlushMode.parse((String)ois.readObject());
        this.cacheMode = CacheMode.parse((String)ois.readObject());
        this.flushBeforeCompletionEnabled = ois.readBoolean();
        this.autoCloseSessionEnabled = ois.readBoolean();
        this.interceptor = (Interceptor)ois.readObject();
        this.factory = SessionFactoryImpl.deserialize(ois);
        this.listeners = this.factory.getEventListeners();
        if (isRootSession) {
            this.jdbcContext = JDBCContext.deserialize(ois, this, this.interceptor);
        }
        this.persistenceContext = StatefulPersistenceContext.deserialize(ois, this);
        this.actionQueue = ActionQueue.deserialize(ois, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)ois.readObject();
        this.childSessionsByEntityMode = (Map)ois.readObject();
        Iterator iter = this.loadQueryInfluencers.getEnabledFilters().values().iterator();
        while (iter.hasNext()) {
            ((FilterImpl)iter.next()).afterDeserialize(this.factory);
        }
        if (isRootSession && this.childSessionsByEntityMode != null) {
            iter = this.childSessionsByEntityMode.values().iterator();
            while (iter.hasNext()) {
                SessionImpl child = (SessionImpl)iter.next();
                child.rootSession = this;
                child.jdbcContext = this.jdbcContext;
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.jdbcContext.getConnectionManager().isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a session while connected");
        }
        log.trace("serializing session");
        oos.defaultWriteObject();
        oos.writeBoolean(this.rootSession == null);
        oos.writeObject(this.connectionReleaseMode.toString());
        oos.writeObject(this.entityMode.toString());
        oos.writeBoolean(this.autoClear);
        oos.writeObject(this.flushMode.toString());
        oos.writeObject(this.cacheMode.toString());
        oos.writeBoolean(this.flushBeforeCompletionEnabled);
        oos.writeBoolean(this.autoCloseSessionEnabled);
        oos.writeObject(this.interceptor);
        this.factory.serialize(oos);
        if (this.rootSession == null) {
            this.jdbcContext.serialize(oos);
        }
        this.persistenceContext.serialize(oos);
        this.actionQueue.serialize(oos);
        oos.writeObject(this.loadQueryInfluencers);
        oos.writeObject(this.childSessionsByEntityMode);
    }

    public Object execute(LobCreationContext.Callback callback) {
        Connection connection = this.jdbcContext.getConnectionManager().getConnection();
        try {
            Object object = callback.executeOnConnection(connection);
            return object;
        }
        catch (SQLException e) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "Error creating contextual LOB : " + e.getMessage());
        }
        finally {
            this.jdbcContext.getConnectionManager().afterStatement();
        }
    }

    private class LockRequestImpl
    implements Session.LockRequest {
        private final LockOptions lockOptions = new LockOptions();

        private LockRequestImpl(LockOptions lo) {
            LockOptions.copy(lo, this.lockOptions);
        }

        public LockMode getLockMode() {
            return this.lockOptions.getLockMode();
        }

        public Session.LockRequest setLockMode(LockMode lockMode) {
            this.lockOptions.setLockMode(lockMode);
            return this;
        }

        public int getTimeOut() {
            return this.lockOptions.getTimeOut();
        }

        public Session.LockRequest setTimeOut(int timeout) {
            this.lockOptions.setTimeOut(timeout);
            return this;
        }

        public boolean getScope() {
            return this.lockOptions.getScope();
        }

        public Session.LockRequest setScope(boolean scope) {
            this.lockOptions.setScope(scope);
            return this;
        }

        public void lock(String entityName, Object object) throws HibernateException {
            SessionImpl.this.fireLock(entityName, object, this.lockOptions);
        }

        public void lock(Object object) throws HibernateException {
            SessionImpl.this.fireLock(object, this.lockOptions);
        }
    }

    private class CoordinatingEntityNameResolver
    implements EntityNameResolver {
        private CoordinatingEntityNameResolver() {
        }

        public String resolveEntityName(Object entity) {
            EntityNameResolver resolver;
            String entityName = SessionImpl.this.interceptor.getEntityName(entity);
            if (entityName != null) {
                return entityName;
            }
            Iterator itr = SessionImpl.this.factory.iterateEntityNameResolvers(SessionImpl.this.entityMode);
            while (itr.hasNext() && (entityName = (resolver = (EntityNameResolver)itr.next()).resolveEntityName(entity)) == null) {
            }
            if (entityName != null) {
                return entityName;
            }
            return entity.getClass().getName();
        }
    }
}

