/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.Region;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.ConcurrentCollectionStatisticsImpl;
import org.hibernate.stat.ConcurrentEntityStatisticsImpl;
import org.hibernate.stat.ConcurrentQueryStatisticsImpl;
import org.hibernate.stat.ConcurrentSecondLevelCacheStatisticsImpl;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.util.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentStatisticsImpl
implements Statistics,
StatisticsImplementor {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentStatisticsImpl.class);
    private SessionFactoryImplementor sessionFactory;
    private volatile boolean isStatisticsEnabled;
    private volatile long startTime;
    private AtomicLong sessionOpenCount = new AtomicLong();
    private AtomicLong sessionCloseCount = new AtomicLong();
    private AtomicLong flushCount = new AtomicLong();
    private AtomicLong connectCount = new AtomicLong();
    private AtomicLong prepareStatementCount = new AtomicLong();
    private AtomicLong closeStatementCount = new AtomicLong();
    private AtomicLong entityLoadCount = new AtomicLong();
    private AtomicLong entityUpdateCount = new AtomicLong();
    private AtomicLong entityInsertCount = new AtomicLong();
    private AtomicLong entityDeleteCount = new AtomicLong();
    private AtomicLong entityFetchCount = new AtomicLong();
    private AtomicLong collectionLoadCount = new AtomicLong();
    private AtomicLong collectionUpdateCount = new AtomicLong();
    private AtomicLong collectionRemoveCount = new AtomicLong();
    private AtomicLong collectionRecreateCount = new AtomicLong();
    private AtomicLong collectionFetchCount = new AtomicLong();
    private AtomicLong secondLevelCacheHitCount = new AtomicLong();
    private AtomicLong secondLevelCacheMissCount = new AtomicLong();
    private AtomicLong secondLevelCachePutCount = new AtomicLong();
    private AtomicLong queryExecutionCount = new AtomicLong();
    private AtomicLong queryExecutionMaxTime = new AtomicLong();
    private volatile String queryExecutionMaxTimeQueryString;
    private AtomicLong queryCacheHitCount = new AtomicLong();
    private AtomicLong queryCacheMissCount = new AtomicLong();
    private AtomicLong queryCachePutCount = new AtomicLong();
    private AtomicLong commitedTransactionCount = new AtomicLong();
    private AtomicLong transactionCount = new AtomicLong();
    private AtomicLong optimisticFailureCount = new AtomicLong();
    private final ConcurrentMap secondLevelCacheStatistics = new ConcurrentHashMap();
    private final ConcurrentMap entityStatistics = new ConcurrentHashMap();
    private final ConcurrentMap collectionStatistics = new ConcurrentHashMap();
    private final ConcurrentMap queryStatistics = new ConcurrentHashMap();

    public ConcurrentStatisticsImpl() {
        this.clear();
    }

    public ConcurrentStatisticsImpl(SessionFactoryImplementor sessionFactory) {
        this.clear();
        this.sessionFactory = sessionFactory;
    }

    public void clear() {
        this.secondLevelCacheHitCount.set(0L);
        this.secondLevelCacheMissCount.set(0L);
        this.secondLevelCachePutCount.set(0L);
        this.sessionCloseCount.set(0L);
        this.sessionOpenCount.set(0L);
        this.flushCount.set(0L);
        this.connectCount.set(0L);
        this.prepareStatementCount.set(0L);
        this.closeStatementCount.set(0L);
        this.entityDeleteCount.set(0L);
        this.entityInsertCount.set(0L);
        this.entityUpdateCount.set(0L);
        this.entityLoadCount.set(0L);
        this.entityFetchCount.set(0L);
        this.collectionRemoveCount.set(0L);
        this.collectionUpdateCount.set(0L);
        this.collectionRecreateCount.set(0L);
        this.collectionLoadCount.set(0L);
        this.collectionFetchCount.set(0L);
        this.queryExecutionCount.set(0L);
        this.queryCacheHitCount.set(0L);
        this.queryExecutionMaxTime.set(0L);
        this.queryExecutionMaxTimeQueryString = null;
        this.queryCacheMissCount.set(0L);
        this.queryCachePutCount.set(0L);
        this.transactionCount.set(0L);
        this.commitedTransactionCount.set(0L);
        this.optimisticFailureCount.set(0L);
        this.secondLevelCacheStatistics.clear();
        this.entityStatistics.clear();
        this.collectionStatistics.clear();
        this.queryStatistics.clear();
        this.startTime = System.currentTimeMillis();
    }

    public void openSession() {
        this.sessionOpenCount.getAndIncrement();
    }

    public void closeSession() {
        this.sessionCloseCount.getAndIncrement();
    }

    public void flush() {
        this.flushCount.getAndIncrement();
    }

    public void connect() {
        this.connectCount.getAndIncrement();
    }

    public void loadEntity(String entityName) {
        this.entityLoadCount.getAndIncrement();
        ((ConcurrentEntityStatisticsImpl)this.getEntityStatistics(entityName)).incrementLoadCount();
    }

    public void fetchEntity(String entityName) {
        this.entityFetchCount.getAndIncrement();
        ((ConcurrentEntityStatisticsImpl)this.getEntityStatistics(entityName)).incrementFetchCount();
    }

    public EntityStatistics getEntityStatistics(String entityName) {
        ConcurrentEntityStatisticsImpl previous;
        ConcurrentEntityStatisticsImpl es = (ConcurrentEntityStatisticsImpl)this.entityStatistics.get(entityName);
        if (es == null && (previous = this.entityStatistics.putIfAbsent(entityName, es = new ConcurrentEntityStatisticsImpl(entityName))) != null) {
            es = previous;
        }
        return es;
    }

    public void updateEntity(String entityName) {
        this.entityUpdateCount.getAndIncrement();
        ConcurrentEntityStatisticsImpl es = (ConcurrentEntityStatisticsImpl)this.getEntityStatistics(entityName);
        es.incrementUpdateCount();
    }

    public void insertEntity(String entityName) {
        this.entityInsertCount.getAndIncrement();
        ConcurrentEntityStatisticsImpl es = (ConcurrentEntityStatisticsImpl)this.getEntityStatistics(entityName);
        es.incrementInsertCount();
    }

    public void deleteEntity(String entityName) {
        this.entityDeleteCount.getAndIncrement();
        ConcurrentEntityStatisticsImpl es = (ConcurrentEntityStatisticsImpl)this.getEntityStatistics(entityName);
        es.incrementDeleteCount();
    }

    public CollectionStatistics getCollectionStatistics(String role) {
        ConcurrentCollectionStatisticsImpl previous;
        ConcurrentCollectionStatisticsImpl cs = (ConcurrentCollectionStatisticsImpl)this.collectionStatistics.get(role);
        if (cs == null && (previous = this.collectionStatistics.putIfAbsent(role, cs = new ConcurrentCollectionStatisticsImpl(role))) != null) {
            cs = previous;
        }
        return cs;
    }

    public void loadCollection(String role) {
        this.collectionLoadCount.getAndIncrement();
        ((ConcurrentCollectionStatisticsImpl)this.getCollectionStatistics(role)).incrementLoadCount();
    }

    public void fetchCollection(String role) {
        this.collectionFetchCount.getAndIncrement();
        ((ConcurrentCollectionStatisticsImpl)this.getCollectionStatistics(role)).incrementFetchCount();
    }

    public void updateCollection(String role) {
        this.collectionUpdateCount.getAndIncrement();
        ((ConcurrentCollectionStatisticsImpl)this.getCollectionStatistics(role)).incrementUpdateCount();
    }

    public void recreateCollection(String role) {
        this.collectionRecreateCount.getAndIncrement();
        ((ConcurrentCollectionStatisticsImpl)this.getCollectionStatistics(role)).incrementRecreateCount();
    }

    public void removeCollection(String role) {
        this.collectionRemoveCount.getAndIncrement();
        ((ConcurrentCollectionStatisticsImpl)this.getCollectionStatistics(role)).incrementRemoveCount();
    }

    public SecondLevelCacheStatistics getSecondLevelCacheStatistics(String regionName) {
        ConcurrentSecondLevelCacheStatisticsImpl slcs = (ConcurrentSecondLevelCacheStatisticsImpl)this.secondLevelCacheStatistics.get(regionName);
        if (slcs == null) {
            if (this.sessionFactory == null) {
                return null;
            }
            Region region = this.sessionFactory.getSecondLevelCacheRegion(regionName);
            if (region == null) {
                return null;
            }
            slcs = new ConcurrentSecondLevelCacheStatisticsImpl(region);
            ConcurrentSecondLevelCacheStatisticsImpl previous = this.secondLevelCacheStatistics.putIfAbsent(regionName, slcs);
            if (previous != null) {
                slcs = previous;
            }
        }
        return slcs;
    }

    public void secondLevelCachePut(String regionName) {
        this.secondLevelCachePutCount.getAndIncrement();
        ((ConcurrentSecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(regionName)).incrementPutCount();
    }

    public void secondLevelCacheHit(String regionName) {
        this.secondLevelCacheHitCount.getAndIncrement();
        ((ConcurrentSecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(regionName)).incrementHitCount();
    }

    public void secondLevelCacheMiss(String regionName) {
        this.secondLevelCacheMissCount.getAndIncrement();
        ((ConcurrentSecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(regionName)).incrementMissCount();
    }

    public void queryExecuted(String hql, int rows, long time) {
        this.queryExecutionCount.getAndIncrement();
        boolean isLongestQuery = false;
        long old = this.queryExecutionMaxTime.get();
        while (time > old && (isLongestQuery = !this.queryExecutionMaxTime.compareAndSet(old, time))) {
            old = this.queryExecutionMaxTime.get();
        }
        if (isLongestQuery) {
            this.queryExecutionMaxTimeQueryString = hql;
        }
        if (hql != null) {
            ConcurrentQueryStatisticsImpl qs = (ConcurrentQueryStatisticsImpl)this.getQueryStatistics(hql);
            qs.executed(rows, time);
        }
    }

    public void queryCacheHit(String hql, String regionName) {
        this.queryCacheHitCount.getAndIncrement();
        if (hql != null) {
            ConcurrentQueryStatisticsImpl qs = (ConcurrentQueryStatisticsImpl)this.getQueryStatistics(hql);
            qs.incrementCacheHitCount();
        }
        ConcurrentSecondLevelCacheStatisticsImpl slcs = (ConcurrentSecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(regionName);
        slcs.incrementHitCount();
    }

    public void queryCacheMiss(String hql, String regionName) {
        this.queryCacheMissCount.getAndIncrement();
        if (hql != null) {
            ConcurrentQueryStatisticsImpl qs = (ConcurrentQueryStatisticsImpl)this.getQueryStatistics(hql);
            qs.incrementCacheMissCount();
        }
        ConcurrentSecondLevelCacheStatisticsImpl slcs = (ConcurrentSecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(regionName);
        slcs.incrementMissCount();
    }

    public void queryCachePut(String hql, String regionName) {
        this.queryCachePutCount.getAndIncrement();
        if (hql != null) {
            ConcurrentQueryStatisticsImpl qs = (ConcurrentQueryStatisticsImpl)this.getQueryStatistics(hql);
            qs.incrementCachePutCount();
        }
        ConcurrentSecondLevelCacheStatisticsImpl slcs = (ConcurrentSecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(regionName);
        slcs.incrementPutCount();
    }

    public QueryStatistics getQueryStatistics(String queryString) {
        ConcurrentQueryStatisticsImpl previous;
        ConcurrentQueryStatisticsImpl qs = (ConcurrentQueryStatisticsImpl)this.queryStatistics.get(queryString);
        if (qs == null && (previous = this.queryStatistics.putIfAbsent(queryString, qs = new ConcurrentQueryStatisticsImpl(queryString))) != null) {
            qs = previous;
        }
        return qs;
    }

    public long getEntityDeleteCount() {
        return this.entityDeleteCount.get();
    }

    public long getEntityInsertCount() {
        return this.entityInsertCount.get();
    }

    public long getEntityLoadCount() {
        return this.entityLoadCount.get();
    }

    public long getEntityFetchCount() {
        return this.entityFetchCount.get();
    }

    public long getEntityUpdateCount() {
        return this.entityUpdateCount.get();
    }

    public long getQueryExecutionCount() {
        return this.queryExecutionCount.get();
    }

    public long getQueryCacheHitCount() {
        return this.queryCacheHitCount.get();
    }

    public long getQueryCacheMissCount() {
        return this.queryCacheMissCount.get();
    }

    public long getQueryCachePutCount() {
        return this.queryCachePutCount.get();
    }

    public long getFlushCount() {
        return this.flushCount.get();
    }

    public long getConnectCount() {
        return this.connectCount.get();
    }

    public long getSecondLevelCacheHitCount() {
        return this.secondLevelCacheHitCount.get();
    }

    public long getSecondLevelCacheMissCount() {
        return this.secondLevelCacheMissCount.get();
    }

    public long getSecondLevelCachePutCount() {
        return this.secondLevelCachePutCount.get();
    }

    public long getSessionCloseCount() {
        return this.sessionCloseCount.get();
    }

    public long getSessionOpenCount() {
        return this.sessionOpenCount.get();
    }

    public long getCollectionLoadCount() {
        return this.collectionLoadCount.get();
    }

    public long getCollectionFetchCount() {
        return this.collectionFetchCount.get();
    }

    public long getCollectionUpdateCount() {
        return this.collectionUpdateCount.get();
    }

    public long getCollectionRemoveCount() {
        return this.collectionRemoveCount.get();
    }

    public long getCollectionRecreateCount() {
        return this.collectionRecreateCount.get();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void logSummary() {
        log.info("Logging statistics....");
        log.info("start time: " + this.startTime);
        log.info("sessions opened: " + this.sessionOpenCount);
        log.info("sessions closed: " + this.sessionCloseCount);
        log.info("transactions: " + this.transactionCount);
        log.info("successful transactions: " + this.commitedTransactionCount);
        log.info("optimistic lock failures: " + this.optimisticFailureCount);
        log.info("flushes: " + this.flushCount);
        log.info("connections obtained: " + this.connectCount);
        log.info("statements prepared: " + this.prepareStatementCount);
        log.info("statements closed: " + this.closeStatementCount);
        log.info("second level cache puts: " + this.secondLevelCachePutCount);
        log.info("second level cache hits: " + this.secondLevelCacheHitCount);
        log.info("second level cache misses: " + this.secondLevelCacheMissCount);
        log.info("entities loaded: " + this.entityLoadCount);
        log.info("entities updated: " + this.entityUpdateCount);
        log.info("entities inserted: " + this.entityInsertCount);
        log.info("entities deleted: " + this.entityDeleteCount);
        log.info("entities fetched (minimize this): " + this.entityFetchCount);
        log.info("collections loaded: " + this.collectionLoadCount);
        log.info("collections updated: " + this.collectionUpdateCount);
        log.info("collections removed: " + this.collectionRemoveCount);
        log.info("collections recreated: " + this.collectionRecreateCount);
        log.info("collections fetched (minimize this): " + this.collectionFetchCount);
        log.info("queries executed to database: " + this.queryExecutionCount);
        log.info("query cache puts: " + this.queryCachePutCount);
        log.info("query cache hits: " + this.queryCacheHitCount);
        log.info("query cache misses: " + this.queryCacheMissCount);
        log.info("max query time: " + this.queryExecutionMaxTime + "ms");
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean b) {
        this.isStatisticsEnabled = b;
    }

    public long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime.get();
    }

    public String[] getQueries() {
        return ArrayHelper.toStringArray(this.queryStatistics.keySet());
    }

    public String[] getEntityNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.entityStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllClassMetadata().keySet());
    }

    public String[] getCollectionRoleNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.collectionStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllCollectionMetadata().keySet());
    }

    public String[] getSecondLevelCacheRegionNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.secondLevelCacheStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllSecondLevelCacheRegions().keySet());
    }

    public void endTransaction(boolean success) {
        this.transactionCount.getAndIncrement();
        if (success) {
            this.commitedTransactionCount.getAndIncrement();
        }
    }

    public long getSuccessfulTransactionCount() {
        return this.commitedTransactionCount.get();
    }

    public long getTransactionCount() {
        return this.transactionCount.get();
    }

    public void closeStatement() {
        this.closeStatementCount.getAndIncrement();
    }

    public void prepareStatement() {
        this.prepareStatementCount.getAndIncrement();
    }

    public long getCloseStatementCount() {
        return this.closeStatementCount.get();
    }

    public long getPrepareStatementCount() {
        return this.prepareStatementCount.get();
    }

    public void optimisticFailure(String entityName) {
        this.optimisticFailureCount.getAndIncrement();
        ((ConcurrentEntityStatisticsImpl)this.getEntityStatistics(entityName)).incrementOptimisticFailureCount();
    }

    public long getOptimisticFailureCount() {
        return this.optimisticFailureCount.get();
    }

    public String toString() {
        return new StringBuilder().append("Statistics[").append("start time=").append(this.startTime).append(",sessions opened=").append(this.sessionOpenCount).append(",sessions closed=").append(this.sessionCloseCount).append(",transactions=").append(this.transactionCount).append(",successful transactions=").append(this.commitedTransactionCount).append(",optimistic lock failures=").append(this.optimisticFailureCount).append(",flushes=").append(this.flushCount).append(",connections obtained=").append(this.connectCount).append(",statements prepared=").append(this.prepareStatementCount).append(",statements closed=").append(this.closeStatementCount).append(",second level cache puts=").append(this.secondLevelCachePutCount).append(",second level cache hits=").append(this.secondLevelCacheHitCount).append(",second level cache misses=").append(this.secondLevelCacheMissCount).append(",entities loaded=").append(this.entityLoadCount).append(",entities updated=").append(this.entityUpdateCount).append(",entities inserted=").append(this.entityInsertCount).append(",entities deleted=").append(this.entityDeleteCount).append(",entities fetched=").append(this.entityFetchCount).append(",collections loaded=").append(this.collectionLoadCount).append(",collections updated=").append(this.collectionUpdateCount).append(",collections removed=").append(this.collectionRemoveCount).append(",collections recreated=").append(this.collectionRecreateCount).append(",collections fetched=").append(this.collectionFetchCount).append(",queries executed to database=").append(this.queryExecutionCount).append(",query cache puts=").append(this.queryCachePutCount).append(",query cache hits=").append(this.queryCacheHitCount).append(",query cache misses=").append(this.queryCacheMissCount).append(",max query time=").append(this.queryExecutionMaxTime).append(']').toString();
    }

    public String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }
}

