/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.PrimitiveType;

public class DoubleType
extends PrimitiveType {
    public Serializable getDefaultValue() {
        return new Double(0.0);
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        return new Double(rs.getDouble(name));
    }

    public Class getPrimitiveClass() {
        return Double.TYPE;
    }

    public Class getReturnedClass() {
        return Double.class;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setDouble(index, (Double)value);
    }

    public int sqlType() {
        return 8;
    }

    public String getName() {
        return "double";
    }

    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    public Object fromStringValue(String xml) {
        return new Double(xml);
    }
}

