/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Query;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.HashCode;
import org.modeshape.connector.store.jpa.model.common.NamespaceEntity;
import org.modeshape.connector.store.jpa.model.simple.LargeValueEntity;

@Entity
@Table(appliesTo="MODE_SIMPLE_NODE", indexes={@Index(name="NODEUUID_INX", columnNames={"WORKSPACE_ID", "NODE_UUID"}), @Index(name="CHILDINDEX_INX", columnNames={"WORKSPACE_ID", "PARENT_ID", "CHILD_INDEX"}), @Index(name="CHILDNAME_INX", columnNames={"WORKSPACE_ID", "PARENT_ID", "CHILD_NAME_NS_ID", "CHILD_NAME_LOCAL", "SNS_INDEX"})})
@javax.persistence.Table(name="MODE_SIMPLE_NODE")
@NamedQueries(value={@NamedQuery(name="NodeEntity.findByNodeUuid", query="from NodeEntity as node where node.workspaceId = :workspaceId and node.nodeUuidString = :nodeUuidString"), @NamedQuery(name="NodeEntity.findInWorkspace", query="from NodeEntity as node where node.workspaceId = :workspaceId"), @NamedQuery(name="NodeEntity.deleteAllInWorkspace", query="delete from NodeEntity where workspaceId = :workspaceId"), @NamedQuery(name="NodeEntity.withLargeValues", query="from NodeEntity as node where node.workspaceId = :workspaceId and size(node.largeValues) > 0")})
public class NodeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID")
    private long id;
    @Column(name="WORKSPACE_ID", nullable=false)
    private long workspaceId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_ID", referencedColumnName="id", nullable=true)
    private NodeEntity parent;
    @Column(name="NODE_UUID", nullable=false, length=36)
    private String nodeUuidString;
    @Column(name="CHILD_INDEX", nullable=false, unique=false)
    private int indexInParent = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CHILD_NAME_NS_ID", nullable=true)
    private NamespaceEntity childNamespace;
    @Column(name="CHILD_NAME_LOCAL", nullable=true, unique=false, length=512)
    private String childName;
    @Column(name="SNS_INDEX", nullable=false, unique=false)
    private int sameNameSiblingIndex = 1;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parent")
    @OrderBy(value="indexInParent")
    private final List<NodeEntity> children = new ArrayList<NodeEntity>();
    @Column(name="ALLOWS_SNS", nullable=false, unique=false)
    private boolean allowsSameNameChildren;
    @Lob
    @Column(name="DATA", nullable=true, unique=false)
    private byte[] data;
    @Column(name="NUM_PROPS", nullable=false)
    private int propertyCount;
    @Column(name="COMPRESSED", nullable=true)
    private Boolean compressed;
    @Column(name="ENFORCEREFINTEG", nullable=false)
    private boolean referentialIntegrityEnforced = true;
    @ManyToMany
    @JoinTable(name="ModeShape_LARGEVALUE_USAGES", joinColumns={@JoinColumn(name="ID")})
    private final Collection<LargeValueEntity> largeValues = new HashSet<LargeValueEntity>();

    public NodeEntity() {
    }

    public NodeEntity(long id, NodeEntity parent, String nodeUuidString, long workspaceId, int indexInParent, NamespaceEntity ns, String name) {
        this.id = id;
        this.parent = parent;
        this.nodeUuidString = nodeUuidString;
        this.workspaceId = workspaceId;
        this.indexInParent = indexInParent;
        this.childNamespace = ns;
        this.childName = name;
        this.sameNameSiblingIndex = 1;
    }

    public NodeEntity(long id, NodeEntity parent, String nodeUuidString, long workspaceId, int indexInParent, NamespaceEntity ns, String name, int sameNameSiblingIndex) {
        this.id = id;
        this.parent = parent;
        this.nodeUuidString = nodeUuidString;
        this.workspaceId = workspaceId;
        this.indexInParent = indexInParent;
        this.childNamespace = ns;
        this.childName = name;
        this.sameNameSiblingIndex = sameNameSiblingIndex;
    }

    public long getNodeId() {
        return this.id;
    }

    public void setNodeId(long id) {
        this.id = id;
    }

    public NodeEntity getParent() {
        return this.parent;
    }

    public void setParent(NodeEntity parent) {
        this.parent = parent;
    }

    public String getNodeUuidString() {
        return this.nodeUuidString;
    }

    public void setNodeUuidString(String nodeUuidString) {
        this.nodeUuidString = nodeUuidString;
    }

    public long getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(long workspaceId) {
        this.workspaceId = workspaceId;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }

    public void setIndexInParent(int index) {
        this.indexInParent = index;
    }

    public String getChildName() {
        return this.childName;
    }

    public void setChildName(String childName) {
        this.childName = childName;
    }

    public NamespaceEntity getChildNamespace() {
        return this.childNamespace;
    }

    public void setChildNamespace(NamespaceEntity childNamespace) {
        this.childNamespace = childNamespace;
    }

    public int getSameNameSiblingIndex() {
        return this.sameNameSiblingIndex;
    }

    public void setSameNameSiblingIndex(int sameNameSiblingIndex) {
        this.sameNameSiblingIndex = sameNameSiblingIndex;
    }

    public boolean getAllowsSameNameChildren() {
        return this.allowsSameNameChildren;
    }

    public void setAllowsSameNameChildren(boolean allowsSameNameChildren) {
        this.allowsSameNameChildren = allowsSameNameChildren;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public void setPropertyCount(int propertyCount) {
        this.propertyCount = propertyCount;
    }

    public boolean isCompressed() {
        return this.compressed != null && this.compressed != false;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public List<NodeEntity> getChildren() {
        return this.children;
    }

    public void addChild(NodeEntity child) {
        this.children.add(child);
        child.setIndexInParent(this.children.size() - 1);
    }

    public void addChild(int index, NodeEntity child) {
        for (NodeEntity existing : this.children.subList(index, this.children.size() - 1)) {
            existing.setIndexInParent(existing.getIndexInParent() + 1);
        }
        this.children.add(index, child);
        child.setIndexInParent(index);
    }

    public boolean removeChild(int index) {
        NodeEntity removedNode = this.children.remove(index);
        if (removedNode == null) {
            return false;
        }
        removedNode.setParent(null);
        if (index < this.children.size()) {
            for (NodeEntity child : this.children.subList(index, this.children.size() - 1)) {
                child.setIndexInParent(child.getIndexInParent() - 1);
            }
        }
        return true;
    }

    public Collection<LargeValueEntity> getLargeValues() {
        return this.largeValues;
    }

    public boolean isReferentialIntegrityEnforced() {
        return this.referentialIntegrityEnforced;
    }

    public void setReferentialIntegrityEnforced(boolean referentialIntegrityEnforced) {
        this.referentialIntegrityEnforced = referentialIntegrityEnforced;
    }

    public int hashCode() {
        return HashCode.compute(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeEntity) {
            NodeEntity that = (NodeEntity)obj;
            return this.id == that.id;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.childNamespace != null) {
            sb.append('{').append(this.childNamespace).append("}:");
        }
        sb.append(this.childName);
        if (this.sameNameSiblingIndex > 1) {
            sb.append('[').append(this.sameNameSiblingIndex).append(']');
        }
        sb.append(" (id=").append(this.getNodeUuidString()).append(")");
        if (this.parent != null) {
            sb.append(" is ");
            sb.append(Inflector.getInstance().ordinalize(this.indexInParent));
            sb.append(" child of ");
            sb.append(this.parent.getNodeId());
            sb.append(" in workspace ");
            sb.append(this.getWorkspaceId());
        } else {
            sb.append(" is root in workspace ");
            sb.append(this.getWorkspaceId());
        }
        return sb.toString();
    }

    public static void adjustSnsIndexesAndIndexesAfterRemoving(EntityManager entities, Long workspaceId, String uuidParent, String childName, long childNamespaceIndex, int childIndex) {
        Query query = entities.createNamedQuery("NodeEntity.findChildrenAfterIndexUnderParent");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)uuidParent);
        query.setParameter("afterIndex", (Object)childIndex);
        for (NodeEntity entity : query.getResultList()) {
            entity.setIndexInParent(entity.getIndexInParent() - 1);
            if (!entity.getChildName().equals(childName) || entity.getChildNamespace().getId() != childNamespaceIndex) continue;
            entity.setSameNameSiblingIndex(entity.getSameNameSiblingIndex() - 1);
        }
    }

    public static int adjustSnsIndexesAndIndexes(EntityManager entities, Long workspaceId, String uuidParent, int afterIndex, int untilIndex, long childNamespaceIndex, String childName, int modifier) {
        int snsCount = 0;
        Query query = entities.createNamedQuery("NodeEntity.findChildrenAfterIndexUnderParent");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)uuidParent);
        query.setParameter("afterIndex", (Object)afterIndex);
        int index = afterIndex;
        for (NodeEntity entity : query.getResultList()) {
            if (++index > untilIndex) break;
            entity.setIndexInParent(entity.getIndexInParent() + modifier);
            if (!entity.getChildName().equals(childName) || entity.getChildNamespace().getId() != childNamespaceIndex) continue;
            entity.setSameNameSiblingIndex(entity.getSameNameSiblingIndex() + modifier);
            ++snsCount;
        }
        return snsCount;
    }
}

