/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import com.google.common.collect.LinkedListMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.model.simple.SimpleJpaRepository;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapRequestProcessor;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

public class SimpleRequestProcessor
extends MapRequestProcessor {
    private final SimpleJpaRepository repository;
    private final PathFactory pathFactory;

    public SimpleRequestProcessor(ExecutionContext context, SimpleJpaRepository repository, Observer observer, boolean updatesAllowed) {
        super(context, repository, observer, updatesAllowed);
        this.repository = repository;
        this.pathFactory = context.getValueFactories().getPathFactory();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void process(ReadBranchRequest request) {
        MapNode node;
        int i;
        SimpleJpaRepository.Workspace workspace = (SimpleJpaRepository.Workspace)this.getWorkspace(request, request.inWorkspace());
        int maximumDepth = request.maximumDepth();
        List<MapNode> branch = workspace.getBranch(request.at(), maximumDepth);
        if (branch.isEmpty()) {
            Path lowest = null;
            if (request.at().hasPath()) {
                lowest = workspace.getLowestExistingPath(request.at().getPath());
            }
            request.setError(new PathNotFoundException(request.at(), lowest));
            return;
        }
        HashMap<UUID, RequestProcessor.LocationWithDepth> locations = new HashMap<UUID, RequestProcessor.LocationWithDepth>(branch.size());
        MapNode root = branch.get(0);
        Location rootLocation = this.getActualLocation(request.at(), root);
        request.setActualLocationOfNode(rootLocation);
        locations.put(root.getUuid(), new RequestProcessor.LocationWithDepth(this, rootLocation, 0));
        LinkedListMultimap<UUID, Location> childrenByParentUuid = LinkedListMultimap.create();
        for (i = 1; i < branch.size(); ++i) {
            node = branch.get(i);
            UUID parentUuid = node.getParent().getUuid();
            RequestProcessor.LocationWithDepth parentLocation = (RequestProcessor.LocationWithDepth)locations.get(parentUuid);
            Location nodeLocation = this.locationFor(parentLocation.getLocation(), node);
            locations.put(node.getUuid(), new RequestProcessor.LocationWithDepth(this, nodeLocation, parentLocation.getDepth() + 1));
            childrenByParentUuid.put(parentUuid, this.locationFor(((RequestProcessor.LocationWithDepth)locations.get(parentUuid)).getLocation(), node));
        }
        request.setChildren(rootLocation, (List<Location>)childrenByParentUuid.get((Object)root.getUuid()));
        request.setProperties(rootLocation, root.getProperties().values());
        for (i = 1; i < branch.size(); ++i) {
            node = branch.get(i);
            UUID nodeUuid = node.getUuid();
            RequestProcessor.LocationWithDepth nodeLocation = (RequestProcessor.LocationWithDepth)locations.get(nodeUuid);
            if (nodeLocation.getDepth() >= maximumDepth) continue;
            request.setChildren(nodeLocation.getLocation(), (List<Location>)childrenByParentUuid.get((Object)nodeUuid));
            request.setProperties(nodeLocation.getLocation(), node.getProperties().values());
        }
        this.setCacheableInfo(request);
    }

    private Location locationFor(Location parentLocation, MapNode node) {
        return Location.create(this.pathFactory.create(parentLocation.getPath(), node.getName()), node.getUuid());
    }

    @Override
    public void process(CreateWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        if (!this.repository.creatingWorkspacesAllowed()) {
            String msg = JpaConnectorI18n.unableToCreateWorkspaces.text(this.getSourceName());
            request.setError(new InvalidRequestException(msg));
            return;
        }
        super.process(request);
    }

    @Override
    public void process(CloneWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        if (!this.repository.creatingWorkspacesAllowed()) {
            String msg = JpaConnectorI18n.unableToCreateWorkspaces.text(this.getSourceName());
            request.setError(new InvalidRequestException(msg));
            return;
        }
        super.process(request);
    }
}

