/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

@NotThreadSafe
public class RequestProcessorCache {
    private final Map<Long, WorkspaceCache> workspaceCaches = new HashMap<Long, WorkspaceCache>();
    protected final PathFactory pathFactory;

    public RequestProcessorCache(PathFactory pathFactory) {
        assert (pathFactory != null);
        this.pathFactory = pathFactory;
    }

    public Location getLocationFor(Long workspaceId, Path node) {
        WorkspaceCache cache = this.workspaceCaches.get(workspaceId);
        return cache != null ? cache.getLocationFor(node) : null;
    }

    public void addNewNode(Long workspaceId, Location location) {
        WorkspaceCache cache = this.workspaceCaches.get(workspaceId);
        if (cache == null) {
            cache = new WorkspaceCache(workspaceId);
            this.workspaceCaches.put(workspaceId, cache);
        }
        cache.addNewNode(location);
    }

    public void clear(Long workspaceId) {
        this.workspaceCaches.remove(workspaceId);
    }

    public LinkedList<Location> getAllChildren(Long workspaceId, Path parent) {
        WorkspaceCache cache = this.workspaceCaches.get(workspaceId);
        return cache != null ? cache.getAllChildren(parent) : null;
    }

    public void setAllChildren(Long workspaceId, Path parent, LinkedList<Location> children) {
        WorkspaceCache cache = this.workspaceCaches.get(workspaceId);
        if (children == null) {
            if (cache != null) {
                cache.setAllChildren(parent, null);
            }
        } else {
            if (cache == null) {
                cache = new WorkspaceCache(workspaceId);
                this.workspaceCaches.put(workspaceId, cache);
            }
            cache.setAllChildren(parent, children);
        }
    }

    public boolean moveNode(Long workspaceId, Location oldLocation, int oldIndexInParent, Location newLocation) {
        WorkspaceCache cache = this.workspaceCaches.get(workspaceId);
        if (cache == null) {
            return false;
        }
        return cache.moveNode(oldLocation, oldIndexInParent, newLocation);
    }

    public boolean removeBranch(Long workspaceId, Iterable<Location> locations) {
        WorkspaceCache cache = this.workspaceCaches.get(workspaceId);
        return cache != null ? cache.removeBranch(locations) : false;
    }

    public String getString(NamespaceRegistry namespaces) {
        StringBuilder sb = new StringBuilder();
        for (WorkspaceCache cache : this.workspaceCaches.values()) {
            sb.append(cache.getString(namespaces));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getString(null);
    }

    public class WorkspaceCache {
        private final Long workspaceId;
        private final Map<Path, Location> locationByPath = new HashMap<Path, Location>();
        private final Map<Path, LinkedList<Location>> childrenByParentPath = new HashMap<Path, LinkedList<Location>>();

        WorkspaceCache(Long workspaceId) {
            this.workspaceId = workspaceId;
        }

        public Location getLocationFor(Path node) {
            return this.locationByPath.get(node);
        }

        public void addNewNode(Location location) {
            assert (location != null);
            Path path = location.getPath();
            assert (path != null);
            this.locationByPath.put(path, location);
        }

        public LinkedList<Location> getAllChildren(Path parent) {
            return this.childrenByParentPath.get(parent);
        }

        public void setAllChildren(Path parent, LinkedList<Location> children) {
            if (children == null) {
                this.childrenByParentPath.remove(parent);
            } else {
                this.childrenByParentPath.put(parent, children);
            }
        }

        public boolean moveNode(Location oldLocation, int oldIndexInParent, Location newLocation) {
            assert (oldLocation != null);
            Path oldPath = oldLocation.getPath();
            assert (oldPath != null);
            this.removeNodesBelow(oldPath, true);
            LinkedList<Location> siblings = this.childrenByParentPath.get(oldPath.getParent());
            boolean removed = false;
            if (siblings != null) {
                removed = this.removeChildFromParentListOfChildren(siblings, oldLocation, -1);
            }
            if (newLocation != null) {
                Path newPath = newLocation.getPath();
                assert (newPath != null);
                LinkedList<Location> newSiblings = this.childrenByParentPath.get(newPath.getParent());
                if (newSiblings != null) {
                    newSiblings.add(newLocation);
                }
            }
            return removed;
        }

        protected void removeNodesBelow(Path path, boolean removeNodeAtSuppliedPath) {
            Path nextPath;
            if (removeNodeAtSuppliedPath) {
                this.locationByPath.remove(path);
                this.childrenByParentPath.remove(path);
            }
            Iterator<Path> iter = this.locationByPath.keySet().iterator();
            while (iter.hasNext()) {
                nextPath = iter.next();
                if (!nextPath.isDecendantOf(path)) continue;
                iter.remove();
            }
            iter = this.childrenByParentPath.keySet().iterator();
            while (iter.hasNext()) {
                nextPath = iter.next();
                if (!nextPath.isDecendantOf(path)) continue;
                iter.remove();
            }
        }

        public boolean removeBranch(Iterable<Location> locations) {
            if (locations == null) {
                return false;
            }
            Iterator<Location> iter = locations.iterator();
            if (!iter.hasNext()) {
                return false;
            }
            Location topNode = iter.next();
            boolean removed = false;
            while (iter.hasNext()) {
                Location location = iter.next();
                Path path = location.getPath();
                assert (path != null);
                if (this.locationByPath.remove(path) != null) {
                    removed = true;
                }
                if (this.childrenByParentPath.remove(path) == null) continue;
                removed = true;
            }
            Path path = topNode.getPath();
            assert (path != null);
            LinkedList<Location> siblings = this.childrenByParentPath.get(path.getParent());
            if (siblings != null) {
                removed = this.removeChildFromParentListOfChildren(siblings, topNode, -1);
            }
            this.childrenByParentPath.remove(path);
            return removed;
        }

        protected boolean removeChildFromParentListOfChildren(LinkedList<Location> siblings, Location deletedNode, int expectedIndex) {
            Location locationAtExpectedIndex;
            assert (siblings != null);
            Path path = deletedNode.getPath();
            Path parentPath = path.getParent();
            boolean removed = false;
            int index = 0;
            Path.Segment deletedNodeSegment = path.getLastSegment();
            ListIterator<Object> iter = null;
            if (expectedIndex > -1 && expectedIndex < siblings.size() && (locationAtExpectedIndex = siblings.get(expectedIndex)).equals(deletedNode)) {
                siblings.remove(expectedIndex);
                removed = true;
                index = expectedIndex;
            }
            if (!removed) {
                iter = siblings.listIterator();
                while (iter.hasNext()) {
                    Location sibling = (Location)iter.next();
                    Path.Segment segment = sibling.getPath().getLastSegment();
                    if (segment.equals(deletedNodeSegment)) {
                        iter.remove();
                        removed = true;
                        break;
                    }
                    ++index;
                }
            }
            iter = siblings.listIterator(index);
            Name name = deletedNodeSegment.getName();
            while (iter.hasNext()) {
                Location laterSibling = (Location)iter.next();
                Path siblingPath = laterSibling.getPath();
                Path.Segment segment = siblingPath.getLastSegment();
                if (!segment.getName().equals(name)) continue;
                assert (segment.getIndex() > 1);
                Path newPath = RequestProcessorCache.this.pathFactory.create(parentPath, name, segment.getIndex() - 1);
                Location newLocation = laterSibling.with(newPath);
                iter.set(newLocation);
                this.locationByPath.remove(siblingPath);
                this.removeNodesBelow(siblingPath, false);
                this.locationByPath.put(newPath, newLocation);
            }
            return removed;
        }

        public String getString(NamespaceRegistry namespaces) {
            StringBuilder sb = new StringBuilder();
            sb.append("Workspace ");
            sb.append(this.workspaceId);
            sb.append("\n");
            HashSet<Path> pathSet = new HashSet<Path>();
            pathSet.addAll(this.locationByPath.keySet());
            pathSet.addAll(this.childrenByParentPath.keySet());
            ArrayList paths = new ArrayList(pathSet);
            Collections.sort(paths);
            int maxLength = 0;
            for (Path path : paths) {
                String str = this.pathString(path, namespaces);
                maxLength = Math.max(maxLength, str.length());
            }
            for (Path path : paths) {
                LinkedList<Location> children;
                Location loc = this.locationByPath.get(path);
                String str = this.pathString(path, namespaces);
                sb.append(StringUtil.justifyLeft(str, maxLength, ' '));
                if (loc != null) {
                    sb.append("    @" + loc.getUuid());
                }
                if ((children = this.childrenByParentPath.get(path)) != null) {
                    sb.append("\twith children: ");
                    for (int i = 0; i < children.size(); ++i) {
                        Location child = children.get(i);
                        String segmentString = this.pathSegmentString(child.getPath().getLastSegment(), namespaces);
                        sb.append("\n");
                        sb.append(StringUtil.justifyRight(segmentString, maxLength, ' '));
                        sb.append("    @" + child.getUuid());
                    }
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        protected String pathString(Path path, NamespaceRegistry registry) {
            return path.getString(registry, null, null);
        }

        protected String pathSegmentString(Path.Segment segment, NamespaceRegistry registry) {
            return registry != null ? segment.getString(registry) : segment.getString();
        }

        public String toString() {
            return this.getString(null);
        }
    }
}

