/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.component.StandardClassLoaderFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetectors;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.BasicPropertyFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StandardValueFactories;
import org.modeshape.graph.property.basic.ThreadSafeNamespaceRegistry;

@Immutable
public class ExecutionContext
implements ClassLoaderFactory,
Cloneable {
    public static final ExecutionContext DEFAULT_CONTEXT = new ExecutionContext();
    private final ClassLoaderFactory classLoaderFactory;
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;
    private final MimeTypeDetector mimeTypeDetector;
    private final SecurityContext securityContext;
    private final String id = UUID.randomUUID().toString();
    private final Map<String, String> data;

    public ExecutionContext() {
        this(new NullSecurityContext(), null, null, null, null, null, null);
        this.initializeDefaultNamespaces(this.getNamespaceRegistry());
        assert (this.securityContext != null);
    }

    protected ExecutionContext(ExecutionContext original) {
        CheckArg.isNotNull(original, "original");
        this.securityContext = original.getSecurityContext();
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
        this.data = original.getData();
    }

    protected ExecutionContext(ExecutionContext original, SecurityContext securityContext) {
        CheckArg.isNotNull(original, "original");
        CheckArg.isNotNull(securityContext, "securityContext");
        this.securityContext = securityContext;
        this.namespaceRegistry = original.getNamespaceRegistry();
        this.valueFactories = original.getValueFactories();
        this.propertyFactory = original.getPropertyFactory();
        this.classLoaderFactory = original.getClassLoaderFactory();
        this.mimeTypeDetector = original.getMimeTypeDetector();
        this.data = original.getData();
    }

    protected ExecutionContext(SecurityContext securityContext, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory, MimeTypeDetector mimeTypeDetector, ClassLoaderFactory classLoaderFactory, Map<String, String> data) {
        assert (securityContext != null);
        this.securityContext = securityContext;
        this.namespaceRegistry = namespaceRegistry != null ? namespaceRegistry : new ThreadSafeNamespaceRegistry(new SimpleNamespaceRegistry());
        this.valueFactories = valueFactories == null ? new StandardValueFactories(this.namespaceRegistry) : valueFactories;
        this.propertyFactory = propertyFactory == null ? new BasicPropertyFactory(this.valueFactories) : propertyFactory;
        this.classLoaderFactory = classLoaderFactory == null ? new StandardClassLoaderFactory() : classLoaderFactory;
        this.mimeTypeDetector = mimeTypeDetector != null ? mimeTypeDetector : this.createDefaultMimeTypeDetector();
        this.data = data != null ? data : Collections.emptyMap();
    }

    private MimeTypeDetector createDefaultMimeTypeDetector() {
        MimeTypeDetectors detectors = new MimeTypeDetectors();
        detectors.addDetector(ExtensionBasedMimeTypeDetector.CONFIGURATION);
        return detectors;
    }

    protected ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz);
    }

    public Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public MimeTypeDetector getMimeTypeDetector() {
        return this.mimeTypeDetector;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public final PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    @Override
    public ClassLoader getClassLoader(String ... classpath) {
        return this.classLoaderFactory.getClassLoader(classpath);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public ExecutionContext with(NamespaceRegistry namespaceRegistry) {
        return new ExecutionContext(this.getSecurityContext(), namespaceRegistry, null, null, this.getMimeTypeDetector(), this.getClassLoaderFactory(), this.getData());
    }

    public ExecutionContext with(MimeTypeDetector mimeTypeDetector) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), mimeTypeDetector, this.getClassLoaderFactory(), this.getData());
    }

    public ExecutionContext with(ClassLoaderFactory classLoaderFactory) {
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), classLoaderFactory, this.getData());
    }

    public ExecutionContext with(SecurityContext securityContext) {
        return new ExecutionContext(this, securityContext);
    }

    public ExecutionContext with(Map<String, String> data) {
        Map<String, String> newData = data;
        if (data == null) {
            if (this.data.isEmpty()) {
                return this;
            }
        } else {
            newData = Collections.unmodifiableMap(new HashMap<String, String>(data));
        }
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), newData);
    }

    public ExecutionContext with(String key, String value) {
        Map<String, String> newData = this.data;
        if (value == null) {
            if (this.data.isEmpty() || !this.data.containsKey(key)) {
                return this;
            }
            newData = new HashMap<String, String>(this.data);
            newData.remove(key);
            newData = Collections.unmodifiableMap(newData);
        } else {
            newData = new HashMap<String, String>(this.data);
            newData.put(key, value);
            newData = Collections.unmodifiableMap(newData);
        }
        return new ExecutionContext(this.getSecurityContext(), this.getNamespaceRegistry(), this.getValueFactories(), this.getPropertyFactory(), this.getMimeTypeDetector(), this.getClassLoaderFactory(), newData);
    }

    public ExecutionContext clone() {
        return new ExecutionContext(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Execution context for ");
        if (this.getSecurityContext() == null) {
            sb.append("null");
        } else {
            sb.append(this.getSecurityContext().getUserName());
        }
        sb.append(" (").append(this.id).append(')');
        return sb.toString();
    }

    protected void initializeDefaultNamespaces(NamespaceRegistry namespaceRegistry) {
        if (namespaceRegistry == null) {
            return;
        }
        namespaceRegistry.register("jcr", "http://www.jcp.org/jcr/1.0");
        namespaceRegistry.register("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaceRegistry.register("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaceRegistry.register("mode", "http://www.modeshape.org/1.0");
        namespaceRegistry.register("modeint", "http://www.modeshape.org/internal/1.0");
    }

    private static class NullSecurityContext
    implements SecurityContext {
        private NullSecurityContext() {
        }

        @Override
        public String getUserName() {
            return null;
        }

        @Override
        public boolean hasRole(String roleName) {
            return false;
        }

        @Override
        public void logout() {
        }
    }
}

