/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Location;
import org.modeshape.graph.LocationWithProperties;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

@Immutable
final class LocationWithProperty
extends LocationWithProperties {
    private static final long serialVersionUID = 1L;

    LocationWithProperty(Property idProperty) {
        super(Collections.singletonList(idProperty));
        assert (idProperty != null);
        assert (!idProperty.isEmpty());
    }

    @Override
    public final Property getIdProperty(Name name) {
        CheckArg.isNotNull(name, "name");
        Property property = this.getIdProperties().get(0);
        return property.getName().equals(name) ? property : null;
    }

    @Override
    public UUID getUuid() {
        Property property = this.getIdProperties().get(0);
        if (ModeShapeLexicon.UUID.equals(property.getName())) {
            Object value = property.getFirstValue();
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                return UUID.fromString((String)value);
            }
        }
        return null;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        if (newIdProperty.getName().equals(idProperty.getName())) {
            return Location.create(newIdProperty);
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.getIdProperties().size() + 1);
        newIdProperties.add(newIdProperty);
        newIdProperties.addAll(this.getIdProperties());
        return Location.create(newIdProperties);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        return Location.create(newPath, idProperty);
    }

    @Override
    public Location with(UUID uuid) {
        if (uuid == null) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        if (ModeShapeLexicon.UUID.equals(idProperty.getName())) {
            return Location.create(uuid);
        }
        ArrayList<Property> newIdProperties = new ArrayList<Property>(this.getIdProperties().size() + 1);
        newIdProperties.add(new BasicSingleValueProperty(ModeShapeLexicon.UUID, uuid));
        newIdProperties.addAll(this.getIdProperties());
        return Location.create(newIdProperties);
    }
}

