/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import net.jcip.annotations.Immutable;

@Immutable
public class RepositorySourceCapabilities {
    public static final boolean DEFAULT_SUPPORT_SAME_NAME_SIBLINGS = true;
    public static final boolean DEFAULT_SUPPORT_UPDATES = false;
    public static final boolean DEFAULT_SUPPORT_EVENTS = false;
    public static final boolean DEFAULT_SUPPORT_CREATING_WORKSPACES = false;
    public static final boolean DEFAULT_SUPPORT_REFERENCES = true;
    public static final boolean DEFAULT_SUPPORT_QUERIES = false;
    public static final boolean DEFAULT_SUPPORT_SEARCHES = false;
    public static final boolean DEFAULT_SUPPORT_LOCKS = false;
    private final boolean sameNameSiblings;
    private final boolean updates;
    private final boolean events;
    private final boolean creatingWorkspaces;
    private final boolean references;
    private final boolean locks;
    private final boolean queries;
    private final boolean searches;

    public RepositorySourceCapabilities() {
        this(true, false, false, false, true, false, false, false);
    }

    public RepositorySourceCapabilities(RepositorySourceCapabilities capabilities) {
        this(capabilities.supportsSameNameSiblings(), capabilities.supportsUpdates(), capabilities.supportsEvents(), capabilities.supportsCreatingWorkspaces(), capabilities.supportsReferences(), capabilities.supportsLocks(), capabilities.supportsQueries(), capabilities.supportsSearches());
    }

    public RepositorySourceCapabilities(boolean supportsSameNameSiblings, boolean supportsUpdates) {
        this(supportsSameNameSiblings, supportsUpdates, false, false, true, false, false, false);
    }

    public RepositorySourceCapabilities(boolean supportsSameNameSiblings, boolean supportsUpdates, boolean supportsEvents, boolean supportsCreatingWorkspaces, boolean supportsReferences) {
        this(supportsSameNameSiblings, supportsUpdates, supportsEvents, supportsCreatingWorkspaces, supportsReferences, false, false, false);
    }

    public RepositorySourceCapabilities(boolean supportsSameNameSiblings, boolean supportsUpdates, boolean supportsEvents, boolean supportsCreatingWorkspaces, boolean supportsReferences, boolean supportsLocks, boolean supportsQueries, boolean supportsSearches) {
        this.sameNameSiblings = supportsSameNameSiblings;
        this.updates = supportsUpdates;
        this.events = supportsEvents;
        this.creatingWorkspaces = supportsCreatingWorkspaces;
        this.references = supportsReferences;
        this.locks = supportsLocks;
        this.queries = supportsQueries;
        this.searches = supportsSearches;
    }

    public boolean supportsSameNameSiblings() {
        return this.sameNameSiblings;
    }

    public boolean supportsUpdates() {
        return this.updates;
    }

    public boolean supportsReferences() {
        return this.references;
    }

    public boolean supportsEvents() {
        return this.events;
    }

    public boolean supportsCreatingWorkspaces() {
        return this.creatingWorkspaces;
    }

    public boolean supportsLocks() {
        return this.locks;
    }

    public boolean supportsQueries() {
        return this.queries;
    }

    public boolean supportsSearches() {
        return this.searches;
    }
}

