/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.connector.map.DefaultMapNode;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapRepository;
import org.modeshape.graph.connector.map.MapWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.RootPath;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;

public abstract class AbstractMapWorkspace
implements MapWorkspace {
    private final MapRepository repository;
    private final String name;

    protected AbstractMapWorkspace(MapRepository repository, String name) {
        assert (repository != null);
        assert (name != null);
        this.repository = repository;
        this.name = name;
    }

    protected void initialize() {
        MapNode root = this.createMapNode(this.repository.getRootNodeUuid());
        assert (root != null);
        this.addNodeToMap(root);
    }

    protected MapRepository getRepository() {
        return this.repository;
    }

    protected abstract void addNodeToMap(MapNode var1);

    protected abstract MapNode removeNodeFromMap(UUID var1);

    protected abstract void removeAllNodesFromMap();

    @Override
    public abstract MapNode getNode(UUID var1);

    protected MapNode createMapNode(UUID uuid) {
        assert (uuid != null);
        return new DefaultMapNode(uuid);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapNode getRoot() {
        return this.getNode(this.repository.getRootNodeUuid());
    }

    public MapNode getNode(ExecutionContext context, String path) {
        assert (context != null);
        assert (path != null);
        return this.getNode((Path)context.getValueFactories().getPathFactory().create(path));
    }

    @Override
    public MapNode getNode(Path path) {
        assert (path != null);
        MapNode node = this.getRoot();
        for (Path.Segment segment : path) {
            MapNode desiredChild = null;
            for (MapNode child : node.getChildren()) {
                Path.Segment childName;
                if (child == null || (childName = child.getName()) == null || !childName.equals(segment)) continue;
                desiredChild = child;
                break;
            }
            if (desiredChild != null) {
                node = desiredChild;
                continue;
            }
            return null;
        }
        return node;
    }

    @Override
    public Path pathFor(PathFactory pathFactory, MapNode node) {
        assert (node != null);
        assert (pathFactory != null);
        LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
        MapNode root = this.getRoot();
        do {
            segments.addFirst(node.getName());
        } while (!(node = node.getParent()).equals(root));
        return pathFactory.createAbsolutePath(segments);
    }

    @Override
    public Path getLowestExistingPath(Path path) {
        assert (path != null);
        MapNode node = this.getRoot();
        int segmentNumber = 0;
        for (Path.Segment segment : path) {
            MapNode desiredChild = null;
            for (MapNode child : node.getChildren()) {
                Path.Segment childName;
                if (child == null || (childName = child.getName()) == null || !childName.equals(segment)) continue;
                desiredChild = child;
                break;
            }
            if (desiredChild == null) {
                return path.subpath(0, segmentNumber);
            }
            node = desiredChild;
            ++segmentNumber;
        }
        return RootPath.INSTANCE;
    }

    @Override
    public boolean removeNode(ExecutionContext context, MapNode node) {
        assert (context != null);
        assert (node != null);
        if (this.getRoot().equals(node)) {
            this.removeAllNodesFromMap();
            this.addNodeToMap(this.createMapNode(this.repository.getRootNodeUuid()));
            return true;
        }
        MapNode parent = node.getParent();
        assert (parent != null);
        if (!parent.removeChild(node)) {
            return false;
        }
        this.correctSameNameSiblingIndexes(context, parent, node.getName().getName());
        this.removeUuidReference(node);
        return true;
    }

    protected void removeUuidReference(MapNode node) {
        assert (node != null);
        this.removeNodeFromMap(node.getUuid());
        for (MapNode child : node.getChildren()) {
            this.removeUuidReference(child);
        }
    }

    @Override
    public MapNode createNode(ExecutionContext context, String pathToNewNode, Iterable<Property> properties) {
        assert (context != null);
        assert (pathToNewNode != null);
        Path path = (Path)context.getValueFactories().getPathFactory().create(pathToNewNode);
        if (path.isRoot()) {
            return this.getRoot();
        }
        Path parentPath = path.getParent();
        MapNode parentNode = this.getNode(parentPath);
        Name name = path.getLastSegment().getName();
        return this.createNode(context, parentNode, name, null, properties);
    }

    @Override
    public MapNode createNode(ExecutionContext context, MapNode parentNode, Name name, UUID uuid, Iterable<Property> properties) {
        assert (context != null);
        assert (name != null);
        if (parentNode == null) {
            parentNode = this.getRoot();
        }
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        MapNode node = this.createMapNode(uuid);
        int nextIndex = 1;
        Set<Name> uniqueNames = parentNode.getUniqueChildNames();
        if (uniqueNames.contains(name)) {
            List<MapNode> children = parentNode.getChildren();
            ListIterator<MapNode> iter = children.listIterator(children.size());
            while (iter.hasPrevious()) {
                MapNode prev = iter.previous();
                if (!prev.getName().getName().equals(name)) continue;
                nextIndex = prev.getName().getIndex() + 1;
                break;
            }
        }
        Path.Segment newName = context.getValueFactories().getPathFactory().createSegment(name, nextIndex);
        node.setName(newName);
        node.setProperties(properties);
        node.setParent(parentNode);
        parentNode.addChild(node);
        parentNode.getUniqueChildNames().add(name);
        this.addNodeToMap(node);
        return node;
    }

    @Override
    public void moveNode(ExecutionContext context, MapNode node, Name desiredNewName, MapWorkspace newWorkspace, MapNode newParent, MapNode beforeNode) {
        assert (context != null);
        assert (newParent != null);
        assert (node != null);
        assert (newWorkspace instanceof AbstractMapWorkspace);
        AbstractMapWorkspace newAbstractMapWorkspace = (AbstractMapWorkspace)newWorkspace;
        assert (!this.getRoot().equals(node));
        MapNode oldParent = node.getParent();
        Name oldName = node.getName().getName();
        if (this.equals(newAbstractMapWorkspace) && node.getParent().getUuid().equals(newParent.getUuid()) && node.equals(beforeNode)) {
            return;
        }
        if (oldParent != null) {
            boolean removed = oldParent.removeChild(node);
            assert (removed);
            node.setParent(null);
            this.correctSameNameSiblingIndexes(context, oldParent, oldName);
        }
        node.setParent(newParent);
        Name newName = oldName;
        if (desiredNewName != null) {
            newName = desiredNewName;
            node.setName(context.getValueFactories().getPathFactory().createSegment(desiredNewName, 1));
        }
        if (beforeNode == null) {
            newParent.addChild(node);
        } else {
            int index = newParent.getChildren().indexOf(beforeNode);
            newParent.addChild(index, node);
        }
        this.correctSameNameSiblingIndexes(context, newParent, newName);
        if (!this.equals(newAbstractMapWorkspace)) {
            this.moveNodeToWorkspace(node, newAbstractMapWorkspace);
        }
    }

    protected void moveNodeToWorkspace(MapNode node, AbstractMapWorkspace newWorkspace) {
        assert (this.getNode(node.getUuid()) != null);
        assert (newWorkspace.getNode(node.getUuid()) == null);
        this.removeNodeFromMap(node.getUuid());
        newWorkspace.addNodeToMap(node);
        for (MapNode child : node.getChildren()) {
            this.moveNodeToWorkspace(child, newWorkspace);
        }
    }

    @Override
    public MapNode copyNode(ExecutionContext context, MapNode original, MapWorkspace newWorkspace, MapNode newParent, Name desiredName, boolean recursive) {
        HashMap<UUID, UUID> oldToNewUuids = new HashMap<UUID, UUID>();
        MapNode copyRoot = this.copyNode(context, original, newWorkspace, newParent, desiredName, true, oldToNewUuids);
        PropertyFactory propertyFactory = context.getPropertyFactory();
        UuidFactory uuidFactory = context.getValueFactories().getUuidFactory();
        ValueFactory<Reference> referenceFactory = context.getValueFactories().getReferenceFactory();
        for (Map.Entry oldToNew : oldToNewUuids.entrySet()) {
            MapNode oldNode = this.getNode((UUID)oldToNew.getKey());
            MapNode newNode = newWorkspace.getNode((UUID)oldToNew.getValue());
            assert (oldNode != null);
            assert (newNode != null);
            for (Map.Entry<Name, Property> entry : newNode.getProperties().entrySet()) {
                Property property = entry.getValue();
                ArrayList<Reference> newValues = new ArrayList<Reference>();
                boolean foundReference = false;
                Iterator<?> iter = property.getValues();
                while (iter.hasNext()) {
                    Object value = iter.next();
                    PropertyType type = PropertyType.discoverType(value);
                    if (type == PropertyType.REFERENCE) {
                        UUID oldReferencedUuid = (UUID)uuidFactory.create(value);
                        UUID newReferencedUuid = (UUID)oldToNewUuids.get(oldReferencedUuid);
                        if (newReferencedUuid == null) continue;
                        newValues.add(referenceFactory.create(newReferencedUuid));
                        foundReference = true;
                        continue;
                    }
                    newValues.add((Reference)value);
                }
                if (!foundReference) continue;
                Property newProperty = propertyFactory.create(property.getName(), newValues);
                entry.setValue(newProperty);
            }
        }
        return copyRoot;
    }

    protected MapNode copyNode(ExecutionContext context, MapNode original, MapWorkspace newWorkspace, MapNode newParent, Name desiredName, boolean recursive, Map<UUID, UUID> oldToNewUuids) {
        assert (context != null);
        assert (original != null);
        assert (newParent != null);
        assert (newWorkspace != null);
        boolean reuseUuids = oldToNewUuids == null;
        Name childName = desiredName != null ? desiredName : original.getName().getName();
        UUID uuidForCopy = reuseUuids ? original.getUuid() : UUID.randomUUID();
        MapNode copy = newWorkspace.createNode(context, newParent, childName, uuidForCopy, original.getProperties().values());
        if (!reuseUuids) {
            assert (oldToNewUuids != null);
            oldToNewUuids.put(original.getUuid(), copy.getUuid());
        }
        if (recursive) {
            for (MapNode child : original.getChildren()) {
                this.copyNode(context, child, newWorkspace, copy, null, true, oldToNewUuids);
            }
        }
        return copy;
    }

    @Override
    public MapNode cloneNode(ExecutionContext context, MapNode original, MapWorkspace newWorkspace, MapNode newParent, Name desiredName, Path.Segment desiredSegment, boolean removeExisting, Set<Location> removedExistingNodes) throws UuidAlreadyExistsException {
        MapNode existing;
        assert (context != null);
        assert (original != null);
        assert (newWorkspace != null);
        assert (newParent != null);
        Set<UUID> uuidsInFromBranch = this.getUuidsUnderNode(original);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        if (removeExisting) {
            for (UUID uuid : uuidsInFromBranch) {
                existing = newWorkspace.getNode(uuid);
                if (null == existing) continue;
                if (removedExistingNodes != null) {
                    Path path = this.pathFor(pathFactory, existing);
                    removedExistingNodes.add(Location.create(path, uuid));
                }
                newWorkspace.removeNode(context, existing);
            }
        } else {
            uuidsInFromBranch.add(original.getUuid());
            for (UUID uuid : uuidsInFromBranch) {
                existing = newWorkspace.getNode(uuid);
                if (null == existing) continue;
                NamespaceRegistry namespaces = context.getNamespaceRegistry();
                String path = newWorkspace.pathFor(pathFactory, existing).getString(namespaces);
                throw new UuidAlreadyExistsException(this.repository.getSourceName(), uuid, path, newWorkspace.getName());
            }
        }
        if (desiredSegment != null) {
            MapNode newRoot = null;
            for (MapNode child : newParent.getChildren()) {
                if (!desiredSegment.equals(child.getName())) continue;
                newRoot = child;
                break;
            }
            assert (newRoot != null);
            newRoot.getProperties().clear();
            newRoot.setProperties(original.getProperties().values());
            newRoot.clearChildren();
            assert (newRoot.getChildren().isEmpty());
            for (MapNode child : original.getChildren()) {
                this.copyNode(context, child, newWorkspace, newRoot, null, true, null);
            }
            return newRoot;
        }
        existing = newWorkspace.getNode(original.getUuid());
        if (existing != null) {
            if (removedExistingNodes != null) {
                Path path = this.pathFor(pathFactory, existing);
                removedExistingNodes.add(Location.create(path, original.getUuid()));
            }
            newWorkspace.removeNode(context, existing);
        }
        return this.copyNode(context, original, newWorkspace, newParent, desiredName, true, null);
    }

    @Override
    public QueryResults query(ExecutionContext context, AccessQueryRequest accessQuery) {
        return null;
    }

    @Override
    public QueryResults search(ExecutionContext context, String fullTextSearchExpression) {
        return null;
    }

    public Set<UUID> getUuidsUnderNode(MapNode node) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        this.uuidsUnderNode(node, uuids);
        return uuids;
    }

    private void uuidsUnderNode(MapNode node, Set<UUID> accumulator) {
        for (MapNode child : node.getChildren()) {
            accumulator.add(child.getUuid());
            this.uuidsUnderNode(child, accumulator);
        }
    }

    protected void correctSameNameSiblingIndexes(ExecutionContext context, MapNode parentNode, Name name) {
        if (parentNode == null) {
            return;
        }
        LinkedList<MapNode> childrenWithSameNames = new LinkedList<MapNode>();
        for (MapNode child : parentNode.getChildren()) {
            if (!child.getName().getName().equals(name)) continue;
            childrenWithSameNames.add(child);
        }
        if (childrenWithSameNames.size() == 0) {
            return;
        }
        if (childrenWithSameNames.size() == 1) {
            MapNode childWithSameName = (MapNode)childrenWithSameNames.get(0);
            Path.Segment newName = context.getValueFactories().getPathFactory().createSegment(name, 1);
            childWithSameName.setName(newName);
            return;
        }
        int index = 1;
        for (MapNode childWithSameName : childrenWithSameNames) {
            Path.Segment segment = childWithSameName.getName();
            if (segment.getIndex() != index) {
                Path.Segment newName = context.getValueFactories().getPathFactory().createSegment(name, index);
                childWithSameName.setName(newName);
            }
            ++index;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractMapWorkspace) {
            AbstractMapWorkspace that = (AbstractMapWorkspace)obj;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute(this.getName());
    }

    public String toString() {
        return this.repository.getSourceName() + "/" + this.getName();
    }
}

