/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.GuardedBy;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapRepositoryTransaction;
import org.modeshape.graph.connector.map.MapWorkspace;
import org.modeshape.graph.request.CreateWorkspaceRequest;

public abstract class MapRepository {
    protected final UUID rootNodeUuid;
    private final String sourceName;
    private final String defaultWorkspaceName;
    private final Map<String, MapWorkspace> workspaces = new HashMap<String, MapWorkspace>();

    protected MapRepository(String sourceName, UUID rootNodeUuid) {
        this(sourceName, rootNodeUuid, null);
    }

    protected MapRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName) {
        CheckArg.isNotEmpty(sourceName, "sourceName");
        CheckArg.isNotNull(rootNodeUuid, "rootNodeUUID");
        this.rootNodeUuid = rootNodeUuid;
        this.sourceName = sourceName;
        this.defaultWorkspaceName = defaultWorkspaceName != null ? defaultWorkspaceName : "";
    }

    protected void initialize() {
        this.workspaces.put(this.defaultWorkspaceName, this.createWorkspace(null, this.defaultWorkspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE));
    }

    protected String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public final UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    @GuardedBy(value="getLock()")
    public Set<String> getWorkspaceNames() {
        return this.workspaces.keySet();
    }

    @GuardedBy(value="getLock()")
    public MapWorkspace getWorkspace(String name) {
        if (name == null) {
            name = this.defaultWorkspaceName;
        }
        return this.workspaces.get(name);
    }

    @GuardedBy(value="getLock()")
    protected abstract MapWorkspace createWorkspace(ExecutionContext var1, String var2);

    @GuardedBy(value="getLock()")
    public MapWorkspace createWorkspace(ExecutionContext context, String name, CreateWorkspaceRequest.CreateConflictBehavior behavior) {
        String newName = name;
        boolean conflictingName = this.workspaces.containsKey(newName);
        if (conflictingName) {
            switch (behavior) {
                case DO_NOT_CREATE: {
                    return null;
                }
                case CREATE_WITH_ADJUSTED_NAME: {
                    int counter = 0;
                    while (this.workspaces.containsKey(newName = name + ++counter)) {
                    }
                    break;
                }
            }
        }
        assert (!this.workspaces.containsKey(newName));
        MapWorkspace workspace = this.createWorkspace(context, name);
        this.workspaces.put(name, workspace);
        return workspace;
    }

    @GuardedBy(value="getLock()")
    public MapWorkspace createWorkspace(ExecutionContext context, String name, CreateWorkspaceRequest.CreateConflictBehavior existingWorkspaceBehavior, String nameOfWorkspaceToClone) {
        MapWorkspace workspace = this.createWorkspace(context, name, existingWorkspaceBehavior);
        if (workspace == null) {
            return null;
        }
        MapWorkspace original = this.getWorkspace(nameOfWorkspaceToClone);
        if (original != null) {
            MapNode root = workspace.getRoot();
            MapNode origRoot = original.getRoot();
            root.getProperties().clear();
            root.getProperties().putAll(origRoot.getProperties());
            for (MapNode originalNode : origRoot.getChildren()) {
                original.cloneNode(context, originalNode, workspace, root, originalNode.getName().getName(), null, true, null);
            }
        }
        this.workspaces.put(name, workspace);
        return workspace;
    }

    @GuardedBy(value="getLock()")
    public boolean destroyWorkspace(String name) {
        return this.workspaces.remove(name) != null;
    }

    public abstract MapRepositoryTransaction startTransaction(boolean var1);
}

