/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query;

import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.Queryable;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.optimize.Optimizer;
import org.modeshape.graph.query.optimize.RuleBasedOptimizer;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.Planner;
import org.modeshape.graph.query.process.Processor;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.process.QueryResults;

@ThreadSafe
public class QueryEngine
implements Queryable {
    private final Planner planner;
    private final Optimizer optimizer;
    private final Processor processor;

    public QueryEngine(Planner planner, Optimizer optimizer, Processor processor) {
        CheckArg.isNotNull(processor, "processor");
        this.planner = planner != null ? planner : new CanonicalPlanner();
        this.optimizer = optimizer != null ? optimizer : new RuleBasedOptimizer();
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.modeshape.graph.query.QueryResults execute(QueryContext context, QueryCommand query) {
        CheckArg.isNotNull(context, "context");
        CheckArg.isNotNull(query, "query");
        long start = System.nanoTime();
        PlanNode plan = this.planner.createPlan(context, query);
        long duration = System.nanoTime() - start;
        QueryResults.Statistics stats = new QueryResults.Statistics(duration);
        QueryResultColumns resultColumns = QueryResultColumns.empty();
        if (!context.getProblems().hasErrors()) {
            start = System.nanoTime();
            PlanNode optimizedPlan = this.optimizer.optimize(context, plan);
            duration = System.nanoTime() - start;
            stats = stats.withOptimizationTime(duration);
            start = System.nanoTime();
            resultColumns = this.determineQueryResultColumns(optimizedPlan, context.getHints());
            duration = System.nanoTime() - start;
            stats = stats.withOptimizationTime(duration);
            if (!context.getProblems().hasErrors()) {
                try {
                    start = System.nanoTime();
                    org.modeshape.graph.query.QueryResults queryResults = this.processor.execute(context, query, stats, optimizedPlan);
                    return queryResults;
                }
                finally {
                    duration = System.nanoTime() - start;
                    stats = stats.withOptimizationTime(duration);
                }
            }
        }
        return new QueryResults((QueryResults.Columns)resultColumns, stats, context.getProblems());
    }

    protected QueryResultColumns determineQueryResultColumns(PlanNode optimizedPlan, PlanHints hints) {
        PlanNode project = optimizedPlan.findAtOrBelow(PlanNode.Traversal.LEVEL_ORDER, PlanNode.Type.PROJECT);
        if (project != null) {
            List<Column> columns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            List<String> columnTypes = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
            boolean includeFullTextSearchScores = hints.hasFullTextSearch;
            if (!includeFullTextSearchScores) {
                for (PlanNode select : optimizedPlan.findAllAtOrBelow(PlanNode.Type.SELECT)) {
                    Constraint constraint = select.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                    if (!QueryResultColumns.includeFullTextScores(constraint)) continue;
                    includeFullTextSearchScores = true;
                    break;
                }
            }
            return new QueryResultColumns(columns, columnTypes, includeFullTextSearchScores);
        }
        return QueryResultColumns.empty();
    }
}

