/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class Comparison
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand operand1;
    private final StaticOperand operand2;
    private final Operator operator;
    private final int hc;

    public Comparison(DynamicOperand operand1, Operator operator, StaticOperand operand2) {
        CheckArg.isNotNull(operand1, "operand1");
        CheckArg.isNotNull((Object)operator, "operator");
        CheckArg.isNotNull(operand2, "operand2");
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operator = operator;
        this.hc = HashCode.compute(new Object[]{this.operand1, this.operand2, this.operator});
    }

    public DynamicOperand operand1() {
        return this.operand1;
    }

    public StaticOperand operand2() {
        return this.operand2;
    }

    public final Operator operator() {
        return this.operator;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Comparison) {
            Comparison that = (Comparison)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.operator.equals((Object)that.operator)) {
                return false;
            }
            if (!this.operand1.equals(that.operand1)) {
                return false;
            }
            return this.operand2.equals(that.operand2);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

