/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class DescendantNode
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String ancestorPath;

    public DescendantNode(SelectorName selectorName, String ancestorPath) {
        CheckArg.isNotNull(selectorName, "selectorName");
        CheckArg.isNotNull(ancestorPath, "ancestorPath");
        this.selectorName = selectorName;
        this.ancestorPath = ancestorPath;
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public final String ancestorPath() {
        return this.ancestorPath;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.selectorName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DescendantNode) {
            DescendantNode that = (DescendantNode)obj;
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            return this.ancestorPath.equals(that.ancestorPath);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

