/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class SameNode
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String path;
    private final int hc;

    public SameNode(SelectorName selectorName, String path) {
        CheckArg.isNotNull(selectorName, "selectorName");
        CheckArg.isNotNull(path, "path");
        this.selectorName = selectorName;
        this.path = path;
        this.hc = HashCode.compute(this.selectorName, this.path);
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public final String path() {
        return this.path;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SameNode) {
            SameNode that = (SameNode)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            return this.path.equals(that.path);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

