/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import java.util.ArrayList;
import org.modeshape.common.text.TokenStream;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.FullTextSearch;

public class FullTextSearchParser {
    public FullTextSearch.Term parse(String fullTextSearchExpression) {
        CheckArg.isNotNull(fullTextSearchExpression, "fullTextSearchExpression");
        TokenStream.BasicTokenizer tokenizer = TokenStream.basicTokenizer(false);
        TokenStream stream = new TokenStream(fullTextSearchExpression, tokenizer, false);
        return this.parse(stream.start());
    }

    public FullTextSearch.Term parse(TokenStream tokens) {
        FullTextSearch.Term term;
        CheckArg.isNotNull(tokens, "tokens");
        ArrayList<FullTextSearch.Term> terms = new ArrayList<FullTextSearch.Term>();
        while ((term = this.parseDisjunctedTerms(tokens)) != null) {
            terms.add(term);
            if (tokens.canConsume("OR")) continue;
        }
        if (terms.isEmpty()) {
            return null;
        }
        return terms.size() > 1 ? new FullTextSearch.Disjunction(terms) : (FullTextSearch.Term)terms.iterator().next();
    }

    protected FullTextSearch.Term parseDisjunctedTerms(TokenStream tokens) {
        FullTextSearch.Term term;
        ArrayList<FullTextSearch.Term> terms = new ArrayList<FullTextSearch.Term>();
        while ((term = this.parseTerm(tokens)) != null) {
            terms.add(term);
            if (tokens.hasNext() && !tokens.matches("OR")) continue;
        }
        if (terms.isEmpty()) {
            return null;
        }
        return terms.size() > 1 ? new FullTextSearch.Conjunction(terms) : (FullTextSearch.Term)terms.iterator().next();
    }

    protected FullTextSearch.Term parseTerm(TokenStream tokens) {
        boolean negated = tokens.canConsume('-');
        FullTextSearch.SimpleTerm result = new FullTextSearch.SimpleTerm(this.removeQuotes(tokens.consume()));
        return negated ? new FullTextSearch.NegationTerm(result) : result;
    }

    protected String removeQuotes(String text) {
        return text.replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "");
    }
}

