/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class CopyBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_NODE_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location from;
    private final Location into;
    private final String fromWorkspace;
    private final String intoWorkspace;
    private final Name desiredNameForCopy;
    private final NodeConflictBehavior nodeConflictBehavior;
    private Location actualFromLocation;
    private Location actualIntoLocation;

    public CopyBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace) {
        this(from, fromWorkspace, into, intoWorkspace, null, DEFAULT_NODE_CONFLICT_BEHAVIOR);
    }

    public CopyBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy) {
        this(from, fromWorkspace, into, intoWorkspace, nameForCopy, DEFAULT_NODE_CONFLICT_BEHAVIOR);
    }

    public CopyBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy, NodeConflictBehavior nodeConflictBehavior) {
        CheckArg.isNotNull(from, "from");
        CheckArg.isNotNull(into, "into");
        CheckArg.isNotNull(fromWorkspace, "fromWorkspace");
        CheckArg.isNotNull(intoWorkspace, "intoWorkspace");
        CheckArg.isNotNull((Object)nodeConflictBehavior, "nodeConflictBehavior");
        this.from = from;
        this.into = into;
        this.fromWorkspace = fromWorkspace;
        this.intoWorkspace = intoWorkspace;
        this.desiredNameForCopy = nameForCopy;
        this.nodeConflictBehavior = nodeConflictBehavior;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public String fromWorkspace() {
        return this.fromWorkspace;
    }

    public String intoWorkspace() {
        return this.intoWorkspace;
    }

    public boolean isSameWorkspace() {
        return this.fromWorkspace.equals(this.intoWorkspace);
    }

    public Name desiredName() {
        return this.desiredNameForCopy;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public NodeConflictBehavior nodeConflictBehavior() {
        return this.nodeConflictBehavior;
    }

    public void setActualLocations(Location fromLocation, Location intoLocation) {
        this.checkNotFrozen();
        if (!this.from.equals(fromLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(fromLocation, this.from));
        }
        CheckArg.isNotNull(intoLocation, "intoLocation");
        assert (fromLocation != null);
        assert (intoLocation != null);
        if (!fromLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(fromLocation));
        }
        if (!intoLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(intoLocation));
        }
        if (this.into.hasPath() && !intoLocation.getPath().getParent().equals(this.into.getPath())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotChildOfInputLocation.text(intoLocation, this.into));
        }
        this.actualFromLocation = fromLocation;
        this.actualIntoLocation = intoLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualFromLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualIntoLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.intoWorkspace.equals(workspace) && this.into.hasPath() && this.into.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualIntoLocation != null ? this.actualIntoLocation : this.into;
    }

    @Override
    public String changedWorkspace() {
        return this.intoWorkspace();
    }

    public int hashCode() {
        return HashCode.compute(this.from, this.fromWorkspace, this.into, this.intoWorkspace);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualFromLocation = null;
        this.actualIntoLocation = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CopyBranchRequest that = (CopyBranchRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.into().isSame(that.into())) {
                return false;
            }
            if (!this.nodeConflictBehavior().equals((Object)that.nodeConflictBehavior())) {
                return false;
            }
            if (!this.fromWorkspace.equals(that.fromWorkspace)) {
                return false;
            }
            return this.intoWorkspace.equals(that.intoWorkspace);
        }
        return false;
    }

    public String toString() {
        if (this.fromWorkspace.equals(this.intoWorkspace)) {
            if (this.desiredNameForCopy != null) {
                return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " with name " + this.desiredNameForCopy;
            }
            return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into();
        }
        if (this.desiredNameForCopy != null) {
            return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " with name " + this.desiredNameForCopy + " in the \"" + this.intoWorkspace + "\" workspace";
        }
        return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " in the \"" + this.intoWorkspace + "\" workspace";
    }

    @Override
    public CopyBranchRequest clone() {
        CopyBranchRequest result = new CopyBranchRequest(this.actualFromLocation != null ? this.actualFromLocation : this.from, this.fromWorkspace, this.actualIntoLocation != null ? this.actualIntoLocation : this.into, this.intoWorkspace, this.desiredNameForCopy, this.nodeConflictBehavior);
        result.setActualLocations(this.actualFromLocation, this.actualIntoLocation);
        return result;
    }

    @Override
    public RequestType getType() {
        return RequestType.COPY_BRANCH;
    }
}

