/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.RequestType;

public class VerifyNodeExistsRequest
extends CacheableRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private Location actualLocation;

    public VerifyNodeExistsRequest(Location at, String workspaceName) {
        CheckArg.isNotNull(at, "at");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        if (!this.at.equals(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(actual, this.at));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean exists() {
        return this.actualLocation != null;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute(this.at, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            VerifyNodeExistsRequest that = (VerifyNodeExistsRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "verify node exists at " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }

    @Override
    public RequestType getType() {
        return RequestType.VERIFY_NODE_EXISTS;
    }
}

