/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.util;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.util.SchemaGen;

public class SchemaGenTest {
    public static final String MODEL_NAME = JpaSource.Models.SIMPLE.getName();
    private static final File outputPath = new File("target");

    @Before
    public void beforeEach() {
        SchemaGenTest.cleanFiles();
    }

    @AfterClass
    public static void cleanFiles() {
        new File(outputPath, "create.dna-jpa-connector.ddl").delete();
        new File(outputPath, "drop.dna-jpa-connector.ddl").delete();
    }

    private void checkFiles() {
        File createFile = new File(outputPath, "create.dna-jpa-connector.ddl");
        Assert.assertThat((Object)createFile.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)createFile.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        File dropFile = new File(outputPath, "drop.dna-jpa-connector.ddl");
        Assert.assertThat((Object)dropFile.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)dropFile.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void shouldCreateSchemaForHSqlDialect() throws IOException {
        SchemaGen main = new SchemaGen("org.hibernate.dialect.HSQLDialect", MODEL_NAME, outputPath);
        main.generate();
        this.checkFiles();
    }

    @Test
    public void shouldCreateSchemaForOracleDialect() throws IOException {
        SchemaGen main = new SchemaGen("org.hibernate.dialect.Oracle10gDialect", MODEL_NAME, outputPath);
        main.generate();
        this.checkFiles();
    }

    @Test
    public void shouldCreateSchemaForDialectThatIsNotFullyQualified() throws IOException {
        SchemaGen main = new SchemaGen("HSQLDialect", MODEL_NAME, outputPath);
        main.generate();
        this.checkFiles();
    }

    @Test
    public void shouldCreateSchemaForShortFormDialect() throws IOException {
        SchemaGen main = new SchemaGen("HSQL", MODEL_NAME, outputPath);
        main.generate();
        this.checkFiles();
    }
}

