/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.Collections;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Location;
import org.modeshape.graph.LocationWithPathAndProperties;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

@Immutable
class LocationWithPathAndProperty
extends LocationWithPathAndProperties {
    private static final long serialVersionUID = 1L;

    LocationWithPathAndProperty(Path path, Property idProperty) {
        super(path, Collections.singletonList(idProperty));
        assert (idProperty != null);
        assert (!idProperty.isEmpty());
    }

    @Override
    public final Property getIdProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        Property property = this.getIdProperties().get(0);
        return property.getName().equals(name) ? property : null;
    }

    @Override
    public UUID getUuid() {
        Property property = this.getIdProperties().get(0);
        if (ModeShapeLexicon.UUID.equals(property.getName())) {
            Object value = property.getFirstValue();
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                return UUID.fromString((String)value);
            }
        }
        return null;
    }

    @Override
    public final boolean hasIdProperties() {
        return true;
    }

    @Override
    public Location with(Property newIdProperty) {
        if (newIdProperty == null || newIdProperty.isEmpty()) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        if (newIdProperty.getName().equals(idProperty.getName())) {
            return Location.create(this.getPath(), newIdProperty);
        }
        return Location.create(this.getPath(), idProperty, newIdProperty);
    }

    @Override
    public Location with(Path newPath) {
        if (newPath == null) {
            return Location.create(this.getIdProperties());
        }
        if (this.getPath().equals(newPath)) {
            return this;
        }
        Property idProperty = this.getIdProperties().get(0);
        return Location.create(newPath, idProperty);
    }

    @Override
    public Location with(UUID uuid) {
        Property idProperty = this.getIdProperties().get(0);
        if (uuid == null) {
            return Location.create(this.getPath());
        }
        assert (!ModeShapeLexicon.UUID.equals(idProperty.getName()));
        BasicSingleValueProperty newUuidProperty = new BasicSingleValueProperty(ModeShapeLexicon.UUID, uuid);
        return Location.create(this.getPath(), idProperty, newUuidProperty);
    }
}

