/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.PathRepositoryTransaction;
import org.modeshape.graph.connector.path.PathRequestProcessor;
import org.modeshape.graph.request.Request;

public class PathRepositoryConnection
implements RepositoryConnection {
    private final PathRepositorySource source;
    private final PathRepository repository;

    public PathRepositoryConnection(PathRepositorySource source, PathRepository repository) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    @Override
    public String getSourceName() {
        return this.source.getName();
    }

    @Override
    public CachePolicy getDefaultCachePolicy() {
        return this.source.getCachePolicy();
    }

    @Override
    public XAResource getXAResource() {
        return null;
    }

    @Override
    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Logger logger = context.getLogger(this.getClass());
        Stopwatch sw = null;
        if (logger.isTraceEnabled()) {
            sw = new Stopwatch();
            sw.start();
        }
        PathRequestProcessor processor = this.repository.createRequestProcessor(context, this.source);
        PathRepositoryTransaction txn = processor.getTransaction();
        boolean commit = true;
        try {
            processor.process(request);
            if (request.hasError() && !request.isReadOnly()) {
                commit = false;
            }
        }
        catch (Throwable error) {
            commit = false;
        }
        finally {
            try {
                processor.close();
            }
            finally {
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
            }
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace(this.getClass().getSimpleName() + ".execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" " + this.repository.getClass().getSimpleName();
    }
}

