/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.basic.AbstractBinary;

@Immutable
public class InMemoryBinary
extends AbstractBinary {
    private static final long serialVersionUID = 2L;
    private final byte[] bytes;
    private byte[] sha1hash;
    private int hc;

    public InMemoryBinary(byte[] bytes) {
        CheckArg.isNotNull((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    public int hashCode() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.bytes);
            this.hc = this.sha1hash.hashCode();
        }
        return this.hc;
    }

    @Override
    public long getSize() {
        return this.bytes.length;
    }

    @Override
    public byte[] getHash() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.bytes);
            this.hc = this.sha1hash.hashCode();
        }
        return this.sha1hash;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void acquire() {
    }

    @Override
    public void release() {
    }
}

