/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;

@Immutable
public class PushSelectCriteria
implements OptimizerRule {
    public static final PushSelectCriteria INSTANCE = new PushSelectCriteria();
    private static final Set<PlanNode.Type> ORIGINATING_TYPES = Collections.unmodifiableSet(EnumSet.of(PlanNode.Type.NULL, PlanNode.Type.SOURCE, PlanNode.Type.JOIN, PlanNode.Type.SET_OPERATION));

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        HashSet<PlanNode> deadNodes = new HashSet<PlanNode>();
        boolean movedSomeNode = true;
        while (movedSomeNode) {
            movedSomeNode = false;
            List<PlanNode> criteriaNodes = plan.findAllAtOrBelow(PlanNode.Type.SELECT);
            List<PlanNode> originatingNodes = plan.findAllAtOrBelow(ORIGINATING_TYPES);
            Collections.reverse(criteriaNodes);
            for (PlanNode criteriaNode : criteriaNodes) {
                if (deadNodes.contains(criteriaNode)) continue;
                PlanNode originatingNode = this.findOriginatingNode(criteriaNode, originatingNodes);
                if (originatingNode == null || originatingNode == criteriaNode) {
                    deadNodes.add(criteriaNode);
                    continue;
                }
                if (!this.pushTowardsOriginatingNode(criteriaNode, originatingNode)) {
                    deadNodes.add(criteriaNode);
                    continue;
                }
                boolean adjusted = false;
                switch (originatingNode.getType()) {
                    case SOURCE: {
                        break;
                    }
                    case JOIN: {
                        if (criteriaNode.hasAncestorOfType(PlanNode.Type.ACCESS)) break;
                        adjusted = this.pushDownJoinCriteria(criteriaNode, originatingNode);
                        break;
                    }
                }
                if (adjusted) {
                    movedSomeNode = true;
                    continue;
                }
                deadNodes.add(criteriaNode);
            }
        }
        return plan;
    }

    protected boolean pushDownJoinCriteria(PlanNode criteriaNode, PlanNode joinNode) {
        JoinType joinType = (JoinType)joinNode.getProperty(PlanNode.Property.JOIN_TYPE);
        switch (joinType) {
            case CROSS: {
                joinNode.setProperty(PlanNode.Property.JOIN_TYPE, JoinType.INNER);
                this.moveCriteriaIntoOnClause(criteriaNode, joinNode);
                break;
            }
            case INNER: {
                this.moveCriteriaIntoOnClause(criteriaNode, joinNode);
                break;
            }
        }
        return false;
    }

    private void moveCriteriaIntoOnClause(PlanNode criteriaNode, PlanNode joinNode) {
        List<Constraint> constraints = joinNode.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class);
        Constraint criteria = criteriaNode.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
        if (constraints == null || constraints.isEmpty()) {
            constraints = new LinkedList<Constraint>();
            joinNode.setProperty(PlanNode.Property.JOIN_CONSTRAINTS, constraints);
        }
        if (!constraints.contains(criteria)) {
            constraints.add(criteria);
            if (criteriaNode.hasBooleanProperty(PlanNode.Property.IS_DEPENDENT)) {
                joinNode.setProperty(PlanNode.Property.IS_DEPENDENT, Boolean.TRUE);
            }
        }
        criteriaNode.extractFromParent();
    }

    protected PlanNode findOriginatingNode(PlanNode criteriaNode, List<PlanNode> originatingNodes) {
        Set<SelectorName> requiredSelectors = criteriaNode.getSelectors();
        if (requiredSelectors.isEmpty()) {
            return criteriaNode;
        }
        for (PlanNode originatingNode : originatingNodes) {
            if (!criteriaNode.isAbove(originatingNode) || !((Object)originatingNode.getSelectors()).equals(requiredSelectors)) continue;
            return originatingNode;
        }
        for (PlanNode originatingNode : originatingNodes) {
            if (!originatingNode.getSelectors().containsAll(requiredSelectors)) continue;
            return originatingNode;
        }
        return null;
    }

    protected boolean pushTowardsOriginatingNode(PlanNode criteriaNode, PlanNode originatingNode) {
        while (originatingNode.getParent().getType() == PlanNode.Type.SELECT) {
            if ((originatingNode = originatingNode.getParent()) != criteriaNode) continue;
            return false;
        }
        PlanNode bestChild = this.findBestChildForCriteria(criteriaNode, originatingNode);
        if (bestChild == criteriaNode) {
            return false;
        }
        criteriaNode.extractFromParent();
        bestChild.insertAsParent(criteriaNode);
        assert (this.atBoundary(criteriaNode, originatingNode));
        return true;
    }

    protected PlanNode findBestChildForCriteria(PlanNode criteriaNode, PlanNode originatingNode) {
        for (PlanNode node : criteriaNode.getPathTo(originatingNode)) {
            if (!(node.getType() == PlanNode.Type.JOIN ? node.hasAncestorOfType(PlanNode.Type.ACCESS) : node.getType() == PlanNode.Type.LIMIT && node.getChildCount() == 1 && node.getFirstChild().getType() == PlanNode.Type.SORT)) continue;
            return node;
        }
        return originatingNode;
    }

    protected boolean atBoundary(PlanNode criteriaNode, PlanNode originatingNode) {
        for (PlanNode currentNode = originatingNode.getParent(); currentNode != criteriaNode; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == PlanNode.Type.SELECT) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

