/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.SearchRequest;

public class AccessQueryRequest
extends SearchRequest {
    private static final Map<String, Object> EMPTY_VARIABLES = Collections.emptyMap();
    private static final long serialVersionUID = 1L;
    private final String workspaceName;
    private final SelectorName tableName;
    private final List<Constraint> andedConstraints;
    private final Limit limit;
    private final Map<String, Object> variables;
    private final Schemata schemata;
    private final int hc;

    public AccessQueryRequest(String workspace, SelectorName tableName, QueryResults.Columns resultColumns, List<Constraint> andedConstraints, Limit limit, Schemata schemata, Map<String, Object> variables) {
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)tableName, (String)"tableName");
        CheckArg.isNotNull((Object)resultColumns, (String)"resultColumns");
        this.workspaceName = workspace;
        this.tableName = tableName;
        this.andedConstraints = andedConstraints != null ? andedConstraints : Collections.emptyList();
        this.variables = variables != null ? variables : EMPTY_VARIABLES;
        this.limit = limit != null ? limit : Limit.NONE;
        this.schemata = schemata;
        this.doSetResults(resultColumns, null, null);
        this.hc = HashCode.compute((Object[])new Object[]{this.workspaceName, tableName, resultColumns});
    }

    public String workspace() {
        return this.workspaceName;
    }

    public SelectorName selectorName() {
        return this.tableName;
    }

    public QueryResults.Columns resultColumns() {
        return super.columns();
    }

    public List<Constraint> andedConstraints() {
        return this.andedConstraints;
    }

    public Map<String, Object> variables() {
        return this.variables;
    }

    public Schemata schemata() {
        return this.schemata;
    }

    public Limit limit() {
        return this.limit;
    }

    public void setResults(List<Object[]> tuples, QueryResults.Statistics statistics) {
        super.doSetResults(this.columns(), tuples, statistics);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            AccessQueryRequest that = (AccessQueryRequest)obj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            if (!this.workspace().equals(that.workspace())) {
                return false;
            }
            if (!this.selectorName().equals(that.selectorName())) {
                return false;
            }
            if (!this.limit().equals(that.limit())) {
                return false;
            }
            if (!((Object)this.andedConstraints()).equals(that.andedConstraints())) {
                return false;
            }
            if (!this.resultColumns().equals(that.resultColumns())) {
                return false;
            }
            return ((Object)this.variables()).equals(that.variables());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("query '");
        sb.append(this.workspaceName).append("' workspace: SELECT ");
        boolean first = true;
        for (Column column : this.resultColumns().getColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(" FROM ").append(this.selectorName().name());
        if (!this.andedConstraints.isEmpty()) {
            sb.append(" WHERE ");
            first = true;
            for (Constraint constraint : this.andedConstraints) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(Visitors.readable(constraint));
            }
        }
        if (!this.limit.isUnlimited()) {
            sb.append(Visitors.readable(this.limit));
        }
        if (!this.variables.isEmpty()) {
            sb.append(" USING <");
            first = true;
            for (Map.Entry entry : this.variables.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey()).append('=');
                Object value = entry.getValue();
                if (value instanceof String) {
                    sb.append('\"').append(value).append('\"');
                    continue;
                }
                sb.append(value);
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public RequestType getType() {
        return RequestType.ACCESS_QUERY;
    }
}

